/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.prefs;

import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.xbench.core.ApplicationDialog;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.prefs.BooleanPreference;
import edu.mit.broad.xbench.prefs.DirPreference;
import edu.mit.broad.xbench.prefs.FilePreference;
import edu.mit.broad.xbench.prefs.IntPreference;
import edu.mit.broad.xbench.prefs.LinuxBrowserPreference;
import edu.mit.broad.xbench.prefs.Preference;
import edu.mit.broad.xbench.prefs.PreferenceCategory;
import edu.mit.broad.xbench.prefs.StringPreference;
import edu.mit.broad.xbench.prefs.TabPlacementPreference;
import edu.mit.broad.xbench.prefs.XPreferencesFactory$1;
import edu.mit.broad.xbench.prefs.XPreferencesFactory$GenericPrefAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class XPreferencesFactory {
    private static final Logger klog;
    public static File kAppRuntimeHomeDir;
    private static final String GSEA_HOME = "gsea_home";
    public static final DirPreference kCytoscapeDirectory;
    public static String RESOURCES_DATA_FILE_NAME;
    public static final DirPreference kSpecialUserHomeDir;
    public static final DirPreference kRHomeDir;
    public static final StringPreference kFtpServerDomain;
    public static final FilePreference kExcel;
    public static final FilePreference kAcrobat;
    public static final FilePreference kOsExplorer;
    public static final FilePreference kWebBrowser;
    public static final FilePreference kTextPad;
    public static final LinuxBrowserPreference kLinuxWebBrowser;
    public static final StringPreference kEmail;
    public static final BooleanPreference kAskBeforeAppShutdown;
    public static final BooleanPreference kOnlineMode;
    public static final DirPreference kDefaultReportsOutputDir;
    public static final BooleanPreference kSplitFileExplorerDisplay;
    public static final TabPlacementPreference kTabPlacement;
    public static final BooleanPreference kToolDisplayComponent;
    public static final BooleanPreference kToolSelectorComponent;
    public static final PreferenceCategory kGeneralCategory;
    public static final StringPreference kLastToolName;
    private static Dimension screenSize;
    public static final IntPreference kAppWidth;
    public static final IntPreference kAppHeight;
    public static final BooleanPreference kAppMaximized;
    public static final BooleanPreference kMedian;
    public static final BooleanPreference kFixLowVar;
    public static final BooleanPreference kBiasedVar;
    public static final PreferenceCategory kAlgCategory;
    public static PreferenceCategory[] ALL_CATEGORIES;

    public static final int getToolTreeWidth() {
        if (Conf.isGseaApp()) {
            return 300;
        }
        return 250;
    }

    public static final int getToolTreeWidth_min() {
        if (Conf.isGseaApp()) {
            return 150;
        }
        return 150;
    }

    public static final int getToolTreeDivLocation() {
        return 350;
    }

    private XPreferencesFactory() {
    }

    public static final void save() {
        klog.info("Saving preferences to store");
        Preference.kPrefs.flush();
    }

    public static final JCheckBoxMenuItem createCheckBoxMenuItem(BooleanPreference booleanPreference) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(booleanPreference.getName(), (Boolean)booleanPreference.getValue());
        jCheckBoxMenuItem.addItemListener(new XPreferencesFactory$1(booleanPreference, jCheckBoxMenuItem));
        return jCheckBoxMenuItem;
    }

    public static final Object showSetPreferenceDialog(Preference preference) {
        GFieldPlusChooser gFieldPlusChooser = preference.getSelectionComponent();
        String string = "Set preference: " + preference.getName();
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(preference.getName() + ": ");
        jLabel.setFont(GuiHelper.FONT_DEFAULT_BOLD);
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)gFieldPlusChooser.getComponent(), "Center");
        jPanel.add((Component)new JLabel(preference.getDesc()), "South");
        ApplicationDialog applicationDialog = new ApplicationDialog(string, jPanel);
        int n = applicationDialog.show();
        if (n == 0) {
            try {
                preference.setValue(gFieldPlusChooser.getValue());
            }
            catch (Throwable throwable) {
                Application.getWindowManager().showError("Could not set preference: " + preference.getName(), throwable);
                return null;
            }
        }
        return preference.getValue();
    }

    public static final Action createAction(Preference preference) {
        return new XPreferencesFactory$GenericPrefAction(preference);
    }

    public static final Action createAction(Preference preference, Icon icon) {
        return new XPreferencesFactory$GenericPrefAction(preference, icon);
    }

    public static final JButton createActionButton(Preference preference) {
        return new JButton(new XPreferencesFactory$GenericPrefAction(preference));
    }

    static final /* synthetic */ Logger access$000() {
        return klog;
    }

    static {
        boolean bl;
        klog = XLogger.getLogger(XPreferencesFactory.class);
        kCytoscapeDirectory = new DirPreference("Cytoscape Directory", "Directory where cytoscape application is located", new File("Cytoscape not set yet"), false, false);
        kSpecialUserHomeDir = new DirPreference("Special location for gsea_home folder", "Special (non-default) location of gsea_home folder where the applications reads/stores info", SystemUtils.getUserHome(), false, true);
        kAppRuntimeHomeDir = new File(SystemUtils.getUserHome(), GSEA_HOME);
        if (!kAppRuntimeHomeDir.exists() && !(bl = kAppRuntimeHomeDir.mkdir())) {
            klog.fatal("Could not make gsea_home dir at: >" + kAppRuntimeHomeDir + "<");
        }
        RESOURCES_DATA_FILE_NAME = "RdfGseaApp.txt";
        klog.debug("kAppRuntimeHomeDir: " + kAppRuntimeHomeDir + " " + kAppRuntimeHomeDir.exists());
        kRHomeDir = new DirPreference("RHome directory", "Location of the base dir of the R statistical toolkit install", kAppRuntimeHomeDir, false, false);
        kFtpServerDomain = new StringPreference("FTP Server", "The FTP server for LSF Data checks", "gseaftp.broadinstitute.org", false, false);
        kExcel = new FilePreference("Excel.exe", "Location of the the Excel program executable", new File("C:\\Program Files\\Microsoft Office\\Office\\excel.exe"), false, false);
        kAcrobat = new FilePreference("Acrobat.exe", "Location of the Adobe Acrobat program executable", new File("C:\\Program Files\\Adobe\\Acrobat 5.0\\Acrobat\\Acrobat.exe"), true, false);
        kOsExplorer = new FilePreference("Explorer.exe", "Location of the OS File Explorer program executable", new File("C:\\WINDOWS\\explorer.exe"), false, false);
        kWebBrowser = new FilePreference("WebBrowser.exe", "Location of the Web Browser program executable", new File("C:\\Program Files\\Netscape\\Communicator\\Program\\netscape.exe"), false, false);
        kTextPad = new FilePreference("Notepad.exe", "Location of the text editor program executable", new File("C:\\Windows\\System32\\Notepad.exe"), false, false);
        kLinuxWebBrowser = new LinuxBrowserPreference("Web browser for (Linux/UNIX)", "Web browser preference (only for Linux / UNIX)", 0);
        kEmail = new StringPreference("Email Address", "Users email address", SystemUtils.getUserName() + "@change_this.edu", false, false);
        kAskBeforeAppShutdown = new BooleanPreference("Prompt before closing application", "Display a prompt asking for confirmation before shutting down the application", false, false, false);
        kOnlineMode = new BooleanPreference("Connect over the Internet", "You can connect to the GSEA website over the Internet. This ensures you always get the current version of gene sets and chip annotations. ", true, false, false);
        kDefaultReportsOutputDir = new DirPreference("Default reports output folder", "Default location of the output_directory where tool reports are stored", new File(kAppRuntimeHomeDir, "output"), false, false);
        kSplitFileExplorerDisplay = new BooleanPreference("Split file explorer display", "Show one or two different windows in the File Explorer", false, false, false);
        kTabPlacement = new TabPlacementPreference("Tab Placement", "Display location of the tabbed windows created when viewing data / tools", 1);
        kToolDisplayComponent = new BooleanPreference("Display tool in table", "Display the tool in a Table container", false, false, true);
        kToolSelectorComponent = new BooleanPreference("Display tool selector in a tree", "Display the tool selector in a Tree", false, false, true);
        kGeneralCategory = new PreferenceCategory("General Settings", "Miscellaneous Settings", JarResources.getIcon("PreferencesGeneralBig.png"), new Preference[]{kEmail, kAskBeforeAppShutdown, kDefaultReportsOutputDir, kTabPlacement, kToolDisplayComponent, kToolSelectorComponent}, false);
        kLastToolName = new StringPreference("Last Tool Run", "Dont change me", "", true, true);
        screenSize = null;
        try {
            screenSize = !GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getScreenSize() : new Dimension(800, 600);
        }
        catch (Throwable throwable) {
            klog.fatal("Enexpted troube", throwable);
        }
        kAppWidth = new IntPreference("Last app width", "Dont change me", XPreferencesFactory.screenSize.width - 400, false, true);
        kAppHeight = new IntPreference("Last app height", "Dont change me", XPreferencesFactory.screenSize.height - 400, false, true);
        kAppMaximized = new BooleanPreference("app was maximized", "dummy", false, false, true);
        kMedian = new BooleanPreference("Use median instead of mean for class metrics", "Median or mean for distance metrics (such as s2n)", false, false, false);
        kFixLowVar = new BooleanPreference("Fix metrics for low variance", "Adjust for low variances", true, false, false);
        kBiasedVar = new BooleanPreference("Use biased variances", "Use biased mode to calculate variances", false, false, false);
        kAlgCategory = new PreferenceCategory("Algorithm Settings", "Settings for use with Algorithms", JarResources.getIcon("PreferencesAlgBig.png"), new Preference[]{kMedian, kFixLowVar, kBiasedVar}, false);
        ALL_CATEGORIES = Conf.isDebugMode() ? new PreferenceCategory[]{kGeneralCategory, kAlgCategory} : new PreferenceCategory[]{kGeneralCategory, kAlgCategory};
    }
}

