/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.tui.ParamSetDisplay;
import edu.mit.broad.xbench.tui.ToolDisplayFactory;
import edu.mit.broad.xbench.tui.ToolRunnerControl;
import edu.mit.broad.xbench.tui.ToolRunnerControl$DisplayHook;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import xtools.api.Tool;
import xtools.api.param.ParamSet;

public class SingleToolLauncher
extends JPanel
implements Widget,
MouseMotionListener,
ToolRunnerControl$DisplayHook {
    public static final String TITLE = "Tool Launcher";
    public static final Icon ICON = JarResources.getIcon("ToolLauncher.gif");
    private static final Logger klog = XLogger.getLogger(SingleToolLauncher.class);
    private Tool fTool;
    private ParamSet fParamSet;
    private ToolRunnerControl fToolRunner;
    private ParamSetDisplay fDisplay;
    private String fName;
    private boolean fShowTopBufferPanel;
    private boolean fShowLsfOption;
    private boolean fShowHighCpuOption;
    private Icon fIcon;
    private String fTitle;
    private boolean fMakeNormalTheDefault;
    private boolean fShowGrayHelpText;

    public SingleToolLauncher(Tool tool, ParamSet paramSet, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string, Icon icon) {
        if (tool == null) {
            throw new IllegalArgumentException("Param tool cannot be null");
        }
        if (paramSet == null) {
            throw new IllegalArgumentException("Param pset cannot be null");
        }
        this.fTool = tool;
        this.fTitle = string;
        this.fIcon = icon;
        this.fParamSet = paramSet;
        this.fShowTopBufferPanel = bl;
        this.fShowLsfOption = bl2;
        this.fShowHighCpuOption = bl3;
        this.fMakeNormalTheDefault = bl4;
        this.fShowGrayHelpText = bl5;
        this.init();
    }

    @Override
    public final boolean showLsfOption() {
        return this.fShowLsfOption;
    }

    @Override
    public final boolean showHighCpuOption() {
        return this.fShowHighCpuOption;
    }

    private void init() {
        this.jbInit();
    }

    private void jbInit() {
        this.fDisplay = ToolDisplayFactory.createParamSetDisplayComponent(this.fTool.getTitle(), this.fIcon, this.fParamSet, this);
        this.fToolRunner = new ToolRunnerControl(this);
        this.fDisplay.addMouseMotionListener(this);
        this.checkTable();
        this.setLayout(new BorderLayout());
        if (this.fShowTopBufferPanel) {
            JPanel jPanel = new JPanel(new FlowLayout(3));
            JLabel jLabel = new JLabel("<html><body>Initialized to: <b>" + this.fTool.getName() + "</b></body></html>");
            int n = 30;
            jPanel.add(jLabel);
            jPanel.setPreferredSize(new Dimension(this.getWidth(), n));
            this.add((Component)jPanel, "North");
        }
        this.add(Box.createHorizontalStrut(5), "East");
        this.add(Box.createHorizontalStrut(5), "West");
        this.add((Component)new JScrollPane(this.fDisplay.getAsComponent()), "Center");
        this.add((Component)this.fToolRunner, "South");
    }

    @Override
    public final void resetParamSet() {
        this.fDisplay.reset();
    }

    @Override
    public final void setParamSet(ParamSet paramSet) {
        klog.debug("!!! Setting paramset to: " + paramSet);
        if (this.getCurrentTool() != null) {
            this.fDisplay.set(paramSet);
        }
    }

    @Override
    public final Tool getCurrentTool() {
        return this.fTool;
    }

    @Override
    public final ParamSet getCurrentParamSet() {
        return this.fParamSet;
    }

    @Override
    public final boolean isRecordToolRun() {
        return false;
    }

    @Override
    public final boolean showGrayHelptext() {
        return this.fShowGrayHelpText;
    }

    @Override
    public final boolean isDefaultNormal() {
        return this.fMakeNormalTheDefault;
    }

    @Override
    public final JComponent getWindowUI() {
        return this;
    }

    @Override
    public final String getTitle() {
        if (this.fTitle != null) {
            return this.fTitle;
        }
        if (this.fName == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.fTool.getName(), ".");
            while (stringTokenizer.hasMoreTokens()) {
                this.fName = stringTokenizer.nextToken();
            }
        }
        return this.fName;
    }

    @Override
    public final boolean allowClose() {
        return true;
    }

    @Override
    public final JMenuBar getJMenuBar() {
        return Widget.EMPTY_MENU_BAR;
    }

    @Override
    public final Icon getIcon() {
        return this.fIcon;
    }

    private void checkTable() {
        ParamSet paramSet = this.fTool.getParamSet();
        boolean bl = paramSet.isRequiredAllSet();
        this.fToolRunner.setEnabledControls(bl);
    }

    @Override
    public final void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseMoved(MouseEvent mouseEvent) {
        this.checkTable();
    }
}

