/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.SimpleInternalPanel;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import edu.mit.broad.xbench.tui.ParamSetDisplay;
import edu.mit.broad.xbench.tui.ReportStub;
import edu.mit.broad.xbench.tui.TaskManager;
import edu.mit.broad.xbench.tui.ToolDisplayFactory;
import edu.mit.broad.xbench.tui.ToolLauncher;
import edu.mit.broad.xbench.tui.ToolLauncherDefaultImpl$1;
import edu.mit.broad.xbench.tui.ToolLauncherDefaultImpl$2;
import edu.mit.broad.xbench.tui.ToolRunnerControl;
import edu.mit.broad.xbench.tui.ToolRunnerControl$DisplayHook;
import edu.mit.broad.xbench.tui.ToolSelectorComboBox;
import edu.mit.broad.xbench.tui.ToolSelectorTree;
import edu.mit.broad.xbench.tui.ToolSelectorUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import xtools.api.Tool;
import xtools.api.ToolCategory;
import xtools.api.param.ParamSet;

public class ToolLauncherDefaultImpl
extends JPanel
implements ToolLauncher,
MouseMotionListener,
ToolRunnerControl$DisplayHook {
    private String fTitle;
    private Icon fIcon;
    private static final Logger klog = XLogger.getLogger(ToolLauncherDefaultImpl.class);
    private Tool[] fTools;
    private final JSplitPane splitPane;
    private ToolSelectorUI fToolSelectorUI;
    private final Map fToolParamSetDisplayMap;
    private Tool fCurrTool;
    private ToolRunnerControl fToolRunner;
    private final Map fToolCatDescMap;
    private final Map fReportViewerPanelMap;
    private ToolLauncherDefaultImpl fInstance = this;
    private Report fCurrReport;
    private ReportStub fCurrReportStub;
    private boolean fShowLsfOption;
    private boolean fShowHighCpuOption;
    private boolean fShowReportNode;
    private boolean fShowRootNode;
    private boolean fMakeNormalTheDefault;
    private boolean fShowGrayHelpText;
    private static final int LHS_SIZE = 250;
    JScrollPane sp_for_box;

    public ToolLauncherDefaultImpl(Tool[] toolArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Icon icon, String string) {
        this.splitPane = new JSplitPane();
        this.fToolParamSetDisplayMap = new WeakHashMap();
        this.fToolCatDescMap = new WeakHashMap();
        this.fReportViewerPanelMap = new WeakHashMap();
        this.fShowLsfOption = bl;
        this.fShowHighCpuOption = bl2;
        this.fShowReportNode = bl3;
        this.fShowRootNode = bl4;
        this.fShowGrayHelpText = bl7;
        this.fMakeNormalTheDefault = bl6;
        this.fIcon = icon;
        this.fTitle = string;
        this.init(toolArray, bl5);
    }

    public ToolLauncherDefaultImpl() {
        this(null, true, true, true, true, true, true, true, null, null);
    }

    private void init(Tool[] toolArray, boolean bl) {
        if (toolArray == null) {
            throw new IllegalArgumentException("Param tools cannot be null");
        }
        this.fTools = toolArray;
        for (int i2 = 0; i2 < this.fTools.length; ++i2) {
            ToolCategory toolCategory = this.fTools[i2].getCategory();
            if (this.fToolCatDescMap.get(toolCategory) == null) {
                this.fToolCatDescMap.put(toolCategory, new StringBuffer(toolCategory.getDesc()).append("\n\n"));
            }
            StringBuffer stringBuffer = (StringBuffer)this.fToolCatDescMap.get(toolCategory);
            stringBuffer.append(this.fTools[i2].getName()).append('\n').append(this.fTools[i2].getDesc()).append("\n\n");
        }
        this.jbInit(bl, this.fTitle);
        if (this.fToolSelectorUI instanceof ToolSelectorTree) {
            ToolSelectorTree toolSelectorTree = (ToolSelectorTree)this.fToolSelectorUI;
            toolSelectorTree.addTreeSelectionListener(new ToolLauncherDefaultImpl$1(this, toolSelectorTree));
        } else if (this.fToolSelectorUI instanceof ToolSelectorComboBox) {
            ToolSelectorComboBox toolSelectorComboBox = (ToolSelectorComboBox)this.fToolSelectorUI;
            toolSelectorComboBox.addActionListener(new ToolLauncherDefaultImpl$2(this, toolSelectorComboBox));
        } else {
            throw new IllegalStateException("Unexpected display: " + this.fToolSelectorUI);
        }
        this.initToLastToolRun();
    }

    @Override
    public final boolean showHighCpuOption() {
        return this.fShowHighCpuOption;
    }

    @Override
    public final boolean showLsfOption() {
        return this.fShowLsfOption;
    }

    @Override
    public final boolean showGrayHelptext() {
        return this.fShowGrayHelpText;
    }

    @Override
    public final boolean isDefaultNormal() {
        return this.fMakeNormalTheDefault;
    }

    private void jbInit(boolean bl, String string) {
        this.splitPane.setOrientation(1);
        this.fToolSelectorUI = ToolDisplayFactory.createToolSelector(this.fTools, this.fShowReportNode, this.fShowRootNode);
        if (this.fToolSelectorUI instanceof ToolSelectorTree) {
            klog.debug("Making ToolSelectorTree");
            JScrollPane jScrollPane = new JScrollPane(this.fToolSelectorUI.getComponent());
            int n = XPreferencesFactory.getToolTreeWidth();
            int n2 = XPreferencesFactory.getToolTreeWidth_min();
            jScrollPane.setPreferredSize(new Dimension(n, this.splitPane.getHeight()));
            jScrollPane.setMinimumSize(new Dimension(n2, 0));
            SimpleInternalPanel simpleInternalPanel = new SimpleInternalPanel(string);
            simpleInternalPanel.setPreferredSize(new Dimension(n - 20, this.splitPane.getHeight() - 20));
            simpleInternalPanel.setMinimumSize(new Dimension(n2, 0));
            simpleInternalPanel.add(jScrollPane);
            this.splitPane.add((Component)simpleInternalPanel, "left");
            this.splitPane.add((Component)GuiHelper.createNaPlaceholder(), "right");
            this.splitPane.setDividerLocation(XPreferencesFactory.getToolTreeDivLocation());
            this.splitPane.setOneTouchExpandable(false);
            this.splitPane.setDividerSize(3);
            this.splitPane.setLastDividerLocation(250);
            this.fToolRunner = new ToolRunnerControl(this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.splitPane, "Center");
            if (bl) {
                this.add((Component)this.fToolRunner, "South");
            }
        } else {
            klog.debug("Making ToolSelectorComboBox");
            this.fToolRunner = new ToolRunnerControl(this, (ToolSelectorComboBox)this.fToolSelectorUI);
            this.setLayout(new BorderLayout());
            this.add((Component)this.fToolRunner, "South");
        }
    }

    private void remake(ParamSetDisplay paramSetDisplay) {
        if (this.sp_for_box != null) {
            this.remove(this.sp_for_box);
        }
        this.sp_for_box = new JScrollPane(paramSetDisplay.getAsComponent());
        this.sp_for_box.setBackground(Color.RED);
        this.sp_for_box.setForeground(Color.GREEN);
        this.add((Component)this.sp_for_box, "Center");
        this.revalidate();
    }

    @Override
    public final void resetParamSet() {
        if (this.getCurrentTool() != null) {
            this.getCurrentParamDisplayComponent().reset();
        }
    }

    @Override
    public final void setParamSet(ParamSet paramSet) {
        try {
            Tool tool;
            this.fCurrTool = tool = TaskManager.createTool(this.getCurrentTool(), paramSet);
            ParamSetDisplay paramSetDisplay = ToolDisplayFactory.createParamSetDisplayComponent(tool, this.fInstance);
            paramSetDisplay.addMouseMotionListener(this.fInstance);
            this.remake(paramSetDisplay);
            this.fInstance.revalidate();
            this.checkTable();
        }
        catch (Throwable throwable) {
            Application.getWindowManager().showError("Could not setParamSet for: " + this.fCurrTool.getName(), throwable);
        }
    }

    @Override
    public final Tool getCurrentTool() {
        return this.fCurrTool;
    }

    @Override
    public final ParamSet getCurrentParamSet() {
        return this.getCurrentTool().getParamSet();
    }

    @Override
    public final boolean isRecordToolRun() {
        return true;
    }

    @Override
    public final JComponent getWindowUI() {
        return this;
    }

    @Override
    public final String getTitle() {
        if (this.fTitle != null) {
            return this.fTitle;
        }
        return "Tool Launcher";
    }

    @Override
    public final boolean allowClose() {
        return true;
    }

    @Override
    public final JMenuBar getJMenuBar() {
        return Widget.EMPTY_MENU_BAR;
    }

    @Override
    public final Icon getIcon() {
        if (this.fIcon == null) {
            return ICON;
        }
        return this.fIcon;
    }

    @Override
    public final void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseMoved(MouseEvent mouseEvent) {
        this.checkTable();
    }

    private void initToLastToolRun() {
        try {
            String string = Application.getToolManager().getLastToolName();
            if (string == null) {
                return;
            }
            this.fToolSelectorUI.selectTool(string);
        }
        catch (Throwable throwable) {
            klog.warn(throwable);
        }
    }

    private ParamSetDisplay getCurrentParamDisplayComponent() {
        Tool tool = this.getCurrentTool();
        if (tool != null) {
            return (ParamSetDisplay)this.fToolParamSetDisplayMap.get(tool);
        }
        return null;
    }

    private void checkTable() {
        ParamSet paramSet = this.fCurrTool.getParamSet();
        boolean bl = paramSet.isRequiredAllSet();
        this.fToolRunner.setEnabledControls(bl);
    }

    private void disableLauncher() {
        this.fToolRunner.setEnabledControls(false);
        this.splitPane.setRightComponent(GuiHelper.createNaPlaceholder());
        this.splitPane.revalidate();
    }

    private void showToolCategoryInfo(ToolCategory toolCategory) {
        this.fToolRunner.setEnabledControls(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(toolCategory.getName(), toolCategory.getIcon(), 2), "North");
        JTextArea jTextArea = new JTextArea(this.fToolCatDescMap.get(toolCategory).toString());
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jPanel.add((Component)new JScrollPane(jTextArea), "Center");
        this.splitPane.setRightComponent(jPanel);
        this.splitPane.revalidate();
    }

    static final /* synthetic */ JSplitPane access$000(ToolLauncherDefaultImpl toolLauncherDefaultImpl) {
        return toolLauncherDefaultImpl.splitPane;
    }

    static final /* synthetic */ Report access$100(ToolLauncherDefaultImpl toolLauncherDefaultImpl) {
        return toolLauncherDefaultImpl.fCurrReport;
    }

    static final /* synthetic */ ReportStub access$200(ToolLauncherDefaultImpl toolLauncherDefaultImpl) {
        return toolLauncherDefaultImpl.fCurrReportStub;
    }

    static final /* synthetic */ void access$300(ToolLauncherDefaultImpl toolLauncherDefaultImpl) {
        toolLauncherDefaultImpl.disableLauncher();
    }

    static final /* synthetic */ Report access$102(ToolLauncherDefaultImpl toolLauncherDefaultImpl, Report report) {
        toolLauncherDefaultImpl.fCurrReport = report;
        return toolLauncherDefaultImpl.fCurrReport;
    }

    static final /* synthetic */ ReportStub access$202(ToolLauncherDefaultImpl toolLauncherDefaultImpl, ReportStub reportStub) {
        toolLauncherDefaultImpl.fCurrReportStub = reportStub;
        return toolLauncherDefaultImpl.fCurrReportStub;
    }

    static final /* synthetic */ Tool access$400(ToolLauncherDefaultImpl toolLauncherDefaultImpl) {
        return toolLauncherDefaultImpl.fCurrTool;
    }

    static final /* synthetic */ Map access$500(ToolLauncherDefaultImpl toolLauncherDefaultImpl) {
        return toolLauncherDefaultImpl.fToolParamSetDisplayMap;
    }

    static final /* synthetic */ ToolLauncherDefaultImpl access$600(ToolLauncherDefaultImpl toolLauncherDefaultImpl) {
        return toolLauncherDefaultImpl.fInstance;
    }

    static final /* synthetic */ Tool access$402(ToolLauncherDefaultImpl toolLauncherDefaultImpl, Tool tool) {
        toolLauncherDefaultImpl.fCurrTool = tool;
        return toolLauncherDefaultImpl.fCurrTool;
    }

    static final /* synthetic */ void access$700(ToolLauncherDefaultImpl toolLauncherDefaultImpl) {
        toolLauncherDefaultImpl.checkTable();
    }

    static final /* synthetic */ void access$800(ToolLauncherDefaultImpl toolLauncherDefaultImpl, ToolCategory toolCategory) {
        toolLauncherDefaultImpl.showToolCategoryInfo(toolCategory);
    }

    static final /* synthetic */ Map access$900(ToolLauncherDefaultImpl toolLauncherDefaultImpl) {
        return toolLauncherDefaultImpl.fReportViewerPanelMap;
    }

    static final /* synthetic */ ToolRunnerControl access$1000(ToolLauncherDefaultImpl toolLauncherDefaultImpl) {
        return toolLauncherDefaultImpl.fToolRunner;
    }

    static final /* synthetic */ void access$1100(ToolLauncherDefaultImpl toolLauncherDefaultImpl, ParamSetDisplay paramSetDisplay) {
        toolLauncherDefaultImpl.remake(paramSetDisplay);
    }
}

