/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.xchoosers;

import com.jidesoft.dialog.ButtonPanel;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateDerivative;
import edu.mit.broad.genome.objects.TemplateDerivatives$AllPairsTemplate;
import edu.mit.broad.genome.objects.TemplateDerivatives$AuxTemplateDerivative;
import edu.mit.broad.genome.objects.TemplateDerivatives$ContTemplateDerivative;
import edu.mit.broad.genome.objects.TemplateDerivatives$OvaOnlyForwardTemplate;
import edu.mit.broad.genome.objects.TemplateDerivatives$OvaTemplate;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateMode;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.RendererFactory2$CommonLookListRenderer;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.DialogDescriptor;
import edu.mit.broad.xbench.xchoosers.TemplateChooserUI$1;
import edu.mit.broad.xbench.xchoosers.TemplateChooserUI$2;
import edu.mit.broad.xbench.xchoosers.TemplateChooserUI$3;
import edu.mit.broad.xbench.xchoosers.TemplateChooserUI$MyItemListener;
import edu.mit.broad.xbench.xchoosers.TemplateChooserUI$Renderer;
import edu.mit.broad.xbench.xchoosers.TemplateCreatorWidgets$GenePhenotype;
import edu.mit.broad.xbench.xchoosers.TemplateCreatorWidgets$OnTheFlyFromSampleNames;
import edu.mit.broad.xbench.xchoosers.TemplateNonAuxBoxModel;
import edu.mit.broad.xbench.xchoosers.TemplateNonAuxBoxModel$TemplateContWrapper;
import edu.mit.broad.xbench.xchoosers.TemplateSelection;
import edu.mit.broad.xbench.xchoosers.TemplateSelectionMultiSource;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class TemplateChooserUI {
    protected JComboBox cbTemplates;
    private Logger log = XLogger.getLogger(TemplateChooserUI.class);
    private boolean fIsMultiAllowed;
    private TemplateMode fMode;
    private JList jlOptions;
    private int fSelectionMode;
    private JPanel chooserPanel;
    private boolean fComboTemplateSourceMode;
    private TemplateCreatorWidgets$OnTheFlyFromSampleNames otf;
    private TemplateCreatorWidgets$GenePhenotype gtf;
    private Map fTemplateOptionsArrayCacheMap = new HashMap();

    public TemplateChooserUI(boolean bl, TemplateMode templateMode) {
        this.fIsMultiAllowed = bl;
        this.fMode = templateMode;
    }

    private void jbInit() {
        this.jlOptions = new JList();
        if (this.fIsMultiAllowed) {
            this.jlOptions.setBorder(BorderFactory.createTitledBorder("Select one or more phenotype(s)"));
        } else {
            this.jlOptions.setBorder(BorderFactory.createTitledBorder("Select one phenotype)"));
        }
        this.jlOptions.setCellRenderer(new TemplateChooserUI$Renderer(this));
        this.setListOptionsInComboMode(false);
        this.fSelectionMode = this.fIsMultiAllowed ? 2 : 0;
        this.cbTemplates = new JComboBox();
        this.cbTemplates.setBorder(BorderFactory.createTitledBorder("Select source file"));
        ComboBoxModel comboBoxModel = ParserFactory.getCache().createBoxModel(Template.class);
        this.cbTemplates.setModel(new TemplateNonAuxBoxModel(comboBoxModel));
        this.cbTemplates.setRenderer(new RendererFactory2$CommonLookListRenderer(true));
        this.cbTemplates.addItemListener(new TemplateChooserUI$MyItemListener(this));
        if (this.cbTemplates.getModel().getSize() > 0) {
            this.cbTemplates.setSelectedIndex(0);
        }
        this.doTemplateSelection(this.cbTemplates.getSelectedItem());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.cbTemplates, "North");
        jPanel.add((Component)new JScrollPane(this.jlOptions), "Center");
        JButton jButton = new JButton("Show phenotypes from all source files");
        jButton.addActionListener(new TemplateChooserUI$1(this));
        this.chooserPanel = new JPanel(new BorderLayout());
        this.chooserPanel.add((Component)jPanel, "Center");
        ButtonPanel buttonPanel = new ButtonPanel(1);
        buttonPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        buttonPanel.addButton(jButton);
        JButton jButton2 = new JButton("Create an on-the-fly phenotype ...");
        jButton2.addActionListener(new TemplateChooserUI$2(this));
        buttonPanel.addButton(jButton2);
        JButton jButton3 = new JButton("Use a gene as the phenotype ...");
        jButton3.addActionListener(new TemplateChooserUI$3(this));
        buttonPanel.addButton(jButton3);
        this.chooserPanel.add((Component)buttonPanel, "South");
    }

    private void setListOptionsInComboMode(boolean bl) {
        if (bl) {
            this.fComboTemplateSourceMode = true;
            this.jlOptions.setForeground(Color.MAGENTA);
        } else {
            this.fComboTemplateSourceMode = false;
            this.jlOptions.setForeground(Color.BLACK);
        }
    }

    private JComponent createChooserPanel(TemplateSelection templateSelection) {
        if (this.chooserPanel == null) {
            this.jbInit();
        }
        TIntArrayList tIntArrayList = new TIntArrayList();
        if (templateSelection != null && !(templateSelection instanceof TemplateSelectionMultiSource) && templateSelection.getMainObject() != null) {
            TemplateDerivative[] templateDerivativeArray = this.createTemplateOptions_safe(templateSelection.getMainObject(), false);
            DefaultListModel<TemplateDerivative> defaultListModel = new DefaultListModel<TemplateDerivative>();
            for (int i2 = 0; i2 < templateDerivativeArray.length; ++i2) {
                defaultListModel.add(i2, templateDerivativeArray[i2]);
            }
            this.jlOptions.setModel(defaultListModel);
            if (templateSelection.getTemplateNames() != null && templateSelection.getTemplateNames().size() < 3) {
                this.jlOptions.setSelectionMode(0);
            } else {
                this.jlOptions.setSelectionMode(this.fSelectionMode);
            }
            if (templateSelection.getTemplateNames() != null) {
                for (Object e2 : templateSelection.getTemplateNames()) {
                    int n = defaultListModel.indexOf(e2);
                    if (n == -1) continue;
                    tIntArrayList.add(n);
                }
            }
        }
        if (tIntArrayList.size() == 0) {
            this.safeSelectFirst(this.jlOptions);
        } else {
            this.jlOptions.setSelectedIndices(tIntArrayList.toNativeArray());
        }
        return this.chooserPanel;
    }

    public final TemplateSelection showChooser(TemplateSelection templateSelection) {
        TemplateSelection templateSelection2;
        JComponent jComponent = this.createChooserPanel(templateSelection);
        String string = "Select a phenotype";
        if (this.fSelectionMode == 2) {
            string = "Select one or more phenotype(s)";
        }
        DialogDescriptor dialogDescriptor = Application.getWindowManager().createDialogDescriptor(string, jComponent, JarResources.createHelpAction("cls"));
        dialogDescriptor.enableDoubleClickableJList(this.jlOptions);
        int n = dialogDescriptor.show();
        if (n == 2) {
            return null;
        }
        Object[] objectArray = this.jlOptions.getSelectedValues();
        if (this.fComboTemplateSourceMode) {
            templateSelection2 = new TemplateSelectionMultiSource();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                templateSelection2.add((TemplateDerivative)objectArray[i2], false, true);
            }
        } else {
            templateSelection2 = new TemplateSelection(this.cbTemplates.getSelectedItem());
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                templateSelection2.add((TemplateDerivative)objectArray[i3], false, false);
            }
        }
        return templateSelection2;
    }

    private TemplateDerivative[] createTemplateOptions_safe(Object object, boolean bl) {
        try {
            if (object instanceof Template) {
                return this.createTemplateOptions_from_template((Template)object, bl);
            }
            if (object instanceof TemplateNonAuxBoxModel$TemplateContWrapper) {
                return this.createTemplateOptions_file_cont(((TemplateNonAuxBoxModel$TemplateContWrapper)object).sourceFile);
            }
            if (object instanceof File) {
                return this.createTemplateOptions_file_cont((File)object);
            }
            throw new IllegalArgumentException("Unknown object: " + object + " " + object.getClass());
        }
        catch (Exception exception) {
            Application.getWindowManager().showError("Error making Template options", exception);
            return new TemplateDerivative[0];
        }
    }

    private TemplateDerivative[] createTemplateOptions_file_cont(File file) {
        if (file == null) {
            return new TemplateDerivative[0];
        }
        this.log.debug("Creating template from source file: " + file.getPath());
        Object v = this.fTemplateOptionsArrayCacheMap.get(file);
        if (v != null) {
            return (TemplateDerivative[])v;
        }
        Template[] templateArray = ParserFactory.readTemplates(file, false, false, true);
        HashSet<Template> hashSet = new HashSet<Template>();
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            hashSet.add(templateArray[i2]);
        }
        templateArray = hashSet.toArray(new Template[hashSet.size()]);
        templateArray = this.qualifyByTypeAndMode(templateArray, false);
        TemplateDerivative[] templateDerivativeArray = new TemplateDerivative[templateArray.length];
        for (int i3 = 0; i3 < templateArray.length; ++i3) {
            templateDerivativeArray[i3] = new TemplateDerivatives$ContTemplateDerivative(templateArray[i3].getName(), file);
        }
        this.fTemplateOptionsArrayCacheMap.put(file, templateDerivativeArray);
        return templateDerivativeArray;
    }

    private TemplateDerivative[] createTemplateOptions_from_template(Template template, boolean bl) {
        if (template == null) {
            return new TemplateDerivative[0];
        }
        Object v = this.fTemplateOptionsArrayCacheMap.get(template);
        if (v != null) {
            return (TemplateDerivative[])v;
        }
        boolean bl2 = true;
        Template[] templateArray = TemplateFactory.extractAllPossibleTemplates(template, bl2);
        templateArray = this.qualifyByTypeAndMode(templateArray, bl);
        ArrayList<TemplateDerivatives$AuxTemplateDerivative> arrayList = new ArrayList<TemplateDerivatives$AuxTemplateDerivative>();
        if (template.isContinuous() || !this.fIsMultiAllowed || template.getNumClasses() > 2) {
            // empty if block
        }
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            arrayList.add(new TemplateDerivatives$AuxTemplateDerivative(templateArray[i2].getName(), template));
        }
        TemplateDerivative[] templateDerivativeArray = arrayList.toArray(new TemplateDerivative[arrayList.size()]);
        this.fTemplateOptionsArrayCacheMap.put(template, templateDerivativeArray);
        return templateDerivativeArray;
    }

    private TemplateDerivative[] createOvaAllPairsTemplateOptions(Template template) {
        try {
            if (template == null) {
                return new TemplateDerivative[0];
            }
            TemplateDerivative[] templateDerivativeArray = new TemplateDerivative[]{};
            if (!template.isContinuous() && this.fIsMultiAllowed && template.getNumClasses() > 2) {
                templateDerivativeArray = new TemplateDerivative[]{new TemplateDerivatives$OvaTemplate(template), new TemplateDerivatives$OvaOnlyForwardTemplate(template), new TemplateDerivatives$AllPairsTemplate(template)};
            }
            return templateDerivativeArray;
        }
        catch (Exception exception) {
            this.log.fatal("Error making Template options", exception);
            return new TemplateDerivative[0];
        }
    }

    private void safeSelectFirst(JList jList) {
        if (jList.getModel().getSize() >= 1) {
            jList.setSelectedIndex(0);
        }
    }

    private void doTemplateSelection(Object object) {
        if (object == null) {
            return;
        }
        TemplateDerivative[] templateDerivativeArray = this.createTemplateOptions_safe(object, true);
        DefaultListModel<TemplateDerivative> defaultListModel = new DefaultListModel<TemplateDerivative>();
        for (int i2 = 0; i2 < templateDerivativeArray.length; ++i2) {
            defaultListModel.add(i2, templateDerivativeArray[i2]);
        }
        this.jlOptions.setModel(defaultListModel);
        if (templateDerivativeArray.length < 3) {
            this.jlOptions.setSelectionMode(0);
        } else {
            this.jlOptions.setSelectionMode(this.fSelectionMode);
        }
        this.safeSelectFirst(this.jlOptions);
    }

    private List qualifyByTypeAndMode(List list, boolean bl) {
        Template[] templateArray = this.qualifyByTypeAndMode(list.toArray(new Template[list.size()]), bl);
        ArrayList<Template> arrayList = new ArrayList<Template>();
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            arrayList.add(templateArray[i2]);
        }
        return arrayList;
    }

    private Template[] qualifyByTypeAndMode(Template[] templateArray, boolean bl) {
        ArrayList<Template> arrayList = new ArrayList<Template>();
        if (this.fMode == TemplateMode.CONTINUOUS_ONLY) {
            for (int i2 = 0; i2 < templateArray.length; ++i2) {
                if (!templateArray[i2].isContinuous()) continue;
                arrayList.add(templateArray[i2]);
            }
        } else if (this.fMode == TemplateMode.CATEGORICAL_2_CLASS_ONLY) {
            for (int i3 = 0; i3 < templateArray.length; ++i3) {
                if (bl) {
                    if (templateArray[i3].isContinuous() || templateArray[i3].getNumClasses() != 2 || templateArray[i3].getName().indexOf(35) == -1) continue;
                    arrayList.add(templateArray[i3]);
                    continue;
                }
                if (templateArray[i3].isContinuous() || templateArray[i3].getNumClasses() != 2) continue;
                arrayList.add(templateArray[i3]);
            }
        } else if (this.fMode == TemplateMode.CATEGORICAL_ONLY) {
            for (int i4 = 0; i4 < templateArray.length; ++i4) {
                if (templateArray[i4].isContinuous()) continue;
                arrayList.add(templateArray[i4]);
            }
        } else if (this.fMode == TemplateMode.UNIPHASE_ONLY) {
            for (int i5 = 0; i5 < templateArray.length; ++i5) {
                if (templateArray[i5].getNumClasses() != 1) continue;
                arrayList.add(templateArray[i5]);
            }
        } else {
            if (this.fMode == TemplateMode.ALL) {
                return templateArray;
            }
            if (this.fMode == TemplateMode.CATEGORICAL_2_CLASS_AND_NUMERIC) {
                int n;
                for (n = 0; n < templateArray.length; ++n) {
                    if (!templateArray[n].isContinuous()) continue;
                    arrayList.add(templateArray[n]);
                }
                for (n = 0; n < templateArray.length; ++n) {
                    if (bl) {
                        if (templateArray[n].isContinuous() || templateArray[n].getNumClasses() != 2 || templateArray[n].getName().indexOf(35) == -1) continue;
                        arrayList.add(templateArray[n]);
                        continue;
                    }
                    if (templateArray[n].isContinuous() || templateArray[n].getNumClasses() != 2) continue;
                    arrayList.add(templateArray[n]);
                }
            } else {
                throw new RuntimeException("Unknown mode: " + this.fMode);
            }
        }
        return arrayList.toArray(new Template[arrayList.size()]);
    }

    static final /* synthetic */ List access$000(TemplateChooserUI templateChooserUI, List list, boolean bl) {
        return templateChooserUI.qualifyByTypeAndMode(list, bl);
    }

    static final /* synthetic */ JList access$100(TemplateChooserUI templateChooserUI) {
        return templateChooserUI.jlOptions;
    }

    static final /* synthetic */ int access$200(TemplateChooserUI templateChooserUI) {
        return templateChooserUI.fSelectionMode;
    }

    static final /* synthetic */ void access$300(TemplateChooserUI templateChooserUI, boolean bl) {
        templateChooserUI.setListOptionsInComboMode(bl);
    }

    static final /* synthetic */ TemplateCreatorWidgets$OnTheFlyFromSampleNames access$400(TemplateChooserUI templateChooserUI) {
        return templateChooserUI.otf;
    }

    static final /* synthetic */ TemplateCreatorWidgets$OnTheFlyFromSampleNames access$402(TemplateChooserUI templateChooserUI, TemplateCreatorWidgets$OnTheFlyFromSampleNames templateCreatorWidgets$OnTheFlyFromSampleNames) {
        templateChooserUI.otf = templateCreatorWidgets$OnTheFlyFromSampleNames;
        return templateChooserUI.otf;
    }

    static final /* synthetic */ TemplateCreatorWidgets$GenePhenotype access$500(TemplateChooserUI templateChooserUI) {
        return templateChooserUI.gtf;
    }

    static final /* synthetic */ TemplateCreatorWidgets$GenePhenotype access$502(TemplateChooserUI templateChooserUI, TemplateCreatorWidgets$GenePhenotype templateCreatorWidgets$GenePhenotype) {
        templateChooserUI.gtf = templateCreatorWidgets$GenePhenotype;
        return templateChooserUI.gtf;
    }

    static final /* synthetic */ void access$600(TemplateChooserUI templateChooserUI, Object object) {
        templateChooserUI.doTemplateSelection(object);
    }

    static final /* synthetic */ boolean access$700(TemplateChooserUI templateChooserUI) {
        return templateChooserUI.fComboTemplateSourceMode;
    }
}

