/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.xchoosers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateImplFromSampleNames;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.SRLayout;
import edu.mit.broad.xbench.core.ObjectBindery;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.xchoosers.TemplateCreatorWidgets$OnTheFlyFromSampleNames$1;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TemplateCreatorWidgets$OnTheFlyFromSampleNames
extends JPanel {
    private JTextArea taClassA;
    private JTextField tfClassA;
    private JTextArea taClassB;
    private JTextField tfClassB;
    private JComboBox cbDataset;
    private Template createdTemplate;

    public TemplateCreatorWidgets$OnTheFlyFromSampleNames() {
        this.jbInit();
    }

    private void jbInit() {
        JPanel jPanel = new JPanel(new SRLayout(2, 15));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel("Class A (sample names must match the dataset)"), "North");
        this.taClassA = new JTextArea(20, 10);
        this.taClassA.setBorder(BorderFactory.createTitledBorder("Samples for class A (one per line)"));
        jPanel2.add((Component)new JScrollPane(this.taClassA), "Center");
        this.tfClassA = new JTextField("ClassA", 20);
        this.tfClassA.setBorder(BorderFactory.createTitledBorder("Enter a brief name for class A"));
        jPanel2.add((Component)this.tfClassA, "South");
        this.taClassB = new JTextArea(20, 10);
        this.taClassB.setBorder(BorderFactory.createTitledBorder("Samples for class B (one per line)"));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel("Class B (and sample names cant be reused)"), "North");
        jPanel3.add((Component)new JScrollPane(this.taClassB), "Center");
        this.tfClassB = new JTextField("ClassB", 20);
        this.tfClassB.setBorder(BorderFactory.createTitledBorder("Enter a brief name for class B"));
        jPanel3.add((Component)this.tfClassB, "South");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout(10, 10));
        JButton jButton = new JButton("Apply to dataset");
        jButton.addActionListener(new TemplateCreatorWidgets$OnTheFlyFromSampleNames$1(this));
        jPanel4.add((Component)jButton, "East");
        this.cbDataset = new JComboBox();
        this.cbDataset.setBorder(BorderFactory.createTitledBorder("Dataset"));
        this.cbDataset.setEditable(false);
        ObjectBindery.bind(this.cbDataset, new Class[]{Dataset.class}, false);
        GuiHelper.safeSelect(this.cbDataset);
        jPanel4.add((Component)this.cbDataset, "Center");
        this.add((Component)jPanel4, "South");
    }

    private void createTemplate() {
        try {
            if (this.taClassA.getText().trim().length() == 0) {
                Application.getWindowManager().showMessage("No sample names specified in class A");
                return;
            }
            if (this.taClassB.getText().trim().length() == 0) {
                Application.getWindowManager().showMessage("No sample names specified in class B");
                return;
            }
            if (this.tfClassA.getText().trim().length() == 0) {
                Application.getWindowManager().showMessage("Invalid (empty) name specified for class A");
                return;
            }
            if (this.tfClassB.getText().trim().length() == 0) {
                Application.getWindowManager().showMessage("Invalid (empty) name specified for class B");
                return;
            }
            Object object = this.cbDataset.getSelectedItem();
            if (object == null) {
                Application.getWindowManager().showMessage("No dataset available. First import a dataset and then apply this phenotype");
                return;
            }
            File file = Application.getVdbManager().getDefaultOutputDir();
            String string = this.tfClassA.getText();
            String string2 = this.tfClassB.getText();
            String string3 = string + "_vs_" + string2 + ".cls";
            File file2 = NamingConventions.createSafeFile(file, string3);
            String[] stringArray = ParseUtils.string2strings(this.taClassA.getText(), "\n\t", false);
            String[] stringArray2 = ParseUtils.string2strings(this.taClassB.getText(), "\n\t", false);
            TemplateImplFromSampleNames templateImplFromSampleNames = new TemplateImplFromSampleNames(string3, string, stringArray, string2, stringArray2);
            this.createdTemplate = templateImplFromSampleNames.createTemplate((Dataset)object);
            ParserFactory.save(templateImplFromSampleNames, file2);
            Application.getWindowManager().showMessage("Successfully made template: " + this.createdTemplate.getName());
        }
        catch (Throwable throwable) {
            Application.getWindowManager().showError("Trouble making template", throwable);
        }
    }

    public final Template getTemplate() {
        if (this.createdTemplate == null) {
            throw new IllegalArgumentException("No template was yet created");
        }
        return this.createdTemplate;
    }

    static final /* synthetic */ void access$000(TemplateCreatorWidgets$OnTheFlyFromSampleNames templateCreatorWidgets$OnTheFlyFromSampleNames) {
        templateCreatorWidgets$OnTheFlyFromSampleNames.createTemplate();
    }
}

