/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.xchoosers;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateDerivative;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class TemplateSelection {
    private Object fMainTemplate_or_mainTemplateFile;
    protected Set fTemplateNamesOrPaths;
    private Logger log = XLogger.getLogger(TemplateSelection.class);

    protected TemplateSelection() {
    }

    public TemplateSelection(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Param mainTemplate_or_mainTemplateFile cannot be null");
        }
        this.fMainTemplate_or_mainTemplateFile = object;
    }

    public final Object getMainObject() {
        return this.fMainTemplate_or_mainTemplateFile;
    }

    public final String getMainName() {
        if (this.fMainTemplate_or_mainTemplateFile instanceof Template) {
            return ((Template)this.fMainTemplate_or_mainTemplateFile).getName();
        }
        return ((File)this.fMainTemplate_or_mainTemplateFile).getName();
    }

    public final Set getTemplateNames() {
        if (this.fTemplateNamesOrPaths == null) {
            this.log.debug("Odd that fTemplateNamesOrPaths is null. fMainTemplate: " + this.fMainTemplate_or_mainTemplateFile);
            return new HashSet();
        }
        return Collections.unmodifiableSet(this.fTemplateNamesOrPaths);
    }

    public final void add(TemplateDerivative templateDerivative, boolean bl, boolean bl2) {
        if (this.fTemplateNamesOrPaths == null) {
            this.fTemplateNamesOrPaths = new HashSet();
        }
        String string = templateDerivative.getName(bl, bl2);
        this.fTemplateNamesOrPaths.add(string);
    }

    public String formatForUI() {
        String string;
        File file;
        if (this.fTemplateNamesOrPaths == null) {
            return null;
        }
        String[] stringArray = this.fTemplateNamesOrPaths.toArray(new String[this.fTemplateNamesOrPaths.size()]);
        if (stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fMainTemplate_or_mainTemplateFile instanceof File) {
            file = (File)this.fMainTemplate_or_mainTemplateFile;
            string = file.getName();
        } else {
            Template template = (Template)this.fMainTemplate_or_mainTemplateFile;
            file = ParserFactory.getCache().isCached(template) ? ParserFactory.getCache().getSourceFile(this.fMainTemplate_or_mainTemplateFile) : new File(template.getName());
            string = ((Template)this.fMainTemplate_or_mainTemplateFile).getName();
        }
        file = AuxUtils.getBaseFileFromAuxFile(file);
        stringBuffer.append(file.getPath());
        if (stringArray.length == 0) {
            return stringBuffer.toString();
        }
        boolean bl = true;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null) continue;
            String string2 = AuxUtils.getAuxNameOnlyNoHash(stringArray[i2]);
            if (!string2.equals(string)) {
                if (bl) {
                    stringBuffer.append('#');
                    bl = false;
                }
                stringBuffer.append(string2);
            }
            if (i2 == stringArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }
}

