/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.pumps;

import foxtrot.EventPump;
import foxtrot.Task;
import foxtrot.pumps.EventFilter;
import foxtrot.pumps.EventFilterable;
import foxtrot.pumps.JDK13QueueEventPump$1;
import foxtrot.pumps.JDK13QueueEventPump$2;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.lang.reflect.Method;
import java.security.AccessController;

public class JDK13QueueEventPump
implements EventPump,
EventFilterable {
    private static final boolean debug = false;
    private EventFilter filter;
    static Class class$java$lang$Throwable;

    public final void setEventFilter(EventFilter eventFilter) {
        this.filter = eventFilter;
    }

    public final EventFilter getEventFilter() {
        return this.filter;
    }

    public final void pumpEvents(Task task) {
        if (task == null) {
            return;
        }
        EventQueue eventQueue = this.getEventQueue();
        while (!task.isCompleted()) {
            try {
                AWTEvent aWTEvent = eventQueue.getNextEvent();
                if (this.filter != null && !this.filter.accept(aWTEvent)) continue;
                try {
                    this.dispatchEvent(eventQueue, aWTEvent);
                }
                catch (Throwable throwable) {
                    this.handleThrowable(throwable);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    protected final void dispatchEvent(EventQueue eventQueue, AWTEvent aWTEvent) {
        Object object = aWTEvent.getSource();
        if (aWTEvent instanceof ActiveEvent) {
            ((ActiveEvent)((Object)aWTEvent)).dispatch();
        } else if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        } else {
            System.err.println("[JDK13QueueEventPump] Unable to dispatch event " + aWTEvent);
        }
    }

    protected final void handleThrowable(Throwable throwable) {
        String string = (String)AccessController.doPrivileged(new JDK13QueueEventPump$1(this));
        if (string != null) {
            try {
                Object obj = Thread.currentThread().getContextClassLoader().loadClass(string).newInstance();
                Method method = obj.getClass().getMethod("handle", class$java$lang$Throwable == null ? (class$java$lang$Throwable = JDK13QueueEventPump.class$("java.lang.Throwable")) : class$java$lang$Throwable);
                method.invoke(obj, throwable);
                return;
            }
            catch (Throwable throwable2) {
                System.err.println("[JDK13QueueEventPump] Exception occurred while invoking AWT exception handler: " + throwable2);
            }
        }
        System.err.println("[JDK13QueueEventPump] Exception occurred during event dispatching:");
        throwable.printStackTrace();
    }

    private EventQueue getEventQueue() {
        return (EventQueue)AccessController.doPrivileged(new JDK13QueueEventPump$2(this));
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

