/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleProcedure;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class TDoubleArrayList
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    protected double[] _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;

    public TDoubleArrayList() {
        this(10);
    }

    public TDoubleArrayList(int n) {
        this._data = new double[n];
        this._pos = 0;
    }

    public TDoubleArrayList(double[] dArray) {
        this(Math.max(dArray.length, 10));
        this.add(dArray);
    }

    public void ensureCapacity(int n) {
        if (n > this._data.length) {
            int n2 = Math.max(this._data.length << 1, n);
            double[] dArray = new double[n2];
            System.arraycopy(this._data, 0, dArray, 0, this._data.length);
            this._data = dArray;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            double[] dArray = new double[this.size()];
            this.toNativeArray(dArray, 0, dArray.length);
            this._data = dArray;
        }
    }

    public void add(double d2) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = d2;
    }

    public void add(double[] dArray) {
        this.add(dArray, 0, dArray.length);
    }

    public void add(double[] dArray, int n, int n2) {
        this.ensureCapacity(this._pos + n2);
        System.arraycopy(dArray, n, this._data, this._pos, n2);
        this._pos += n2;
    }

    public void insert(int n, double d2) {
        if (n == this._pos) {
            this.add(d2);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, n, this._data, n + 1, this._pos - n);
        this._data[n] = d2;
        ++this._pos;
    }

    public void insert(int n, double[] dArray) {
        this.insert(n, dArray, 0, dArray.length);
    }

    public void insert(int n, double[] dArray, int n2, int n3) {
        if (n == this._pos) {
            this.add(dArray, n2, n3);
            return;
        }
        this.ensureCapacity(this._pos + n3);
        System.arraycopy(this._data, n, this._data, n + n3, this._pos - n);
        System.arraycopy(dArray, n2, this._data, n, n3);
        this._pos += n3;
    }

    public double get(int n) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this._data[n];
    }

    public double getQuick(int n) {
        return this._data[n];
    }

    public void set(int n, double d2) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this._data[n] = d2;
    }

    public double getSet(int n, double d2) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        double d3 = this._data[n];
        this._data[n] = d2;
        return d3;
    }

    public void set(int n, double[] dArray) {
        this.set(n, dArray, 0, dArray.length);
    }

    public void set(int n, double[] dArray, int n2, int n3) {
        if (n < 0 || n + n3 > this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(dArray, n2, this._data, n, n3);
    }

    public void setQuick(int n, double d2) {
        this._data[n] = d2;
    }

    public void clear() {
        this.clear(10);
    }

    public void clear(int n) {
        this._data = new double[n];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        this.fill(0.0);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public double remove(int n) {
        double d2 = this.get(n);
        this.remove(n, 1);
        return d2;
    }

    public void remove(int n, int n2) {
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n == 0) {
            System.arraycopy(this._data, n2, this._data, 0, this._pos - n2);
        } else if (this._pos - n2 != n) {
            System.arraycopy(this._data, n + n2, this._data, n, this._pos - (n + n2));
        }
        this._pos -= n2;
    }

    public void transformValues(TDoubleFunction tDoubleFunction) {
        int n = this._pos;
        while (n-- > 0) {
            this._data[n] = tDoubleFunction.execute(this._data[n]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n > n2) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int n3 = n;
        for (int i2 = n2 - 1; n3 < i2; ++n3, --i2) {
            this.swap(n3, i2);
        }
    }

    public void shuffle(Random random) {
        int n = this._pos;
        while (n-- > 1) {
            this.swap(n, random.nextInt(n));
        }
    }

    private final void swap(int n, int n2) {
        double d2 = this._data[n];
        this._data[n] = this._data[n2];
        this._data[n2] = d2;
    }

    public Object clone() {
        TDoubleArrayList tDoubleArrayList = null;
        try {
            tDoubleArrayList = (TDoubleArrayList)super.clone();
            tDoubleArrayList._data = this.toNativeArray();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return tDoubleArrayList;
    }

    public double[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public double[] toNativeArray(int n, int n2) {
        double[] dArray = new double[n2];
        this.toNativeArray(dArray, n, n2);
        return dArray;
    }

    public void toNativeArray(double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(this._data, 0, dArray, n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TDoubleArrayList) {
            TDoubleArrayList tDoubleArrayList = (TDoubleArrayList)object;
            if (tDoubleArrayList.size() != this.size()) {
                return false;
            }
            int n = this._pos;
            while (n-- > 0) {
                if (this._data[n] == tDoubleArrayList._data[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this._pos;
        while (n2-- > 0) {
            n += HashFunctions.hash(this._data[n2]);
        }
        return n;
    }

    public boolean forEach(TDoubleProcedure tDoubleProcedure) {
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (tDoubleProcedure.execute(this._data[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TDoubleProcedure tDoubleProcedure) {
        int n = this._pos;
        while (n-- > 0) {
            if (tDoubleProcedure.execute(this._data[n])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    public void sort(int n, int n2) {
        Arrays.sort(this._data, n, n2);
    }

    public void fill(double d2) {
        Arrays.fill(this._data, 0, this._pos, d2);
    }

    public void fill(int n, int n2, double d2) {
        if (n2 > this._pos) {
            this.ensureCapacity(n2);
            this._pos = n2;
        }
        Arrays.fill(this._data, n, n2, d2);
    }

    public int binarySearch(double d2) {
        return this.binarySearch(d2, 0, this._pos);
    }

    public int binarySearch(double d2, int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 > this._pos) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >> 1;
            double d3 = this._data[n5];
            if (d3 < d2) {
                n3 = n5 + 1;
                continue;
            }
            if (d3 > d2) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public int indexOf(double d2) {
        return this.indexOf(0, d2);
    }

    public int indexOf(int n, double d2) {
        for (int i2 = n; i2 < this._pos; ++i2) {
            if (this._data[i2] != d2) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(double d2) {
        return this.lastIndexOf(this._pos, d2);
    }

    public int lastIndexOf(int n, double d2) {
        int n2 = n;
        while (n2-- > 0) {
            if (this._data[n2] != d2) continue;
            return n2;
        }
        return -1;
    }

    public boolean contains(double d2) {
        return this.lastIndexOf(d2) >= 0;
    }

    public TDoubleArrayList grep(TDoubleProcedure tDoubleProcedure) {
        TDoubleArrayList tDoubleArrayList = new TDoubleArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (!tDoubleProcedure.execute(this._data[i2])) continue;
            tDoubleArrayList.add(this._data[i2]);
        }
        return tDoubleArrayList;
    }

    public TDoubleArrayList inverseGrep(TDoubleProcedure tDoubleProcedure) {
        TDoubleArrayList tDoubleArrayList = new TDoubleArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (tDoubleProcedure.execute(this._data[i2])) continue;
            tDoubleArrayList.add(this._data[i2]);
        }
        return tDoubleArrayList;
    }

    public double max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        double d2 = this._data[this._pos - 1];
        int n = this._pos - 1;
        while (n-- > 0) {
            if (!(this._data[n] > d2)) continue;
            d2 = this._data[n];
        }
        return d2;
    }

    public double min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        double d2 = this._data[this._pos - 1];
        int n = this._pos - 1;
        while (n-- > 0) {
            if (!(this._data[n] < d2)) continue;
            d2 = this._data[n];
        }
        return d2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = this._pos - 1;
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(this._data[i2]);
            stringBuffer.append(", ");
        }
        if (this.size() > 0) {
            stringBuffer.append(this._data[this._pos - 1]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

