/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.PrimeFinder;

public abstract class THash
implements Cloneable {
    protected transient int _size;
    protected transient int _free;
    protected static final float DEFAULT_LOAD_FACTOR = 0.5f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 10;
    protected float _loadFactor;
    protected int _maxSize;

    public THash() {
        this(10, 0.5f);
    }

    public THash(int n) {
        this(n, 0.5f);
    }

    public THash(int n, float f2) {
        this._loadFactor = f2;
        this.setUp((int)Math.ceil((float)n / f2));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final boolean isEmpty() {
        return 0 == this._size;
    }

    public final int size() {
        return this._size;
    }

    protected abstract int capacity();

    public final void ensureCapacity(int n) {
        if (n > this._maxSize - this.size()) {
            this.rehash(PrimeFinder.nextPrime((int)Math.ceil((float)n + (float)this.size() / this._loadFactor) + 1));
            this.computeMaxSize(this.capacity());
        }
    }

    public final void compact() {
        this.rehash(PrimeFinder.nextPrime((int)Math.ceil((float)this.size() / this._loadFactor) + 1));
        this.computeMaxSize(this.capacity());
    }

    public final void trimToSize() {
        this.compact();
    }

    protected void removeAt(int n) {
        --this._size;
    }

    public void clear() {
        this._size = 0;
        this._free = this.capacity();
    }

    protected int setUp(int n) {
        int n2 = PrimeFinder.nextPrime(n);
        this.computeMaxSize(n2);
        return n2;
    }

    protected abstract void rehash(int var1);

    private final void computeMaxSize(int n) {
        this._maxSize = Math.min(n - 1, (int)Math.floor((float)n * this._loadFactor));
        this._free = n - this._size;
    }

    protected final void postInsertHook(boolean bl) {
        if (bl) {
            --this._free;
        }
        if (++this._size > this._maxSize || this._free == 0) {
            int n = this._size > this._maxSize ? PrimeFinder.nextPrime(this.capacity() << 1) : this.capacity();
            this.rehash(n);
            this.computeMaxSize(this.capacity());
        }
    }
}

