/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatFunction;
import gnu.trove.TFloatProcedure;
import gnu.trove.TIntFloatHashMap$EqProcedure;
import gnu.trove.TIntFloatHashMap$HashProcedure;
import gnu.trove.TIntFloatIterator;
import gnu.trove.TIntFloatProcedure;
import gnu.trove.TIntHash;
import gnu.trove.TIntHashingStrategy;
import gnu.trove.TIntProcedure;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TIntFloatHashMap
extends TIntHash
implements Serializable {
    static final long serialVersionUID = 1L;
    protected transient float[] _values;

    public TIntFloatHashMap() {
    }

    public TIntFloatHashMap(int n) {
        super(n);
    }

    public TIntFloatHashMap(int n, float f2) {
        super(n, f2);
    }

    public TIntFloatHashMap(TIntHashingStrategy tIntHashingStrategy) {
        super(tIntHashingStrategy);
    }

    public TIntFloatHashMap(int n, TIntHashingStrategy tIntHashingStrategy) {
        super(n, tIntHashingStrategy);
    }

    public TIntFloatHashMap(int n, float f2, TIntHashingStrategy tIntHashingStrategy) {
        super(n, f2, tIntHashingStrategy);
    }

    public Object clone() {
        TIntFloatHashMap tIntFloatHashMap = (TIntFloatHashMap)super.clone();
        tIntFloatHashMap._values = (float[])this._values.clone();
        return tIntFloatHashMap;
    }

    public TIntFloatIterator iterator() {
        return new TIntFloatIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new float[n2];
        return n2;
    }

    public float put(int n, float f2) {
        float f3 = 0.0f;
        int n2 = this.insertionIndex(n);
        boolean bl = true;
        if (n2 < 0) {
            n2 = -n2 - 1;
            f3 = this._values[n2];
            bl = false;
        }
        byte by = this._states[n2];
        this._set[n2] = n;
        this._states[n2] = 1;
        this._values[n2] = f2;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return f3;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        int[] nArray = this._set;
        float[] fArray = this._values;
        byte[] byArray = this._states;
        this._set = new int[n];
        this._values = new float[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            int n4 = nArray[n3];
            int n5 = this.insertionIndex(n4);
            this._set[n5] = n4;
            this._values[n5] = fArray[n3];
            this._states[n5] = 1;
        }
    }

    public float get(int n) {
        int n2 = this.index(n);
        return n2 < 0 ? 0.0f : this._values[n2];
    }

    public void clear() {
        super.clear();
        int[] nArray = this._set;
        float[] fArray = this._values;
        byte[] byArray = this._states;
        int n = nArray.length;
        while (n-- > 0) {
            nArray[n] = 0;
            fArray[n] = 0.0f;
            byArray[n] = 0;
        }
    }

    public float remove(int n) {
        float f2 = 0.0f;
        int n2 = this.index(n);
        if (n2 >= 0) {
            f2 = this._values[n2];
            this.removeAt(n2);
        }
        return f2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TIntFloatHashMap)) {
            return false;
        }
        TIntFloatHashMap tIntFloatHashMap = (TIntFloatHashMap)object;
        if (tIntFloatHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new TIntFloatHashMap$EqProcedure(tIntFloatHashMap));
    }

    public int hashCode() {
        TIntFloatHashMap$HashProcedure tIntFloatHashMap$HashProcedure = new TIntFloatHashMap$HashProcedure(this, null);
        this.forEachEntry(tIntFloatHashMap$HashProcedure);
        return tIntFloatHashMap$HashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0.0f;
    }

    public float[] getValues() {
        float[] fArray = new float[this.size()];
        float[] fArray2 = this._values;
        byte[] byArray = this._states;
        int n = fArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n2++] = fArray2[n];
        }
        return fArray;
    }

    public int[] keys() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    public boolean containsValue(float f2) {
        byte[] byArray = this._states;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || f2 != fArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int n) {
        return this.contains(n);
    }

    public boolean forEachKey(TIntProcedure tIntProcedure) {
        return this.forEach(tIntProcedure);
    }

    public boolean forEachValue(TFloatProcedure tFloatProcedure) {
        byte[] byArray = this._states;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatProcedure.execute(fArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TIntFloatProcedure tIntFloatProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        float[] fArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntFloatProcedure.execute(nArray[n], fArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TIntFloatProcedure tIntFloatProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        int[] nArray = this._set;
        float[] fArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntFloatProcedure.execute(nArray[n], fArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TFloatFunction tFloatFunction) {
        byte[] byArray = this._states;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n] = tFloatFunction.execute(fArray[n]);
        }
    }

    public boolean increment(int n) {
        return this.adjustValue(n, 1.0f);
    }

    public boolean adjustValue(int n, float f2) {
        int n2 = this.index(n);
        if (n2 < 0) {
            return false;
        }
        int n3 = n2;
        this._values[n3] = this._values[n3] + f2;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            int n2 = objectInputStream.readInt();
            float f2 = objectInputStream.readFloat();
            this.put(n2, f2);
        }
    }
}

