/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.util.Collection;
import java.util.Iterator;
import javax.media.jai.CollectionImage;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationRegistry;
import javax.media.jai.RenderedOp;

public class CollectionOp
extends CollectionImage {
    private OperationRegistry registry;
    private String opName;
    private ParameterBlock args;
    private RenderingHints hints;

    public CollectionOp(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        this(null, string, parameterBlock, renderingHints);
    }

    public CollectionOp(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock) {
        this(operationRegistry, string, parameterBlock, null);
    }

    public CollectionOp(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.registry = operationRegistry;
        this.opName = string;
        this.args = parameterBlock == null ? new ParameterBlock() : parameterBlock;
        this.hints = renderingHints;
    }

    public final boolean add(Object object) {
        this.createCollection();
        return this.imageCollection.add(object);
    }

    public final boolean addAll(Collection collection) {
        this.createCollection();
        return this.imageCollection.addAll(collection);
    }

    public final void clear() {
        this.createCollection();
        this.imageCollection.clear();
    }

    public final boolean contains(Object object) {
        this.createCollection();
        return this.imageCollection.contains(object);
    }

    public final boolean containsAll(Collection collection) {
        this.createCollection();
        return this.imageCollection.containsAll(collection);
    }

    private synchronized void createCollection() {
        if (this.imageCollection == null) {
            this.imageCollection = this.createInstance(true);
        }
    }

    public final synchronized Collection createInstance() {
        return this.createInstance(false);
    }

    private synchronized Collection createInstance(boolean bl) {
        Object object;
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.setParameters(this.args.getParameters());
        int n = this.args.getNumSources();
        int n2 = 0;
        while (n2 < n) {
            object = this.args.getSource(n2);
            Object object2 = null;
            if (object instanceof RenderedOp) {
                object2 = bl ? ((RenderedOp)object).getRendering() : ((RenderedOp)object).createInstance();
            } else if (object instanceof CollectionOp) {
                CollectionOp collectionOp = (CollectionOp)object;
                object2 = bl || collectionOp.imageCollection != null ? collectionOp.getCollection() : collectionOp.createInstance();
            } else {
                object2 = object instanceof RenderedImage || object instanceof RenderableImage || object instanceof Collection ? object : object;
            }
            parameterBlock.addSource(object2);
            ++n2;
        }
        object = this.getRegistry().createCollection(this.opName, parameterBlock, this.hints);
        if (object == null) {
            throw new RuntimeException(JaiI18N.getString("CollectionOp0"));
        }
        return object;
    }

    public final Collection getCollection() {
        this.createCollection();
        return this.imageCollection;
    }

    public final String getOperationName() {
        return this.opName;
    }

    public final ParameterBlock getParameterBlock() {
        return this.args;
    }

    public final synchronized OperationRegistry getRegistry() {
        if (this.registry == null) {
            this.registry = JAI.getDefaultInstance().getOperationRegistry();
        }
        return this.registry;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final boolean isEmpty() {
        this.createCollection();
        return this.imageCollection.isEmpty();
    }

    public final Iterator iterator() {
        this.createCollection();
        return this.imageCollection.iterator();
    }

    public final boolean remove(Object object) {
        this.createCollection();
        return this.imageCollection.remove(object);
    }

    public final boolean removeAll(Collection collection) {
        this.createCollection();
        return this.imageCollection.removeAll(collection);
    }

    public final boolean retainAll(Collection collection) {
        this.createCollection();
        return this.imageCollection.retainAll(collection);
    }

    public final synchronized void setOperationName(String string) {
        if (this.imageCollection == null) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.opName = string;
        }
    }

    public final synchronized void setParameterBlock(ParameterBlock parameterBlock) {
        if (this.imageCollection == null) {
            this.args = parameterBlock == null ? new ParameterBlock() : parameterBlock;
        }
    }

    public final synchronized void setRegistry(OperationRegistry operationRegistry) {
        if (this.imageCollection == null) {
            this.registry = operationRegistry;
        }
    }

    public final synchronized void setRenderingHints(RenderingHints renderingHints) {
        if (this.imageCollection == null) {
            this.hints = renderingHints;
        }
    }

    public final int size() {
        this.createCollection();
        return this.imageCollection.size();
    }

    public final Object[] toArray() {
        this.createCollection();
        return this.imageCollection.toArray();
    }

    public final Object[] toArray(Object[] objectArray) {
        this.createCollection();
        return this.imageCollection.toArray(objectArray);
    }
}

