/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.DataBuffer;

public class DataBufferFloat
extends DataBuffer {
    protected float[][] bankdata;
    protected float[] data;

    public DataBufferFloat(int n) {
        super(4, n);
        this.data = new float[n];
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(int n, int n2) {
        super(4, n, n2);
        this.bankdata = new float[n2][];
        int n3 = 0;
        while (n3 < n2) {
            this.bankdata[n3] = new float[n];
            ++n3;
        }
        this.data = this.bankdata[0];
    }

    public DataBufferFloat(float[] fArray, int n) {
        super(4, n);
        this.data = fArray;
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(float[] fArray, int n, int n2) {
        super(4, n, 1, n2);
        this.data = fArray;
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(float[][] fArray, int n) {
        super(4, n, fArray.length);
        this.bankdata = fArray;
        this.data = this.bankdata[0];
    }

    public DataBufferFloat(float[][] fArray, int n, int[] nArray) {
        super(4, n, fArray.length, nArray);
        this.bankdata = fArray;
        this.data = this.bankdata[0];
    }

    public final float[][] getBankData() {
        return this.bankdata;
    }

    public final float[] getData() {
        return this.data;
    }

    public final float[] getData(int n) {
        return this.bankdata[n];
    }

    public final int getElem(int n) {
        return (int)this.data[n + this.offset];
    }

    public final int getElem(int n, int n2) {
        return (int)this.bankdata[n][n2 + this.offsets[n]];
    }

    public final double getElemDouble(int n) {
        return this.data[n + this.offset];
    }

    public final double getElemDouble(int n, int n2) {
        return this.bankdata[n][n2 + this.offsets[n]];
    }

    public final float getElemFloat(int n) {
        return this.data[n + this.offset];
    }

    public final float getElemFloat(int n, int n2) {
        return this.bankdata[n][n2 + this.offsets[n]];
    }

    public final void setElem(int n, int n2) {
        this.data[n + this.offset] = n2;
    }

    public final void setElem(int n, int n2, int n3) {
        this.bankdata[n][n2 + this.offsets[n]] = n3;
    }

    public final void setElemDouble(int n, double d2) {
        this.data[n + this.offset] = (float)d2;
    }

    public final void setElemDouble(int n, int n2, double d2) {
        this.bankdata[n][n2 + this.offsets[n]] = (float)d2;
    }

    public final void setElemFloat(int n, float f2) {
        this.data[n + this.offset] = f2;
    }

    public final void setElemFloat(int n, int n2, float f2) {
        this.bankdata[n][n2 + this.offsets[n]] = f2;
    }
}

