/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.Kernel;
import java.io.Serializable;
import javax.media.jai.JaiI18N;

public class KernelJAI
implements Serializable {
    public static final KernelJAI ERROR_FILTER_FLOYD_STEINBERG;
    public static final KernelJAI ERROR_FILTER_JARVIS;
    public static final KernelJAI ERROR_FILTER_STUCKI;
    public static final KernelJAI[] DITHER_MASK_441;
    public static final KernelJAI[] DITHER_MASK_443;
    public static final KernelJAI GRADIENT_MASK_SOBEL_HORIZONTAL;
    public static final KernelJAI GRADIENT_MASK_SOBEL_VERTICAL;
    protected int width;
    protected int height;
    protected int xOrigin;
    protected int yOrigin;
    protected float[] data = null;
    protected float[] dataH = null;
    protected float[] dataV = null;
    protected boolean isSeparable = false;
    protected boolean isHorizontallySymmetric = false;
    protected boolean isVerticallySymmetric = false;
    protected KernelJAI rotatedKernel = null;

    static {
        float[] fArray = new float[6];
        fArray[2] = 0.4375f;
        fArray[3] = 0.1875f;
        fArray[4] = 0.3125f;
        fArray[5] = 0.0625f;
        ERROR_FILTER_FLOYD_STEINBERG = new KernelJAI(3, 2, 1, 0, fArray);
        float[] fArray2 = new float[15];
        fArray2[3] = 0.14583333f;
        fArray2[4] = 0.104166664f;
        fArray2[5] = 0.0625f;
        fArray2[6] = 0.104166664f;
        fArray2[7] = 0.14583333f;
        fArray2[8] = 0.104166664f;
        fArray2[9] = 0.0625f;
        fArray2[10] = 0.020833334f;
        fArray2[11] = 0.0625f;
        fArray2[12] = 0.104166664f;
        fArray2[13] = 0.0625f;
        fArray2[14] = 0.020833334f;
        ERROR_FILTER_JARVIS = new KernelJAI(5, 3, 2, 0, fArray2);
        float[] fArray3 = new float[15];
        fArray3[3] = 0.16666667f;
        fArray3[4] = 0.11904762f;
        fArray3[5] = 0.04761905f;
        fArray3[6] = 0.0952381f;
        fArray3[7] = 0.1904762f;
        fArray3[8] = 0.0952381f;
        fArray3[9] = 0.04761905f;
        fArray3[10] = 0.023809524f;
        fArray3[11] = 0.04761905f;
        fArray3[12] = 0.0952381f;
        fArray3[13] = 0.04761905f;
        fArray3[14] = 0.023809524f;
        ERROR_FILTER_STUCKI = new KernelJAI(5, 3, 2, 0, fArray3);
        KernelJAI[] kernelJAIArray = new KernelJAI[1];
        float[] fArray4 = new float[16];
        fArray4[0] = 0.9375f;
        fArray4[1] = 0.4375f;
        fArray4[2] = 0.8125f;
        fArray4[3] = 0.3125f;
        fArray4[4] = 0.1875f;
        fArray4[5] = 0.6875f;
        fArray4[6] = 0.0625f;
        fArray4[7] = 0.5625f;
        fArray4[8] = 0.75f;
        fArray4[9] = 0.25f;
        fArray4[10] = 0.875f;
        fArray4[11] = 0.375f;
        fArray4[13] = 0.5f;
        fArray4[14] = 0.125f;
        fArray4[15] = 0.625f;
        kernelJAIArray[0] = new KernelJAI(4, 4, 1, 1, fArray4);
        DITHER_MASK_441 = kernelJAIArray;
        KernelJAI[] kernelJAIArray2 = new KernelJAI[3];
        float[] fArray5 = new float[16];
        fArray5[1] = 0.5f;
        fArray5[2] = 0.125f;
        fArray5[3] = 0.625f;
        fArray5[4] = 0.75f;
        fArray5[5] = 0.25f;
        fArray5[6] = 0.875f;
        fArray5[7] = 0.375f;
        fArray5[8] = 0.1875f;
        fArray5[9] = 0.6875f;
        fArray5[10] = 0.0625f;
        fArray5[11] = 0.5625f;
        fArray5[12] = 0.9375f;
        fArray5[13] = 0.4375f;
        fArray5[14] = 0.8125f;
        fArray5[15] = 0.3125f;
        kernelJAIArray2[0] = new KernelJAI(4, 4, 1, 1, fArray5);
        float[] fArray6 = new float[16];
        fArray6[0] = 0.625f;
        fArray6[1] = 0.125f;
        fArray6[2] = 0.5f;
        fArray6[4] = 0.375f;
        fArray6[5] = 0.875f;
        fArray6[6] = 0.25f;
        fArray6[7] = 0.75f;
        fArray6[8] = 0.5625f;
        fArray6[9] = 0.0625f;
        fArray6[10] = 0.6875f;
        fArray6[11] = 0.1875f;
        fArray6[12] = 0.3125f;
        fArray6[13] = 0.8125f;
        fArray6[14] = 0.4375f;
        fArray6[15] = 0.9375f;
        kernelJAIArray2[1] = new KernelJAI(4, 4, 1, 1, fArray6);
        float[] fArray7 = new float[16];
        fArray7[0] = 0.9375f;
        fArray7[1] = 0.4375f;
        fArray7[2] = 0.8125f;
        fArray7[3] = 0.3125f;
        fArray7[4] = 0.1875f;
        fArray7[5] = 0.6875f;
        fArray7[6] = 0.0625f;
        fArray7[7] = 0.5625f;
        fArray7[8] = 0.75f;
        fArray7[9] = 0.25f;
        fArray7[10] = 0.875f;
        fArray7[11] = 0.375f;
        fArray7[13] = 0.5f;
        fArray7[14] = 0.125f;
        fArray7[15] = 0.625f;
        kernelJAIArray2[2] = new KernelJAI(4, 4, 1, 1, fArray7);
        DITHER_MASK_443 = kernelJAIArray2;
        float[] fArray8 = new float[9];
        fArray8[0] = -1.0f;
        fArray8[1] = -2.0f;
        fArray8[2] = -1.0f;
        fArray8[6] = 1.0f;
        fArray8[7] = 2.0f;
        fArray8[8] = 1.0f;
        GRADIENT_MASK_SOBEL_HORIZONTAL = new KernelJAI(3, 3, 1, 1, fArray8);
        float[] fArray9 = new float[9];
        fArray9[0] = -1.0f;
        fArray9[2] = 1.0f;
        fArray9[3] = -2.0f;
        fArray9[5] = 2.0f;
        fArray9[6] = -1.0f;
        fArray9[8] = 1.0f;
        GRADIENT_MASK_SOBEL_VERTICAL = new KernelJAI(3, 3, 1, 1, fArray9);
    }

    public KernelJAI(int n, int n2, int n3, int n4, float[] fArray) {
        this.width = n;
        this.height = n2;
        this.xOrigin = n3;
        this.yOrigin = n4;
        this.data = (float[])fArray.clone();
        if (n <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI0"));
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI1"));
        }
        if (n * n2 != fArray.length) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI2"));
        }
        this.classifyKernel();
    }

    public KernelJAI(int n, int n2, int n3, int n4, float[] fArray, float[] fArray2) {
        if (n <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI0"));
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI1"));
        }
        if (n != fArray.length) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI3"));
        }
        if (n2 != fArray2.length) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI4"));
        }
        this.width = n;
        this.height = n2;
        this.xOrigin = n3;
        this.yOrigin = n4;
        this.dataH = (float[])fArray.clone();
        this.dataV = (float[])fArray2.clone();
        this.data = new float[fArray.length * fArray2.length];
        int n5 = 0;
        int n6 = 0;
        while (n6 < fArray2.length) {
            float f2 = fArray2[n6];
            int n7 = 0;
            while (n7 < fArray.length) {
                this.data[n5 + n7] = f2 * fArray[n7];
                ++n7;
            }
            n5 += fArray.length;
            ++n6;
        }
        this.isSeparable = true;
        this.classifyKernel();
    }

    public KernelJAI(int n, int n2, float[] fArray) {
        this(n, n2, n / 2, n2 / 2, fArray);
    }

    public KernelJAI(Kernel kernel) {
        this(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), kernel.getKernelData(null));
    }

    private synchronized void checkSeparable() {
        block17: {
            float f2;
            float f3;
            float f4;
            float f5;
            block16: {
                int n;
                f5 = 1.0E-5f;
                if (this.isSeparable) {
                    return;
                }
                if (this.width <= 1 || this.height <= 1) {
                    return;
                }
                float f6 = 0.0f;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.data.length) {
                    float f7 = Math.abs(this.data[n4]);
                    if (f7 > f6) {
                        n2 = n4;
                        f6 = f7;
                    }
                    ++n4;
                }
                if (f6 < f5 / (float)this.data.length) {
                    this.isSeparable = false;
                    return;
                }
                float[] fArray = new float[this.width];
                f4 = 1.0f / this.data[n2];
                n3 = n2 % this.width;
                n2 /= this.width;
                int n5 = 0;
                while (n5 < this.width) {
                    fArray[n5] = this.data[n2 * this.width + n5] * f4;
                    ++n5;
                }
                int n6 = 0;
                int n7 = 0;
                while (n6 < this.height) {
                    n = 0;
                    while (n < this.width) {
                        f3 = Math.abs(this.data[n7 + n3] * fArray[n] - this.data[n7 + n]);
                        if (f3 > f5) {
                            this.isSeparable = false;
                            return;
                        }
                        ++n;
                    }
                    ++n6;
                    n7 += this.width;
                }
                this.dataH = fArray;
                this.dataV = new float[this.height];
                n = 0;
                while (n < this.height) {
                    this.dataV[n] = this.data[n3 + n * this.width];
                    ++n;
                }
                this.isSeparable = true;
                f3 = 0.0f;
                f2 = 0.0f;
                int n8 = 0;
                while (n8 < this.width) {
                    f3 += this.dataH[n8];
                    ++n8;
                }
                int n9 = 0;
                while (n9 < this.height) {
                    f2 += this.dataV[n9];
                    ++n9;
                }
                if (!(Math.abs(f3) >= Math.abs(f2)) || !(Math.abs(f3) > f5)) break block16;
                f4 = 1.0f / f3;
                int n10 = 0;
                while (n10 < this.width) {
                    int n11 = n10++;
                    this.dataH[n11] = this.dataH[n11] * f4;
                }
                int n12 = 0;
                while (n12 < this.height) {
                    int n13 = n12++;
                    this.dataV[n13] = this.dataV[n13] * f3;
                }
                break block17;
            }
            if (!(Math.abs(f3) < Math.abs(f2)) || !(Math.abs(f2) > f5)) break block17;
            f4 = 1.0f / f2;
            int n = 0;
            while (n < this.width) {
                int n14 = n++;
                this.dataH[n14] = this.dataH[n14] * f2;
            }
            int n15 = 0;
            while (n15 < this.height) {
                int n16 = n15++;
                this.dataV[n16] = this.dataV[n16] * f4;
            }
        }
    }

    private void classifyKernel() {
        if (!this.isSeparable) {
            this.checkSeparable();
        }
        this.isHorizontallySymmetric = false;
        this.isVerticallySymmetric = false;
    }

    public int getBottomPadding() {
        return this.height - this.yOrigin - 1;
    }

    public float getElement(int n, int n2) {
        if (!this.isSeparable) {
            return this.data[n2 * this.width + n];
        }
        return this.dataH[n] * this.dataV[n2];
    }

    public int getHeight() {
        return this.height;
    }

    public float[] getHorizontalKernelData() {
        if (this.dataH == null) {
            return null;
        }
        return (float[])this.dataH.clone();
    }

    public float[] getKernelData() {
        return (float[])this.data.clone();
    }

    public int getLeftPadding() {
        return this.xOrigin;
    }

    public int getRightPadding() {
        return this.width - this.xOrigin - 1;
    }

    public KernelJAI getRotatedKernel() {
        if (this.rotatedKernel == null) {
            if (this.isSeparable) {
                float[] fArray = new float[this.width];
                float[] fArray2 = new float[this.height];
                int n = 0;
                while (n < this.width) {
                    fArray[n] = this.dataH[this.width - 1 - n];
                    ++n;
                }
                int n2 = 0;
                while (n2 < this.height) {
                    fArray2[n2] = this.dataV[this.height - 1 - n2];
                    ++n2;
                }
                this.rotatedKernel = new KernelJAI(this.width, this.height, this.width - 1 - this.xOrigin, this.height - 1 - this.yOrigin, fArray, fArray2);
            } else {
                int n = this.data.length;
                float[] fArray = new float[this.data.length];
                int n3 = 0;
                while (n3 < n) {
                    fArray[n3] = this.data[n - 1 - n3];
                    ++n3;
                }
                this.rotatedKernel = new KernelJAI(this.width, this.height, this.width - 1 - this.xOrigin, this.height - 1 - this.yOrigin, fArray);
            }
        }
        return this.rotatedKernel;
    }

    public int getTopPadding() {
        return this.yOrigin;
    }

    public float[] getVerticalKernelData() {
        if (this.dataV == null) {
            return null;
        }
        return (float[])this.dataV.clone();
    }

    public int getWidth() {
        return this.width;
    }

    public int getXOrigin() {
        return this.xOrigin;
    }

    public int getYOrigin() {
        return this.yOrigin;
    }

    public boolean isHorizontallySymmetric() {
        return this.isHorizontallySymmetric;
    }

    public boolean isSeparable() {
        return this.isSeparable;
    }

    public boolean isVerticallySymmetric() {
        return this.isVerticallySymmetric;
    }
}

