/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.renderable.ParameterBlock;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationDescriptor;

public class ParameterBlockJAI
extends ParameterBlock {
    private OperationDescriptor odesc;
    private Class[] paramClasses;
    private Hashtable indexTable = new Hashtable();

    public ParameterBlockJAI(String string) {
        this(JAI.getDefaultInstance().getOperationRegistry().getOperationDescriptor(string));
    }

    public ParameterBlockJAI(OperationDescriptor operationDescriptor) {
        this.odesc = operationDescriptor;
        this.paramClasses = operationDescriptor.getParamClasses();
        int n = operationDescriptor.getNumParameters();
        this.parameters = new Vector(n);
        Object[] objectArray = operationDescriptor.getParamDefaults();
        String[] stringArray = operationDescriptor.getParamNames();
        int n2 = 0;
        while (n2 < n) {
            this.parameters.addElement(objectArray[n2]);
            this.indexTable.put(stringArray[n2], new Integer(n2));
            ++n2;
        }
    }

    public final byte getByteParameter(String string) {
        return this.getByteParameter(this.indexOf(string));
    }

    public final char getCharParameter(String string) {
        return this.getCharParameter(this.indexOf(string));
    }

    public final double getDoubleParameter(String string) {
        return this.getDoubleParameter(this.indexOf(string));
    }

    public final float getFloatParameter(String string) {
        return this.getFloatParameter(this.indexOf(string));
    }

    public final int getIntParameter(String string) {
        return this.getIntParameter(this.indexOf(string));
    }

    public final long getLongParameter(String string) {
        return this.getLongParameter(this.indexOf(string));
    }

    public final Object getObjectParameter(String string) {
        return this.getObjectParameter(this.indexOf(string));
    }

    public final OperationDescriptor getOperationDescriptor() {
        return this.odesc;
    }

    public final int indexOf(String string) {
        Integer n = (Integer)this.indexTable.get(string);
        return n;
    }

    public final ParameterBlock set(byte by, String string) {
        return this.set((Object)new Byte(by), string);
    }

    public final ParameterBlock set(char c2, String string) {
        return this.set((Object)new Character(c2), string);
    }

    public final ParameterBlock set(double d2, String string) {
        return this.set((Object)new Double(d2), string);
    }

    public final ParameterBlock set(float f2, String string) {
        return this.set((Object)new Float(f2), string);
    }

    public final ParameterBlock set(int n, String string) {
        return this.set((Object)new Integer(n), string);
    }

    public final ParameterBlock set(long l2, String string) {
        return this.set((Object)new Long(l2), string);
    }

    public final ParameterBlock set(Object object, String string) {
        int n = this.indexOf(string);
        if (object != null && !this.paramClasses[n].isInstance(object)) {
            throw new IllegalArgumentException(JaiI18N.getString("ParameterBlockJAI0"));
        }
        this.parameters.setElementAt(object, n);
        return this;
    }

    public final ParameterBlock set(short s, String string) {
        return this.set((Object)new Short(s), string);
    }
}

