/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.rmi.SerializableRenderedImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

public class ROI
implements Serializable {
    private transient RandomIter iter = null;
    transient PlanarImage theImage = null;
    int threshold = 127;

    protected ROI() {
    }

    public ROI(RenderedImage renderedImage) {
        this.theImage = PlanarImage.wrapRenderedImage(renderedImage);
        if (renderedImage.getSampleModel().getNumBands() != 1) {
            throw new RuntimeException(JaiI18N.getString("ROI0"));
        }
        this.threshold = 128;
    }

    public ROI(RenderedImage renderedImage, int n) {
        this.theImage = PlanarImage.wrapRenderedImage(renderedImage);
        this.threshold = n;
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel.getNumBands() != 1) {
            throw new RuntimeException(JaiI18N.getString("ROI0"));
        }
    }

    public ROI add(ROI rOI) {
        PlanarImage planarImage;
        PlanarImage planarImage2 = this.getAsImage();
        PlanarImage planarImage3 = planarImage = rOI.getAsImage();
        if (rOI.getThreshold() != this.threshold) {
            planarImage3 = JAI.create("threshold", (RenderedImage)planarImage3, (Object)new double[]{-1.7976931348623157E308}, (Object)new double[]{(double)rOI.getThreshold() - 1.0}, (Object)new double[1]);
            planarImage3 = JAI.create("threshold", (RenderedImage)planarImage3, (Object)new double[]{rOI.getThreshold()}, (Object)new double[]{Double.MAX_VALUE}, (Object)new double[]{this.threshold});
        }
        PlanarImage planarImage4 = ROI.mergeImages(planarImage2, planarImage3, JAI.create("max", (RenderedImage)planarImage2, planarImage3));
        return new ROI(planarImage4, this.threshold);
    }

    public boolean contains(double d2, double d3) {
        return this.contains((int)d2, (int)d3);
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        Rectangle rectangle = new Rectangle((int)d2, (int)d3, (int)d4, (int)d5);
        return this.contains(rectangle);
    }

    public boolean contains(int n, int n2) {
        int n3 = this.theImage.getMinX();
        int n4 = this.theImage.getMinY();
        return n >= n3 && n < n3 + this.theImage.getWidth() && n2 >= n4 && n2 < n4 + this.theImage.getHeight() && this.threshold <= this.getIter().getSample(n, n2, 0);
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        return this.contains(rectangle);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(Rectangle rectangle) {
        if (!rectangle.equals(rectangle.intersection(this.getBounds()))) {
            return false;
        }
        DataBuffer dataBuffer = this.theImage.getData(rectangle).getDataBuffer();
        int n = rectangle.width * rectangle.height;
        int n2 = 0;
        while (n2 < n) {
            if (dataBuffer.getElem(n2) < this.threshold) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean contains(Point2D point2D) {
        return this.contains((int)point2D.getX(), (int)point2D.getY());
    }

    public boolean contains(Rectangle2D rectangle2D) {
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return this.contains(rectangle);
    }

    public ROI exclusiveOr(ROI rOI) {
        PlanarImage planarImage = this.getAsImage();
        PlanarImage planarImage2 = rOI.getAsImage();
        RenderedOp renderedOp = JAI.create("threshold", (RenderedImage)planarImage, (Object)new double[]{-1.7976931348623157E308}, (Object)new double[]{(double)this.threshold - 1.0}, (Object)new double[1]);
        renderedOp = JAI.create("threshold", (RenderedImage)renderedOp, (Object)new double[]{this.threshold}, (Object)new double[]{Double.MAX_VALUE}, (Object)new double[]{this.threshold});
        RenderedOp renderedOp2 = JAI.create("threshold", (RenderedImage)planarImage2, (Object)new double[]{-1.7976931348623157E308}, (Object)new double[]{(double)rOI.getThreshold() - 1.0}, (Object)new double[1]);
        renderedOp2 = JAI.create("threshold", (RenderedImage)renderedOp2, (Object)new double[]{rOI.getThreshold()}, (Object)new double[]{Double.MAX_VALUE}, (Object)new double[]{this.threshold});
        PlanarImage planarImage3 = ROI.mergeImages(planarImage, renderedOp2, JAI.create("xor", (RenderedImage)renderedOp, renderedOp2));
        return new ROI(planarImage3, this.threshold);
    }

    public int[][] getAsBitmask(int n, int n2, int n3, int n4, int[][] nArray) {
        int n5;
        Rectangle rectangle = this.getBounds().intersection(new Rectangle(n, n2, n3, n4));
        if (rectangle.isEmpty()) {
            return null;
        }
        int n6 = (n3 + 31) / 32;
        if (nArray == null) {
            nArray = new int[n4][n6];
        } else if (nArray.length < n4 || nArray[0].length < n6) {
            throw new RuntimeException(JaiI18N.getString("ROI3"));
        }
        int n7 = this.theImage.getSampleModel().getDataType();
        if (n7 != 0 && n7 != 2 && n7 != 1 && n7 != 3) {
            throw new RuntimeException(JaiI18N.getString("ROI4"));
        }
        Raster raster = this.theImage.getData(rectangle);
        int[] nArray2 = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
        int n8 = rectangle.width / 32;
        int n9 = (rectangle.width - 32 * n8) / 8;
        int n10 = rectangle.width - 32 * n8 - 8 * n9;
        int n11 = (3 - n9) * 8;
        int n12 = n8 + (n9 > 0 || n10 > 0 ? 1 : 0);
        int n13 = 0;
        int n14 = 0;
        while (n13 < rectangle.height) {
            int n15;
            int n16;
            int[] nArray3 = nArray[n13];
            int n17 = 0;
            while (n17 < n8) {
                n5 = 0;
                n16 = Integer.MIN_VALUE;
                n15 = 0;
                while (n15 < 32) {
                    if (nArray2[n14++] >= this.threshold) {
                        n5 |= n16;
                    }
                    n16 >>>= 1;
                    ++n15;
                }
                nArray3[n17] = n5;
                ++n17;
            }
            if (n8 < n6) {
                n5 = 0;
                n16 = 0;
                while (n16 < n9) {
                    if (nArray2[n14++] >= this.threshold) {
                        n5 |= 0x80;
                    }
                    if (nArray2[n14++] >= this.threshold) {
                        n5 |= 0x40;
                    }
                    if (nArray2[n14++] >= this.threshold) {
                        n5 |= 0x20;
                    }
                    if (nArray2[n14++] >= this.threshold) {
                        n5 |= 0x10;
                    }
                    if (nArray2[n14++] >= this.threshold) {
                        n5 |= 8;
                    }
                    if (nArray2[n14++] >= this.threshold) {
                        n5 |= 4;
                    }
                    if (nArray2[n14++] >= this.threshold) {
                        n5 |= 2;
                    }
                    if (nArray2[n14++] >= this.threshold) {
                        n5 |= 1;
                    }
                    n5 <<= 8;
                    ++n16;
                }
                n15 = 0;
                while (n15 < n10) {
                    if (nArray2[n14++] >= this.threshold) {
                        n5 |= 128 >> n15;
                    }
                    ++n15;
                }
                nArray3[n8] = n5 << n11;
            }
            if (nArray3.length > n12) {
                Arrays.fill(nArray3, n12, nArray3.length, 0);
            }
            ++n13;
        }
        n5 = rectangle.height;
        while (n5 < n4) {
            Arrays.fill(nArray[n5], 0);
            ++n5;
        }
        return nArray;
    }

    public PlanarImage getAsImage() {
        return this.theImage;
    }

    public LinkedList getAsRectangleList(int n, int n2, int n3, int n4) {
        return this.getAsRectangleList(n, n2, n3, n4, true);
    }

    protected LinkedList getAsRectangleList(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        Rectangle rectangle;
        Rectangle rectangle2 = this.getBounds();
        if (!rectangle2.intersects(rectangle = new Rectangle(n, n2, n3, n4))) {
            return null;
        }
        if (!rectangle2.contains(rectangle)) {
            rectangle = rectangle2.intersection(rectangle);
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.width;
            n4 = rectangle.height;
        }
        if ((n5 = this.theImage.getSampleModel().getDataType()) != 0 && n5 != 2 && n5 != 1 && n5 != 3) {
            throw new RuntimeException(JaiI18N.getString("ROI4"));
        }
        Raster raster = this.theImage.getData(new Rectangle(n, n2, n3, n4));
        int[] nArray = raster.getPixels(n, n2, n3, n4, (int[])null);
        LinkedList linkedList = new LinkedList();
        int n6 = 0;
        int n7 = 0;
        while (n6 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                if (nArray[n7 + n8] >= this.threshold) {
                    int n9 = 1;
                    while (n8 + n9 < n3 && nArray[n7 + n8 + n9] >= this.threshold) {
                        ++n9;
                    }
                    Rectangle rectangle3 = new Rectangle(n + n8, n2 + n6, n9, 1);
                    linkedList.addLast(rectangle3);
                    n8 += n9;
                }
                ++n8;
            }
            n7 += n3;
            ++n6;
        }
        return bl ? ROI.mergeRunLengthList(linkedList) : linkedList;
    }

    public Shape getAsShape() {
        return null;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.theImage.getMinX(), this.theImage.getMinY(), this.theImage.getWidth(), this.theImage.getHeight());
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Float(this.theImage.getMinX(), this.theImage.getMinY(), this.theImage.getWidth(), this.theImage.getHeight());
    }

    private RandomIter getIter() {
        if (this.iter == null) {
            this.iter = RandomIterFactory.create(this.theImage, null);
        }
        return this.iter;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public ROI intersect(ROI rOI) {
        PlanarImage planarImage;
        PlanarImage planarImage2 = this.getAsImage();
        PlanarImage planarImage3 = planarImage = rOI.getAsImage();
        if (rOI.getThreshold() != this.threshold) {
            planarImage3 = JAI.create("threshold", (RenderedImage)planarImage3, (Object)new double[]{-1.7976931348623157E308}, (Object)new double[]{(double)rOI.getThreshold() - 1.0}, (Object)new double[1]);
            planarImage3 = JAI.create("threshold", (RenderedImage)planarImage3, (Object)new double[]{rOI.getThreshold()}, (Object)new double[]{Double.MAX_VALUE}, (Object)new double[]{this.threshold});
        }
        return new ROI(JAI.create("min", (RenderedImage)planarImage2, planarImage3), this.threshold);
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        Rectangle rectangle = new Rectangle((int)d2, (int)d3, (int)d4, (int)d5);
        return this.intersects(rectangle);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        return this.intersects(rectangle);
    }

    public boolean intersects(Rectangle rectangle) {
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        if (rectangle2.isEmpty()) {
            return false;
        }
        DataBuffer dataBuffer = this.theImage.getData(rectangle2).getDataBuffer();
        int n = rectangle2.width * rectangle2.height;
        int n2 = 0;
        while (n2 < n) {
            if (dataBuffer.getElem(n2) >= this.threshold) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return this.intersects(rectangle);
    }

    private static PlanarImage mergeImages(PlanarImage planarImage, PlanarImage planarImage2, PlanarImage planarImage3) {
        ROIShape rOIShape;
        Area area;
        Rectangle rectangle = planarImage.getBounds();
        Rectangle rectangle2 = planarImage3.getBounds();
        Rectangle rectangle3 = null;
        if (planarImage2 == null) {
            if (rectangle.equals(rectangle2)) {
                return planarImage3;
            }
        } else {
            rectangle3 = planarImage2.getBounds();
            if (rectangle.equals(rectangle2) && rectangle3.equals(rectangle2)) {
                return planarImage3;
            }
        }
        Rectangle rectangle4 = planarImage2 == null ? rectangle : rectangle.union(rectangle3);
        TiledImage tiledImage = new TiledImage(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, rectangle4.x, rectangle4.y, planarImage.getSampleModel(), planarImage.getColorModel());
        Area area2 = null;
        if (!rectangle.equals(rectangle2)) {
            if (area2 == null) {
                area2 = new Area(rectangle2);
            }
            area = new Area(rectangle);
            area.subtract(area2);
            rOIShape = new ROIShape(area);
            tiledImage.setData(planarImage.getData(rOIShape.getBounds()), rOIShape);
        }
        if (planarImage2 != null && !rectangle3.equals(rectangle2)) {
            if (area2 == null) {
                area2 = new Area(rectangle2);
            }
            area = new Area(rectangle3);
            area.subtract(area2);
            rOIShape = new ROIShape(area);
            tiledImage.setData(planarImage2.getData(rOIShape.getBounds()), rOIShape);
        }
        tiledImage.set(planarImage3);
        return tiledImage;
    }

    protected static LinkedList mergeRunLengthList(LinkedList linkedList) {
        if (linkedList.size() > 1) {
            int n = 0;
            while (n < linkedList.size() - 1) {
                ListIterator listIterator = linkedList.listIterator(n);
                Rectangle rectangle = (Rectangle)listIterator.next();
                while (listIterator.hasNext()) {
                    Rectangle rectangle2 = (Rectangle)listIterator.next();
                    int n2 = rectangle.y + rectangle.height;
                    if (rectangle2.y == n2 && rectangle2.x == rectangle.x && rectangle2.width == rectangle.width) {
                        rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height + rectangle2.height);
                        listIterator.remove();
                        linkedList.set(n, rectangle);
                        continue;
                    }
                    if (rectangle2.y > n2) break;
                }
                ++n;
            }
        }
        return linkedList;
    }

    public ROI performImageOp(RenderedImageFactory renderedImageFactory, ParameterBlock parameterBlock, int n, RenderingHints renderingHints) {
        ParameterBlock parameterBlock2 = (ParameterBlock)parameterBlock.clone();
        Vector<Object> vector = parameterBlock2.getSources();
        vector.insertElementAt(this.getAsImage(), n);
        RenderedImage renderedImage = renderedImageFactory.create(parameterBlock2, renderingHints);
        return new ROI(renderedImage, this.threshold);
    }

    public ROI performImageOp(String string, ParameterBlock parameterBlock, int n, RenderingHints renderingHints) {
        ParameterBlock parameterBlock2 = (ParameterBlock)parameterBlock.clone();
        Vector<Object> vector = parameterBlock2.getSources();
        vector.insertElementAt(this.getAsImage(), n);
        RenderedOp renderedOp = JAI.create(string, parameterBlock2, renderingHints);
        return new ROI(renderedOp, this.threshold);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        if (objectInputStream.readBoolean()) {
            SerializableRenderedImage serializableRenderedImage = (SerializableRenderedImage)objectInputStream.readObject();
            this.theImage = PlanarImage.wrapRenderedImage(serializableRenderedImage);
        } else {
            this.theImage = null;
        }
        this.iter = null;
    }

    public void setThreshold(int n) {
        this.threshold = n;
    }

    public ROI subtract(ROI rOI) {
        PlanarImage planarImage = this.getAsImage();
        PlanarImage planarImage2 = rOI.getAsImage();
        RenderedOp renderedOp = JAI.create("threshold", (RenderedImage)planarImage, (Object)new double[]{-1.7976931348623157E308}, (Object)new double[]{(double)this.threshold - 1.0}, (Object)new double[1]);
        renderedOp = JAI.create("threshold", (RenderedImage)renderedOp, (Object)new double[]{this.threshold}, (Object)new double[]{Double.MAX_VALUE}, (Object)new double[]{this.threshold});
        RenderedOp renderedOp2 = JAI.create("threshold", (RenderedImage)planarImage2, (Object)new double[]{-1.7976931348623157E308}, (Object)new double[]{(double)rOI.getThreshold() - 1.0}, (Object)new double[1]);
        renderedOp2 = JAI.create("threshold", (RenderedImage)renderedOp2, (Object)new double[]{rOI.getThreshold()}, (Object)new double[]{Double.MAX_VALUE}, (Object)new double[]{this.threshold});
        RenderedOp renderedOp3 = JAI.create("and", (RenderedImage)renderedOp, renderedOp2);
        PlanarImage planarImage3 = ROI.mergeImages(planarImage, null, JAI.create("subtract", (RenderedImage)renderedOp, renderedOp3));
        return new ROI(planarImage3, this.threshold);
    }

    public ROI transform(AffineTransform affineTransform) {
        return this.transform(affineTransform, Interpolation.getInstance(0));
    }

    public ROI transform(AffineTransform affineTransform, Interpolation interpolation) {
        if (affineTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROI5"));
        }
        if (interpolation == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROI6"));
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(affineTransform);
        parameterBlock.add(interpolation);
        return this.performImageOp("Affine", parameterBlock, 0, null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        if (this.theImage != null) {
            objectOutputStream.writeBoolean(true);
            SerializableRenderedImage serializableRenderedImage = new SerializableRenderedImage(this.theImage, true);
            objectOutputStream.writeObject(serializableRenderedImage);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }
}

