/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape$PolyShape;
import javax.media.jai.TiledImage;

public class ROIShape
extends ROI {
    transient Shape theShape = null;

    public ROIShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROIShape2"));
        }
        this.theShape = shape;
    }

    public ROIShape(Area area) {
        AffineTransform affineTransform = new AffineTransform();
        PathIterator pathIterator = area.getPathIterator(affineTransform);
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        generalPath.append(pathIterator, false);
        this.theShape = generalPath;
    }

    public final ROI add(ROI rOI) {
        if (rOI == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROIShape3"));
        }
        if (!(rOI instanceof ROIShape)) {
            return super.add(rOI);
        }
        ROIShape rOIShape = (ROIShape)rOI;
        Area area = new Area(this.theShape);
        Area area2 = new Area(rOIShape.theShape);
        area.add(area2);
        return new ROIShape(area);
    }

    public final boolean contains(double d2, double d3) {
        return this.contains((int)d2, (int)d3);
    }

    public final boolean contains(double d2, double d3, double d4, double d5) {
        return this.theShape.contains(d2, d3, d4, d5);
    }

    public final boolean contains(int n, int n2) {
        return this.theShape.contains(n, n2);
    }

    public final boolean contains(int n, int n2, int n3, int n4) {
        return this.contains(new Rectangle2D.Float(n, n2, n3, n4));
    }

    public final boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public final boolean contains(Rectangle rectangle) {
        return this.contains(new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
    }

    public final boolean contains(Point2D point2D) {
        return this.contains((int)point2D.getX(), (int)point2D.getY());
    }

    public final boolean contains(Rectangle2D rectangle2D) {
        return this.theShape.contains(rectangle2D);
    }

    public final ROI exclusiveOr(ROI rOI) {
        if (rOI == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROIShape3"));
        }
        if (!(rOI instanceof ROIShape)) {
            return super.exclusiveOr(rOI);
        }
        ROIShape rOIShape = (ROIShape)rOI;
        Area area = new Area(this.theShape);
        Area area2 = new Area(rOIShape.theShape);
        area.exclusiveOr(area2);
        return new ROIShape(area);
    }

    public final int[][] getAsBitmask(int n, int n2, int n3, int n4, int[][] nArray) {
        LinkedList linkedList = this.getAsRectangleList(n, n2, n3, n4, false);
        if (linkedList == null) {
            return null;
        }
        return ROIShape.rectangleListToBitmask(linkedList, new Rectangle(n, n2, n3, n4), nArray);
    }

    public final PlanarImage getAsImage() {
        if (this.theImage == null) {
            Rectangle rectangle = this.theShape.getBounds();
            TiledImage tiledImage = TiledImage.createInterleaved(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 1, 0, rectangle.width, rectangle.height, new int[1]);
            Graphics2D graphics2D = tiledImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fill(this.theShape);
            this.theImage = tiledImage;
        }
        return this.theImage;
    }

    public final LinkedList getAsRectangleList(int n, int n2, int n3, int n4) {
        return this.getAsRectangleList(n, n2, n3, n4, true);
    }

    protected final LinkedList getAsRectangleList(int n, int n2, int n3, int n4, boolean bl) {
        LinkedList<Rectangle> linkedList = null;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (!new Area(this.theShape).intersects(rectangle)) {
            return null;
        }
        if (this.theShape instanceof Rectangle2D) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Rectangle2D.intersect((Rectangle2D)this.theShape, rectangle, double_);
            int n5 = (int)Math.round(double_.getMinX());
            int n6 = (int)Math.round(double_.getMinY());
            int n7 = (int)Math.round(double_.getMaxX() - (double)n5);
            int n8 = (int)Math.round(double_.getMaxY() - (double)n6);
            linkedList = new LinkedList<Rectangle>();
            linkedList.addLast(new Rectangle(n5, n6, n7, n8));
        } else if (this.theShape instanceof Polygon) {
            linkedList = this.polygonToRunLengthList(rectangle, (Polygon)this.theShape);
            if (bl && linkedList != null) {
                linkedList = ROI.mergeRunLengthList(linkedList);
            }
        } else {
            this.getAsImage();
            linkedList = super.getAsRectangleList(n, n2, n3, n4, bl);
        }
        return linkedList;
    }

    public final Shape getAsShape() {
        return this.theShape;
    }

    public final Rectangle getBounds() {
        return this.theShape.getBounds();
    }

    public final Rectangle2D getBounds2D() {
        return this.theShape.getBounds2D();
    }

    private static Point2D.Double getIntersection(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double[][] dArray = new double[2][2];
        dArray[0][0] = d5 - d3;
        dArray[0][1] = d2 - d4;
        dArray[1][0] = d9 - d7;
        dArray[1][1] = d6 - d8;
        double[] dArray2 = new double[]{d3 * (d2 - d4) + d2 * (d5 - d3), d7 * (d6 - d8) + d6 * (d9 - d7)};
        double d10 = dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0];
        double d11 = dArray[0][0];
        dArray[0][0] = dArray[1][1] / d10;
        dArray[0][1] = -dArray[0][1] / d10;
        dArray[1][0] = -dArray[1][0] / d10;
        dArray[1][1] = d11 / d10;
        double d12 = dArray[0][0] * dArray2[0] + dArray[0][1] * dArray2[1];
        double d13 = dArray[1][0] * dArray2[0] + dArray[1][1] * dArray2[1];
        return new Point2D.Double(d12, d13);
    }

    public final ROI intersect(ROI rOI) {
        if (rOI == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROIShape3"));
        }
        if (!(rOI instanceof ROIShape)) {
            return super.intersect(rOI);
        }
        ROIShape rOIShape = (ROIShape)rOI;
        Area area = new Area(this.theShape);
        Area area2 = new Area(rOIShape.theShape);
        area.intersect(area2);
        return new ROIShape(area);
    }

    public final boolean intersects(double d2, double d3, double d4, double d5) {
        return this.theShape.intersects(d2, d3, d4, d5);
    }

    public final boolean intersects(int n, int n2, int n3, int n4) {
        return this.intersects(new Rectangle2D.Float(n, n2, n3, n4));
    }

    public final boolean intersects(Rectangle rectangle) {
        return this.intersects(new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
    }

    public final boolean intersects(Rectangle2D rectangle2D) {
        return this.theShape.intersects(rectangle2D);
    }

    private LinkedList polygonToRunLengthList(Rectangle rectangle, Polygon polygon) {
        ROIShape$PolyShape rOIShape$PolyShape = new ROIShape$PolyShape(this, polygon, rectangle);
        return rOIShape$PolyShape.getAsRectList();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        LinkedList linkedList = null;
        objectInputStream.defaultReadObject();
        linkedList = (LinkedList)objectInputStream.readObject();
        Area area = new Area();
        int n = linkedList.size();
        int n2 = 0;
        while (n2 < n) {
            area.add(new Area((Rectangle)linkedList.get(n2)));
            ++n2;
        }
        this.theShape = area;
    }

    private static int[][] rectangleListToBitmask(LinkedList linkedList, Rectangle rectangle, int[][] nArray) {
        int n = Integer.MIN_VALUE;
        int n2 = (rectangle.width + 31) / 32;
        if (nArray == null) {
            nArray = new int[rectangle.height][n2];
        } else if (nArray.length < rectangle.height || nArray[0].length < n2) {
            throw new RuntimeException(JaiI18N.getString("ROIShape0"));
        }
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = (Rectangle)listIterator.next();
            if (!rectangle.intersects(rectangle2)) continue;
            rectangle2 = rectangle.intersection(rectangle2);
            int n3 = rectangle2.y - rectangle.y;
            int n4 = rectangle2.x - rectangle.x;
            int n5 = n3 + rectangle2.height - 1;
            int n6 = n4 + rectangle2.width - 1;
            int n7 = n3;
            while (n7 <= n5) {
                int[] nArray2 = nArray[n7];
                int n8 = n4;
                while (n8 <= n6) {
                    int n9 = n8 / 32;
                    int n10 = n8 % 32;
                    int n11 = n9;
                    nArray2[n11] = nArray2[n11] | n >>> n10;
                    ++n8;
                }
                ++n7;
            }
        }
        return nArray;
    }

    public final ROI subtract(ROI rOI) {
        if (rOI == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROIShape3"));
        }
        if (!(rOI instanceof ROIShape)) {
            return super.subtract(rOI);
        }
        ROIShape rOIShape = (ROIShape)rOI;
        Area area = new Area(this.theShape);
        Area area2 = new Area(rOIShape.theShape);
        area.subtract(area2);
        return new ROIShape(area);
    }

    public final ROI transform(AffineTransform affineTransform) {
        return new ROIShape(affineTransform.createTransformedShape(this.theShape));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        LinkedList linkedList = null;
        if (this.theShape == null) {
            linkedList = new LinkedList();
        } else {
            Rectangle rectangle = this.getBounds();
            linkedList = this.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(linkedList);
    }
}

