/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PolyWarpSolver;
import java.awt.Rectangle;
import javax.media.jai.JaiI18N;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpCubic;
import javax.media.jai.WarpGeneralPolynomial;
import javax.media.jai.WarpQuadratic;

public abstract class WarpPolynomial
extends Warp {
    protected float[] xCoeffs;
    protected float[] yCoeffs;
    protected float preScaleX;
    protected float preScaleY;
    protected float postScaleX;
    protected float postScaleY;
    protected int degree;

    public WarpPolynomial(float[] fArray, float[] fArray2) {
        this(fArray, fArray2, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public WarpPolynomial(float[] fArray, float[] fArray2, float f2, float f3, float f4, float f5) {
        if (fArray == null || fArray2 == null || fArray.length < 1 || fArray2.length < 1 || fArray.length != fArray2.length) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpPolynomial0"));
        }
        int n = fArray.length;
        this.degree = -1;
        while (n > 0) {
            ++this.degree;
            n -= this.degree + 1;
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpPolynomial0"));
        }
        this.xCoeffs = (float[])fArray.clone();
        this.yCoeffs = (float[])fArray2.clone();
        this.preScaleX = f2;
        this.preScaleY = f3;
        this.postScaleX = f4;
        this.postScaleY = f5;
    }

    public static final WarpPolynomial createWarp(float[] fArray, int n, float[] fArray2, int n2, int n3, float f2, float f3, float f4, float f5, int n4) {
        int n5 = (n4 + 1) * (n4 + 2);
        if (n + n5 > fArray.length || n2 + n5 > fArray2.length) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpPolynomial1"));
        }
        float[] fArray3 = PolyWarpSolver.getCoeffs(fArray, n, fArray2, n2, n3, f2, f3, f4, f5, n4);
        int n6 = fArray3.length / 2;
        float[] fArray4 = new float[n6];
        float[] fArray5 = new float[n6];
        int n7 = 0;
        while (n7 < n6) {
            fArray4[n7] = fArray3[n7];
            fArray5[n7] = fArray3[n7 + n6];
            ++n7;
        }
        if (n4 == 1) {
            return new WarpAffine(fArray4, fArray5, f2, f3, f4, f5);
        }
        if (n4 == 2) {
            return new WarpQuadratic(fArray4, fArray5, f2, f3, f4, f5);
        }
        if (n4 == 3) {
            return new WarpCubic(fArray4, fArray5, f2, f3, f4, f5);
        }
        return new WarpGeneralPolynomial(fArray4, fArray5, f2, f3, f4, f5);
    }

    public final float[][] getCoeffs() {
        float[][] fArray = new float[][]{(float[])this.xCoeffs.clone(), (float[])this.yCoeffs.clone()};
        return fArray;
    }

    public final int getDegree() {
        return this.degree;
    }

    public final float getPostScaleX() {
        return this.postScaleX;
    }

    public final float getPostScaleY() {
        return this.postScaleY;
    }

    public final float getPreScaleX() {
        return this.preScaleX;
    }

    public final float getPreScaleY() {
        return this.preScaleY;
    }

    public final float[] getXCoeffs() {
        return (float[])this.xCoeffs.clone();
    }

    public final float[] getYCoeffs() {
        return (float[])this.yCoeffs.clone();
    }

    public Rectangle mapDestRect(Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = n3 * 2;
        float[] fArray = new float[n5];
        this.warpSparseRect(n, n2, n3, 1, 1, 1, fArray);
        float f2 = fArray[0];
        float f3 = fArray[0];
        float f4 = fArray[1];
        float f5 = fArray[1];
        int n6 = 2;
        while (n6 < n5) {
            f2 = Math.min(f2, fArray[n6]);
            f3 = Math.max(f3, fArray[n6]);
            f4 = Math.min(f4, fArray[n6 + 1]);
            f5 = Math.max(f5, fArray[n6 + 1]);
            n6 += 2;
        }
        this.warpSparseRect(n, n2 + n4 - 1, n3, 1, 1, 1, fArray);
        int n7 = 0;
        while (n7 < n5) {
            f2 = Math.min(f2, fArray[n7]);
            f3 = Math.max(f3, fArray[n7]);
            f4 = Math.min(f4, fArray[n7 + 1]);
            f5 = Math.max(f5, fArray[n7 + 1]);
            n7 += 2;
        }
        n5 = (n4 - 2) * 2;
        fArray = new float[n5];
        this.warpSparseRect(n, n2 + 1, 1, n4 - 2, 1, 1, fArray);
        int n8 = 0;
        while (n8 < n5) {
            f2 = Math.min(f2, fArray[n8]);
            f3 = Math.max(f3, fArray[n8]);
            f4 = Math.min(f4, fArray[n8 + 1]);
            f5 = Math.max(f5, fArray[n8 + 1]);
            n8 += 2;
        }
        this.warpSparseRect(n + n3 - 1, n2 + 1, 1, n4 - 2, 1, 1, fArray);
        int n9 = 0;
        while (n9 < n5) {
            f2 = Math.min(f2, fArray[n9]);
            f3 = Math.max(f3, fArray[n9]);
            f4 = Math.min(f4, fArray[n9 + 1]);
            f5 = Math.max(f5, fArray[n9 + 1]);
            n9 += 2;
        }
        n = (int)Math.floor(f2);
        n2 = (int)Math.floor(f4);
        n3 = (int)Math.ceil(f3 - (float)n) + 1;
        n4 = (int)Math.ceil(f5 - (float)n2) + 1;
        return new Rectangle(n, n2, n3, n4);
    }
}

