/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.operator.JaiI18N;

public class FileStoreDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "filestore"}, {"LocalName", "filestore"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("FileStoreDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/FileStoreDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("FileStoreDescriptor1")}, {"arg1Desc", JaiI18N.getString("FileStoreDescriptor2")}, {"arg2Desc", JaiI18N.getString("FileStoreDescriptor3")}};
    private static final String[] paramNames = new String[]{"filename", "format", "param"};
    private static final Class[] paramClasses = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = FileStoreDescriptor.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = FileStoreDescriptor.class$("java.lang.String")), class$com$sun$media$jai$codec$ImageEncodeParam != null ? class$com$sun$media$jai$codec$ImageEncodeParam : (class$com$sun$media$jai$codec$ImageEncodeParam = FileStoreDescriptor.class$("com.sun.media.jai.codec.ImageEncodeParam"))};
    private static final Object[] paramDefaults = new Object[]{OperationDescriptor.NO_PARAMETER_DEFAULT, "tiff", null};
    static Class class$java$lang$String;
    static Class class$com$sun$media$jai$codec$ImageEncodeParam;

    public FileStoreDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final boolean isImmediate() {
        return true;
    }

    public final boolean validateArguments(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateArguments(parameterBlock, stringBuffer)) {
            return false;
        }
        String string = (String)parameterBlock.getObjectParameter(1);
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("FileStoreDescriptor4"));
            return false;
        }
        ImageEncodeParam imageEncodeParam = (ImageEncodeParam)parameterBlock.getObjectParameter(2);
        if (!imageCodec.canEncodeImage(parameterBlock.getRenderedSource(0), imageEncodeParam)) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("FileStoreDescriptor5"));
            return false;
        }
        String string2 = (String)parameterBlock.getObjectParameter(0);
        if (string2 == null) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("FileStoreDescriptor6"));
            return false;
        }
        try {
            File file = new File(string2);
            if (file.exists()) {
                if (!file.canWrite()) {
                    stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("FileStoreDescriptor7"));
                    return false;
                }
            } else {
                if (!file.createNewFile()) {
                    stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("FileStoreDescriptor8"));
                    return false;
                }
                file.delete();
            }
        }
        catch (IOException iOException) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("FileStoreDescriptor9") + " " + iOException.getMessage());
            return false;
        }
        catch (SecurityException securityException) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("FileStoreDescriptor10") + " " + securityException.getMessage());
            return false;
        }
        return true;
    }
}

