/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.operator.DFTDescriptor;
import javax.media.jai.operator.IDFTPropertyGenerator;
import javax.media.jai.operator.JaiI18N;

public class IDFTDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "IDFT"}, {"LocalName", "IDFT"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("IDFTDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/IDFTDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("IDFTDescriptor1")}, {"arg1Desc", JaiI18N.getString("IDFTDescriptor2")}};
    private static final Class[] paramClasses = new Class[]{class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = IDFTDescriptor.class$("java.lang.Integer")), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = IDFTDescriptor.class$("java.lang.Integer"))};
    private static final String[] paramNames = new String[]{"scalingType", "dataNature"};
    private static final Object[] paramDefaults = new Object[]{DFTDescriptor.SCALING_DIMENSIONS, DFTDescriptor.COMPLEX_TO_REAL};
    static Class class$java$lang$Integer;

    public IDFTDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] propertyGeneratorArray = new PropertyGenerator[]{new IDFTPropertyGenerator()};
        return propertyGeneratorArray;
    }

    public final boolean isRenderableSupported() {
        return true;
    }

    public final boolean validateArguments(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        RenderedImage renderedImage;
        if (!super.validateArguments(parameterBlock, stringBuffer)) {
            return false;
        }
        Integer n = (Integer)parameterBlock.getObjectParameter(0);
        if (!(n.equals(DFTDescriptor.SCALING_NONE) || n.equals(DFTDescriptor.SCALING_UNITARY) || n.equals(DFTDescriptor.SCALING_DIMENSIONS))) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("IDFTDescriptor3"));
            return false;
        }
        Integer n2 = (Integer)parameterBlock.getObjectParameter(1);
        if (!(n2.equals(DFTDescriptor.REAL_TO_COMPLEX) || n2.equals(DFTDescriptor.COMPLEX_TO_COMPLEX) || n2.equals(DFTDescriptor.COMPLEX_TO_REAL))) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("IDFTDescriptor4"));
            return false;
        }
        if (!n2.equals(DFTDescriptor.REAL_TO_COMPLEX) && (renderedImage = parameterBlock.getRenderedSource(0)).getSampleModel().getNumBands() % 2 != 0) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("IDFTDescriptor5"));
            return false;
        }
        return true;
    }
}

