/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestResult;

public abstract class TestCase
extends Assert
implements Test {
    private String fName;

    public TestCase() {
        this.fName = null;
    }

    public TestCase(String string) {
        this.fName = string;
    }

    public int countTestCases() {
        return 1;
    }

    protected final TestResult createResult() {
        return new TestResult();
    }

    public final TestResult run() {
        TestResult testResult = this.createResult();
        this.run(testResult);
        return testResult;
    }

    public void run(TestResult testResult) {
        testResult.run(this);
    }

    public final void runBare() {
        this.setUp();
        try {
            this.runTest();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.tearDown();
            throw throwable;
        }
        Object var1_3 = null;
        this.tearDown();
    }

    protected final void runTest() {
        Assert.assertNotNull(this.fName);
        Method method = null;
        try {
            method = this.getClass().getMethod(this.fName, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Assert.fail("Method \"" + this.fName + "\" not found");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            Assert.fail("Method \"" + this.fName + "\" should be public");
        }
        try {
            method.invoke((Object)this, (Object[])new Class[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.fillInStackTrace();
            throw invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.fillInStackTrace();
            throw illegalAccessException;
        }
    }

    protected void setUp() {
    }

    protected final void tearDown() {
    }

    public final String toString() {
        return String.valueOf(this.getName()) + "(" + this.getClass().getName() + ")";
    }

    public String getName() {
        return this.fName;
    }

    public final void setName(String string) {
        this.fName = string;
    }
}

