/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import common.Assert;
import jxl.HeaderFooter;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;

public final class SheetSettings {
    private PageOrientation orientation;
    private PaperSize paperSize;
    private boolean sheetProtected;
    private boolean hidden;
    private boolean selected;
    private HeaderFooter header;
    private double headerMargin;
    private HeaderFooter footer;
    private double footerMargin;
    private int scaleFactor;
    private int zoomFactor;
    private int pageStart;
    private int fitWidth;
    private int fitHeight;
    private int horizontalPrintResolution;
    private int verticalPrintResolution;
    private double leftMargin;
    private double rightMargin;
    private double topMargin;
    private double bottomMargin;
    private boolean fitToPages;
    private boolean showGridLines;
    private boolean printGridLines;
    private boolean printHeaders;
    private boolean displayZeroValues;
    private String password;
    private int passwordHash;
    private int defaultColumnWidth;
    private int defaultRowHeight;
    private int horizontalFreeze;
    private int verticalFreeze;
    private boolean verticalCentre;
    private boolean horizontalCentre;
    private int copies;
    private static final PageOrientation defaultOrientation = PageOrientation.PORTRAIT;
    private static final PaperSize defaultPaperSize = PaperSize.A4;
    private static final double defaultHeaderMargin = 0.5;
    private static final double defaultFooterMargin = 0.5;
    private static final int defaultPrintResolution = 300;
    private static final double defaultWidthMargin = 0.75;
    private static final double defaultHeightMargin = 1.0;
    private static final int defaultDefaultColumnWidth = 8;
    private static final int defaultZoomFactor = 100;
    public static final int DEFAULT_DEFAULT_ROW_HEIGHT = 255;

    public SheetSettings() {
        this.orientation = defaultOrientation;
        this.paperSize = defaultPaperSize;
        this.sheetProtected = false;
        this.hidden = false;
        this.selected = false;
        this.headerMargin = 0.5;
        this.footerMargin = 0.5;
        this.horizontalPrintResolution = 300;
        this.verticalPrintResolution = 300;
        this.leftMargin = 0.75;
        this.rightMargin = 0.75;
        this.topMargin = 1.0;
        this.bottomMargin = 1.0;
        this.fitToPages = false;
        this.showGridLines = true;
        this.printGridLines = false;
        this.printHeaders = false;
        this.displayZeroValues = true;
        this.defaultColumnWidth = 8;
        this.defaultRowHeight = 255;
        this.zoomFactor = 100;
        this.horizontalFreeze = 0;
        this.verticalFreeze = 0;
        this.copies = 1;
        this.header = new HeaderFooter();
        this.footer = new HeaderFooter();
    }

    public SheetSettings(SheetSettings sheetSettings) {
        Assert.verify(sheetSettings != null);
        this.orientation = sheetSettings.orientation;
        this.paperSize = sheetSettings.paperSize;
        this.sheetProtected = sheetSettings.sheetProtected;
        this.hidden = sheetSettings.hidden;
        this.selected = false;
        this.headerMargin = sheetSettings.headerMargin;
        this.footerMargin = sheetSettings.footerMargin;
        this.scaleFactor = sheetSettings.scaleFactor;
        this.pageStart = sheetSettings.pageStart;
        this.fitWidth = sheetSettings.fitWidth;
        this.fitHeight = sheetSettings.fitHeight;
        this.horizontalPrintResolution = sheetSettings.horizontalPrintResolution;
        this.verticalPrintResolution = sheetSettings.verticalPrintResolution;
        this.leftMargin = sheetSettings.leftMargin;
        this.rightMargin = sheetSettings.rightMargin;
        this.topMargin = sheetSettings.topMargin;
        this.bottomMargin = sheetSettings.bottomMargin;
        this.fitToPages = sheetSettings.fitToPages;
        this.password = sheetSettings.password;
        this.passwordHash = sheetSettings.passwordHash;
        this.defaultColumnWidth = sheetSettings.defaultColumnWidth;
        this.defaultRowHeight = sheetSettings.defaultRowHeight;
        this.zoomFactor = sheetSettings.zoomFactor;
        this.showGridLines = sheetSettings.showGridLines;
        this.displayZeroValues = sheetSettings.displayZeroValues;
        this.horizontalFreeze = sheetSettings.horizontalFreeze;
        this.verticalFreeze = sheetSettings.verticalFreeze;
        this.horizontalCentre = sheetSettings.horizontalCentre;
        this.verticalCentre = sheetSettings.verticalCentre;
        this.copies = sheetSettings.copies;
        this.header = new HeaderFooter(sheetSettings.header);
        this.footer = new HeaderFooter(sheetSettings.footer);
    }

    public final void setOrientation(PageOrientation pageOrientation) {
        this.orientation = pageOrientation;
    }

    public final PageOrientation getOrientation() {
        return this.orientation;
    }

    public final void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public final PaperSize getPaperSize() {
        return this.paperSize;
    }

    public final boolean isProtected() {
        return this.sheetProtected;
    }

    public final void setProtected(boolean bl) {
        this.sheetProtected = bl;
    }

    public final void setHeaderMargin(double d2) {
        this.headerMargin = d2;
    }

    public final double getHeaderMargin() {
        return this.headerMargin;
    }

    public final void setFooterMargin(double d2) {
        this.footerMargin = d2;
    }

    public final double getFooterMargin() {
        return this.footerMargin;
    }

    public final void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    public final void setSelected() {
        this.setSelected(true);
    }

    public final void setSelected(boolean bl) {
        this.selected = bl;
    }

    public final boolean isSelected() {
        return this.selected;
    }

    public final void setScaleFactor(int n) {
        this.scaleFactor = n;
        this.fitToPages = false;
    }

    public final int getScaleFactor() {
        return this.scaleFactor;
    }

    public final void setPageStart(int n) {
        this.pageStart = n;
    }

    public final int getPageStart() {
        return this.pageStart;
    }

    public final void setFitWidth(int n) {
        this.fitWidth = n;
        this.fitToPages = true;
    }

    public final int getFitWidth() {
        return this.fitWidth;
    }

    public final void setFitHeight(int n) {
        this.fitHeight = n;
        this.fitToPages = true;
    }

    public final int getFitHeight() {
        return this.fitHeight;
    }

    public final void setHorizontalPrintResolution(int n) {
        this.horizontalPrintResolution = n;
    }

    public final int getHorizontalPrintResolution() {
        return this.horizontalPrintResolution;
    }

    public final void setVerticalPrintResolution(int n) {
        this.verticalPrintResolution = n;
    }

    public final int getVerticalPrintResolution() {
        return this.verticalPrintResolution;
    }

    public final void setRightMargin(double d2) {
        this.rightMargin = d2;
    }

    public final double getRightMargin() {
        return this.rightMargin;
    }

    public final void setLeftMargin(double d2) {
        this.leftMargin = d2;
    }

    public final double getLeftMargin() {
        return this.leftMargin;
    }

    public final void setTopMargin(double d2) {
        this.topMargin = d2;
    }

    public final double getTopMargin() {
        return this.topMargin;
    }

    public final void setBottomMargin(double d2) {
        this.bottomMargin = d2;
    }

    public final double getBottomMargin() {
        return this.bottomMargin;
    }

    public final double getDefaultWidthMargin() {
        return 0.75;
    }

    public final double getDefaultHeightMargin() {
        return 1.0;
    }

    public final boolean getFitToPages() {
        return this.fitToPages;
    }

    public final void setFitToPages(boolean bl) {
        this.fitToPages = bl;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String string) {
        this.password = string;
    }

    public final int getPasswordHash() {
        return this.passwordHash;
    }

    public final void setPasswordHash(int n) {
        this.passwordHash = n;
    }

    public final int getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public final void setDefaultColumnWidth(int n) {
        this.defaultColumnWidth = n;
    }

    public final int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public final void setDefaultRowHeight(int n) {
        this.defaultRowHeight = n;
    }

    public final int getZoomFactor() {
        return this.zoomFactor;
    }

    public final void setZoomFactor(int n) {
        this.zoomFactor = n;
    }

    public final boolean getDisplayZeroValues() {
        return this.displayZeroValues;
    }

    public final void setDisplayZeroValues(boolean bl) {
        this.displayZeroValues = bl;
    }

    public final boolean getShowGridLines() {
        return this.showGridLines;
    }

    public final void setShowGridLines(boolean bl) {
        this.showGridLines = bl;
    }

    public final boolean getPrintGridLines() {
        return this.printGridLines;
    }

    public final void setPrintGridLines(boolean bl) {
        this.printGridLines = bl;
    }

    public final boolean getPrintHeaders() {
        return this.printHeaders;
    }

    public final void setPrintHeaders(boolean bl) {
        this.printHeaders = bl;
    }

    public final int getHorizontalFreeze() {
        return this.horizontalFreeze;
    }

    public final void setHorizontalFreeze(int n) {
        this.horizontalFreeze = Math.max(n, 0);
    }

    public final int getVerticalFreeze() {
        return this.verticalFreeze;
    }

    public final void setVerticalFreeze(int n) {
        this.verticalFreeze = Math.max(n, 0);
    }

    public final void setCopies(int n) {
        this.copies = n;
    }

    public final int getCopies() {
        return this.copies;
    }

    public final HeaderFooter getHeader() {
        return this.header;
    }

    public final void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
    }

    public final void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
    }

    public final HeaderFooter getFooter() {
        return this.footer;
    }

    public final boolean isHorizontalCentre() {
        return this.horizontalCentre;
    }

    public final void setHorizontalCentre(boolean bl) {
        this.horizontalCentre = bl;
    }

    public final boolean isVerticalCentre() {
        return this.verticalCentre;
    }

    public final void setVerticalCentre(boolean bl) {
        this.verticalCentre = bl;
    }
}

