/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Logger;
import jxl.WorkbookSettings;
import jxl.biff.DVParser$Condition;
import jxl.biff.DVParser$DVType;
import jxl.biff.DVParser$ErrorStyle;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaParser;

public class DVParser {
    private static Logger logger = Logger.getLogger(class$jxl$biff$DVParser == null ? (class$jxl$biff$DVParser = DVParser.class$("jxl.biff.DVParser")) : class$jxl$biff$DVParser);
    public static final DVParser$DVType ANY = new DVParser$DVType(0);
    public static final DVParser$DVType INTEGER = new DVParser$DVType(1);
    public static final DVParser$DVType DECIMAL = new DVParser$DVType(2);
    public static final DVParser$DVType LIST = new DVParser$DVType(3);
    public static final DVParser$DVType DATE = new DVParser$DVType(4);
    public static final DVParser$DVType TIME = new DVParser$DVType(5);
    public static final DVParser$DVType TEXT_LENGTH = new DVParser$DVType(6);
    public static final DVParser$DVType FORMULA = new DVParser$DVType(7);
    public static final DVParser$ErrorStyle STOP = new DVParser$ErrorStyle(0);
    public static final DVParser$ErrorStyle WARNING = new DVParser$ErrorStyle(1);
    public static final DVParser$ErrorStyle INFO = new DVParser$ErrorStyle(2);
    public static final DVParser$Condition BETWEEN = new DVParser$Condition(0);
    public static final DVParser$Condition NOT_BETWEEN = new DVParser$Condition(1);
    public static final DVParser$Condition EQUAL = new DVParser$Condition(2);
    public static final DVParser$Condition NOT_EQUAL = new DVParser$Condition(3);
    public static final DVParser$Condition GREATER_THAN = new DVParser$Condition(4);
    public static final DVParser$Condition LESS_THAN = new DVParser$Condition(5);
    public static final DVParser$Condition GREATER_EQUAL = new DVParser$Condition(6);
    public static final DVParser$Condition LESS_EQUAL = new DVParser$Condition(7);
    private static int STRING_LIST_GIVEN_MASK = 128;
    private static int EMPTY_CELLS_ALLOWED_MASK = 256;
    private static int SUPPRESS_ARROW_MASK = 512;
    private static int SHOW_PROMPT_MASK = 262144;
    private static int SHOW_ERROR_MASK = 524288;
    private DVParser$DVType type;
    private DVParser$ErrorStyle errorStyle;
    private DVParser$Condition condition;
    private boolean stringListGiven;
    private boolean emptyCellsAllowed;
    private boolean suppressArrow;
    private boolean showPrompt;
    private boolean showError;
    private String promptTitle;
    private String errorTitle;
    private String promptText;
    private String errorText;
    private FormulaParser formula1;
    private FormulaParser formula2;
    private int column1;
    private int row1;
    private int column2;
    private int row2;
    static Class class$jxl$biff$DVParser;

    public DVParser(byte[] byArray, ExternalSheet externalSheet, WorkbookMethods workbookMethods, WorkbookSettings workbookSettings) {
        byte[] byArray2;
        int n = IntegerHelper.getInt(byArray[0], byArray[1], byArray[2], byArray[3]);
        int n2 = n & 0xF;
        this.type = DVParser$DVType.getType(n2);
        int n3 = (n & 0x70) >> 4;
        this.errorStyle = DVParser$ErrorStyle.getErrorStyle(n3);
        int n4 = (n & 0xF00000) >> 20;
        this.condition = DVParser$Condition.getCondition(n4);
        this.stringListGiven = (n & STRING_LIST_GIVEN_MASK) != 0;
        this.emptyCellsAllowed = (n & EMPTY_CELLS_ALLOWED_MASK) != 0;
        this.suppressArrow = (n & SUPPRESS_ARROW_MASK) != 0;
        this.showPrompt = (n & SHOW_PROMPT_MASK) != 0;
        this.showError = (n & SHOW_ERROR_MASK) != 0;
        int n5 = 4;
        int n6 = IntegerHelper.getInt(byArray[n5], byArray[n5 + 1]);
        this.promptTitle = StringHelper.getUnicodeString(byArray, n6, n5 + 2);
        n5 += n6 * 2 + 2;
        n6 = IntegerHelper.getInt(byArray[n5], byArray[n5 + 1]);
        this.errorTitle = StringHelper.getUnicodeString(byArray, n6, n5 + 2);
        n5 += n6 * 2 + 2;
        n6 = IntegerHelper.getInt(byArray[n5], byArray[n5 + 1]);
        this.promptText = StringHelper.getUnicodeString(byArray, n6, n5 + 2);
        n5 += n6 * 2 + 2;
        n6 = IntegerHelper.getInt(byArray[n5], byArray[n5 + 1]);
        this.errorText = StringHelper.getUnicodeString(byArray, n6, n5 + 2);
        int n7 = IntegerHelper.getInt(byArray[n5 += n6 * 2 + 2], byArray[n5 + 1]);
        n5 += 4;
        if (n7 != 0) {
            byArray2 = new byte[n7];
            System.arraycopy(byArray, n5, byArray2, 0, n7);
            this.formula1 = new FormulaParser(byArray2, null, externalSheet, workbookMethods, workbookSettings);
            this.formula1.parse();
            n5 += n7;
        }
        n7 = IntegerHelper.getInt(byArray[n5], byArray[n5 + 1]);
        n5 += 4;
        if (n7 != 0) {
            byArray2 = new byte[n7];
            System.arraycopy(byArray, n5, byArray2, 0, n7);
            this.formula2 = new FormulaParser(byArray2, null, externalSheet, workbookMethods, workbookSettings);
            this.formula2.parse();
            n5 += n7;
        }
        this.row1 = IntegerHelper.getInt(byArray[n5 += 2], byArray[n5 + 1]);
        this.row2 = IntegerHelper.getInt(byArray[n5 += 2], byArray[n5 + 1]);
        this.column1 = IntegerHelper.getInt(byArray[n5 += 2], byArray[n5 + 1]);
        this.column2 = IntegerHelper.getInt(byArray[n5 += 2], byArray[n5 + 1]);
        n5 += 2;
    }

    public final byte[] getData() {
        byte[] byArray = this.formula1 != null ? this.formula1.getBytes() : new byte[]{};
        byte[] byArray2 = this.formula2 != null ? this.formula2.getBytes() : new byte[]{};
        int n = 4 + this.promptTitle.length() * 2 + 2 + this.errorTitle.length() * 2 + 2 + this.promptText.length() * 2 + 2 + this.errorText.length() * 2 + 2 + byArray.length + 2 + byArray2.length + 2 + 4 + 10;
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        n3 |= this.type.getValue();
        n3 |= this.errorStyle.getValue() << 4;
        n3 |= this.condition.getValue() << 20;
        if (this.stringListGiven) {
            n3 |= STRING_LIST_GIVEN_MASK;
        }
        if (this.emptyCellsAllowed) {
            n3 |= EMPTY_CELLS_ALLOWED_MASK;
        }
        if (this.suppressArrow) {
            n3 |= SUPPRESS_ARROW_MASK;
        }
        if (this.showPrompt) {
            n3 |= SHOW_PROMPT_MASK;
        }
        if (this.showError) {
            n3 |= SHOW_ERROR_MASK;
        }
        IntegerHelper.getFourBytes(n3, byArray3, n2);
        IntegerHelper.getTwoBytes(this.promptTitle.length(), byArray3, n2 += 4);
        StringHelper.getUnicodeBytes(this.promptTitle, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.errorTitle.length(), byArray3, n2 += this.promptTitle.length() * 2);
        StringHelper.getUnicodeBytes(this.errorTitle, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.promptText.length(), byArray3, n2 += this.errorTitle.length() * 2);
        StringHelper.getUnicodeBytes(this.promptText, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.errorText.length(), byArray3, n2 += this.promptText.length() * 2);
        StringHelper.getUnicodeBytes(this.errorText, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(byArray.length, byArray3, n2 += this.errorText.length() * 2);
        System.arraycopy(byArray, 0, byArray3, n2 += 4, byArray.length);
        IntegerHelper.getTwoBytes(byArray2.length, byArray3, n2 += byArray.length);
        System.arraycopy(byArray2, 0, byArray3, n2 += 2, byArray2.length);
        n2 += byArray2.length;
        IntegerHelper.getTwoBytes(1, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.row1, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.row2, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.column1, byArray3, n2 += 2);
        IntegerHelper.getTwoBytes(this.column2, byArray3, n2 += 2);
        n2 += 2;
        return byArray3;
    }

    public final void insertRow(int n) {
        if (this.formula1 != null) {
            this.formula1.rowInserted(0, n, true);
        }
        if (this.formula2 != null) {
            this.formula2.rowInserted(0, n, true);
        }
        if (this.row1 >= n) {
            ++this.row1;
        }
        if (this.row2 >= n) {
            ++this.row2;
        }
    }

    public final void insertColumn(int n) {
        if (this.formula1 != null) {
            this.formula1.columnInserted(0, n, true);
        }
        if (this.formula2 != null) {
            this.formula2.columnInserted(0, n, true);
        }
        if (this.column1 >= n) {
            ++this.column1;
        }
        if (this.column2 >= n) {
            ++this.column2;
        }
    }

    public final void removeRow(int n) {
        if (this.formula1 != null) {
            this.formula1.rowRemoved(0, n, true);
        }
        if (this.formula2 != null) {
            this.formula2.rowRemoved(0, n, true);
        }
        if (this.row1 > n) {
            --this.row1;
        }
        if (this.row2 >= n) {
            --this.row2;
        }
    }

    public final void removeColumn(int n) {
        if (this.formula1 != null) {
            this.formula1.columnRemoved(0, n, true);
        }
        if (this.formula2 != null) {
            this.formula2.columnRemoved(0, n, true);
        }
        if (this.column1 > n) {
            --this.column1;
        }
        if (this.column2 >= n) {
            --this.column2;
        }
    }

    public final int getFirstColumn() {
        return this.column1;
    }

    public final int getLastColumn() {
        return this.column2;
    }

    public final int getFirstRow() {
        return this.row1;
    }

    public final int getLastRow() {
        return this.row2;
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

