/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import common.Logger;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.biff.BuiltInStyle;
import jxl.biff.DisplayFormat;
import jxl.biff.Fonts;
import jxl.biff.FormatRecord;
import jxl.biff.IndexMapping;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.PaletteRecord;
import jxl.biff.XFRecord;
import jxl.format.Colour;
import jxl.format.RGB;
import jxl.write.biff.File;

public class FormattingRecords {
    private static Logger logger = Logger.getLogger(class$jxl$biff$FormattingRecords == null ? (class$jxl$biff$FormattingRecords = FormattingRecords.class$("jxl.biff.FormattingRecords")) : class$jxl$biff$FormattingRecords);
    private HashMap formats;
    private ArrayList formatsList;
    private ArrayList xfRecords = new ArrayList(10);
    private int nextCustomIndexNumber;
    private Fonts fonts;
    private PaletteRecord palette;
    private static final int customFormatStartIndex = 164;
    private static final int maxFormatRecordsIndex = 441;
    private static final int minXFRecords = 21;
    static Class class$jxl$biff$FormattingRecords;

    public FormattingRecords(Fonts fonts) {
        this.formats = new HashMap(10);
        this.formatsList = new ArrayList(10);
        this.fonts = fonts;
        this.nextCustomIndexNumber = 164;
    }

    public final void addStyle(XFRecord xFRecord) {
        if (!xFRecord.isInitialized()) {
            int n = this.xfRecords.size();
            xFRecord.initialize(n, this, this.fonts);
            this.xfRecords.add(xFRecord);
        } else if (xFRecord.getXFIndex() >= this.xfRecords.size()) {
            this.xfRecords.add(xFRecord);
        }
    }

    public final void addFormat(DisplayFormat displayFormat) {
        if (displayFormat.isInitialized() && displayFormat.getFormatIndex() >= 441) {
            logger.warn("Format index exceeds Excel maximum - assigning custom number");
            displayFormat.initialize(this.nextCustomIndexNumber);
            ++this.nextCustomIndexNumber;
        }
        if (!displayFormat.isInitialized()) {
            displayFormat.initialize(this.nextCustomIndexNumber);
            ++this.nextCustomIndexNumber;
        }
        if (this.nextCustomIndexNumber > 441) {
            this.nextCustomIndexNumber = 441;
            throw new NumFormatRecordsException();
        }
        if (displayFormat.getFormatIndex() >= this.nextCustomIndexNumber) {
            this.nextCustomIndexNumber = displayFormat.getFormatIndex() + 1;
        }
        if (!displayFormat.isBuiltIn()) {
            this.formatsList.add(displayFormat);
            this.formats.put(new Integer(displayFormat.getFormatIndex()), displayFormat);
        }
    }

    public final boolean isDate(int n) {
        XFRecord xFRecord = (XFRecord)this.xfRecords.get(n);
        if (xFRecord.isDate()) {
            return true;
        }
        FormatRecord formatRecord = (FormatRecord)this.formats.get(new Integer(xFRecord.getFormatRecord()));
        return formatRecord == null ? false : formatRecord.isDate();
    }

    public final DateFormat getDateFormat(int n) {
        XFRecord xFRecord = (XFRecord)this.xfRecords.get(n);
        if (xFRecord.isDate()) {
            return xFRecord.getDateFormat();
        }
        FormatRecord formatRecord = (FormatRecord)this.formats.get(new Integer(xFRecord.getFormatRecord()));
        if (formatRecord == null) {
            return null;
        }
        return formatRecord.isDate() ? formatRecord.getDateFormat() : null;
    }

    public final NumberFormat getNumberFormat(int n) {
        XFRecord xFRecord = (XFRecord)this.xfRecords.get(n);
        if (xFRecord.isNumber()) {
            return xFRecord.getNumberFormat();
        }
        FormatRecord formatRecord = (FormatRecord)this.formats.get(new Integer(xFRecord.getFormatRecord()));
        if (formatRecord == null) {
            return null;
        }
        return formatRecord.isNumber() ? formatRecord.getNumberFormat() : null;
    }

    final FormatRecord getFormatRecord(int n) {
        return (FormatRecord)this.formats.get(new Integer(n));
    }

    public final void write(File file) {
        Iterator iterator = this.formatsList.iterator();
        FormatRecord formatRecord = null;
        while (iterator.hasNext()) {
            formatRecord = (FormatRecord)iterator.next();
            file.write(formatRecord);
        }
        iterator = this.xfRecords.iterator();
        XFRecord xFRecord = null;
        while (iterator.hasNext()) {
            xFRecord = (XFRecord)iterator.next();
            file.write(xFRecord);
        }
        BuiltInStyle builtInStyle = new BuiltInStyle(16, 3);
        file.write(builtInStyle);
        builtInStyle = new BuiltInStyle(17, 6);
        file.write(builtInStyle);
        builtInStyle = new BuiltInStyle(18, 4);
        file.write(builtInStyle);
        builtInStyle = new BuiltInStyle(19, 7);
        file.write(builtInStyle);
        builtInStyle = new BuiltInStyle(0, 0);
        file.write(builtInStyle);
        builtInStyle = new BuiltInStyle(20, 5);
        file.write(builtInStyle);
    }

    protected final Fonts getFonts() {
        return this.fonts;
    }

    public final XFRecord getXFRecord(int n) {
        return (XFRecord)this.xfRecords.get(n);
    }

    protected final int getNumberOfFormatRecords() {
        return this.formatsList.size();
    }

    public final IndexMapping rationalizeFonts() {
        return this.fonts.rationalize();
    }

    public final IndexMapping rationalize(IndexMapping indexMapping, IndexMapping indexMapping2) {
        XFRecord xFRecord;
        int n;
        XFRecord xFRecord2 = null;
        Object object = this.xfRecords.iterator();
        while (object.hasNext()) {
            xFRecord2 = (XFRecord)object.next();
            if (xFRecord2.getFormatRecord() >= 164) {
                xFRecord2.setFormatIndex(indexMapping2.getNewIndex(xFRecord2.getFormatRecord()));
            }
            xFRecord2.setFontIndex(indexMapping.getNewIndex(xFRecord2.getFontIndex()));
        }
        object = new ArrayList(21);
        IndexMapping indexMapping3 = new IndexMapping(this.xfRecords.size());
        int n2 = 0;
        int n3 = Math.min(21, this.xfRecords.size());
        for (n = 0; n < n3; ++n) {
            ((ArrayList)object).add(this.xfRecords.get(n));
            indexMapping3.setMapping(n, n);
        }
        if (n3 < 21) {
            logger.warn("There are less than the expected minimum number of XF records");
            return indexMapping3;
        }
        for (n = 21; n < this.xfRecords.size(); ++n) {
            xFRecord = (XFRecord)this.xfRecords.get(n);
            boolean bl = false;
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext() && !bl) {
                XFRecord xFRecord3 = (XFRecord)iterator.next();
                if (!xFRecord3.equals(xFRecord)) continue;
                bl = true;
                indexMapping3.setMapping(n, indexMapping3.getNewIndex(xFRecord3.getXFIndex()));
                ++n2;
            }
            if (bl) continue;
            ((ArrayList)object).add(xFRecord);
            indexMapping3.setMapping(n, n - n2);
        }
        Iterator iterator = this.xfRecords.iterator();
        while (iterator.hasNext()) {
            xFRecord = (XFRecord)iterator.next();
            xFRecord.rationalize(indexMapping3);
        }
        this.xfRecords = object;
        return indexMapping3;
    }

    public final IndexMapping rationalizeDisplayFormats() {
        ArrayList<DisplayFormat> arrayList = new ArrayList<DisplayFormat>();
        int n = 0;
        IndexMapping indexMapping = new IndexMapping(this.nextCustomIndexNumber);
        Iterator iterator = this.formatsList.iterator();
        DisplayFormat displayFormat = null;
        DisplayFormat displayFormat2 = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            displayFormat = (DisplayFormat)iterator.next();
            Assert.verify(!displayFormat.isBuiltIn());
            Iterator iterator2 = arrayList.iterator();
            bl = false;
            while (iterator2.hasNext() && !bl) {
                displayFormat2 = (DisplayFormat)iterator2.next();
                if (!displayFormat2.equals(displayFormat)) continue;
                bl = true;
                indexMapping.setMapping(displayFormat.getFormatIndex(), indexMapping.getNewIndex(displayFormat2.getFormatIndex()));
                ++n;
            }
            if (bl) continue;
            arrayList.add(displayFormat);
            int n2 = displayFormat.getFormatIndex() - n;
            if (n2 > 441) {
                logger.warn("Too many number formats - using default format.");
                n2 = 0;
            }
            indexMapping.setMapping(displayFormat.getFormatIndex(), displayFormat.getFormatIndex() - n);
        }
        this.formatsList = arrayList;
        iterator = this.formatsList.iterator();
        while (iterator.hasNext()) {
            displayFormat = (DisplayFormat)iterator.next();
            displayFormat.initialize(indexMapping.getNewIndex(displayFormat.getFormatIndex()));
        }
        return indexMapping;
    }

    public final PaletteRecord getPalette() {
        return this.palette;
    }

    public final void setPalette(PaletteRecord paletteRecord) {
        this.palette = paletteRecord;
    }

    public final void setColourRGB(Colour colour, int n, int n2, int n3) {
        if (this.palette == null) {
            this.palette = new PaletteRecord();
        }
        this.palette.setColourRGB(colour, n, n2, n3);
    }

    public final RGB getColourRGB(Colour colour) {
        if (this.palette == null) {
            return colour.getDefaultRGB();
        }
        return this.palette.getColourRGB(colour);
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

