/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.Logger;
import jxl.WorkbookSettings;
import jxl.biff.ContinueRecord;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.drawing.ClientAnchor;
import jxl.biff.drawing.ClientData;
import jxl.biff.drawing.ClientTextBox;
import jxl.biff.drawing.DrawingData;
import jxl.biff.drawing.DrawingGroup;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecord;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.NoteRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.biff.drawing.Opt;
import jxl.biff.drawing.Origin;
import jxl.biff.drawing.ShapeType;
import jxl.biff.drawing.Sp;
import jxl.biff.drawing.SpContainer;
import jxl.biff.drawing.TextObjectRecord;
import jxl.write.biff.File;

public class Comment
implements DrawingGroupObject {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$Comment == null ? (class$jxl$biff$drawing$Comment = Comment.class$("jxl.biff.drawing.Comment")) : class$jxl$biff$drawing$Comment);
    private EscherContainer readSpContainer;
    private EscherContainer spContainer;
    private MsoDrawingRecord msoDrawingRecord;
    private ObjRecord objRecord;
    private boolean initialized = false;
    private int objectId;
    private int blipId;
    private int shapeId;
    private int column;
    private int row;
    private double width;
    private double height;
    private int referenceCount;
    private EscherContainer escherData;
    private Origin origin;
    private DrawingGroup drawingGroup;
    private DrawingData drawingData;
    private ShapeType type;
    private int drawingNumber;
    private MsoDrawingRecord mso;
    private TextObjectRecord txo;
    private NoteRecord note;
    private ContinueRecord text;
    private ContinueRecord formatting;
    private String commentText;
    private WorkbookSettings workbookSettings;
    static Class class$jxl$biff$drawing$Comment;

    public Comment(MsoDrawingRecord msoDrawingRecord, ObjRecord objRecord, DrawingData drawingData, DrawingGroup drawingGroup, WorkbookSettings workbookSettings) {
        this.drawingGroup = drawingGroup;
        this.msoDrawingRecord = msoDrawingRecord;
        this.drawingData = drawingData;
        this.objRecord = objRecord;
        this.initialized = false;
        this.workbookSettings = workbookSettings;
        this.origin = Origin.READ;
        this.drawingData.addData(this.msoDrawingRecord.getData());
        this.drawingNumber = this.drawingData.getNumDrawings() - 1;
        this.drawingGroup.addDrawing(this);
        Assert.verify(msoDrawingRecord != null && objRecord != null);
        if (!this.initialized) {
            this.initialize();
        }
    }

    public Comment(DrawingGroupObject drawingGroupObject, DrawingGroup drawingGroup, WorkbookSettings workbookSettings) {
        Comment comment = (Comment)drawingGroupObject;
        Assert.verify(comment.origin == Origin.READ);
        this.msoDrawingRecord = comment.msoDrawingRecord;
        this.objRecord = comment.objRecord;
        this.initialized = false;
        this.origin = Origin.READ;
        this.drawingData = comment.drawingData;
        this.drawingGroup = drawingGroup;
        this.drawingNumber = comment.drawingNumber;
        this.drawingGroup.addDrawing(this);
        this.mso = comment.mso;
        this.txo = comment.txo;
        this.text = comment.text;
        this.formatting = comment.formatting;
        this.note = comment.note;
        this.width = comment.width;
        this.height = comment.height;
        this.workbookSettings = workbookSettings;
    }

    public Comment(String string, int n, int n2) {
        this.initialized = true;
        this.origin = Origin.WRITE;
        this.column = n;
        this.row = n2;
        this.referenceCount = 1;
        this.type = ShapeType.TEXT_BOX;
        this.commentText = string;
        this.width = 3.0;
        this.height = 4.0;
    }

    private void initialize() {
        this.readSpContainer = this.drawingData.getSpContainer(this.drawingNumber);
        Assert.verify(this.readSpContainer != null);
        EscherRecord[] escherRecordArray = this.readSpContainer.getChildren();
        Sp sp = (Sp)this.readSpContainer.getChildren()[0];
        this.objectId = this.objRecord.getObjectId();
        this.shapeId = sp.getShapeId();
        this.type = ShapeType.getType(sp.getShapeType());
        if (this.type == ShapeType.UNKNOWN) {
            logger.warn("Unknown shape type");
        }
        Opt opt = (Opt)this.readSpContainer.getChildren()[1];
        ClientAnchor clientAnchor = null;
        for (int i2 = 0; i2 < escherRecordArray.length && clientAnchor == null; ++i2) {
            if (escherRecordArray[i2].getType() != EscherRecordType.CLIENT_ANCHOR) continue;
            clientAnchor = (ClientAnchor)escherRecordArray[i2];
        }
        if (clientAnchor == null) {
            logger.warn("client anchor not found");
        } else {
            this.column = (int)clientAnchor.getX1() - 1;
            this.row = (int)clientAnchor.getY1() + 1;
            this.width = clientAnchor.getX2() - clientAnchor.getX1();
            this.height = clientAnchor.getY2() - clientAnchor.getY1();
        }
        this.initialized = true;
    }

    public final void setObjectId(int n, int n2, int n3) {
        this.objectId = n;
        this.blipId = n2;
        this.shapeId = n3;
        if (this.origin == Origin.READ) {
            this.origin = Origin.READ_WRITE;
        }
    }

    public final int getObjectId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.objectId;
    }

    public final int getShapeId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.shapeId;
    }

    public final int getBlipId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.blipId;
    }

    public final MsoDrawingRecord getMsoDrawingRecord() {
        return this.msoDrawingRecord;
    }

    public final EscherContainer getSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.origin == Origin.READ) {
            return this.getReadSpContainer();
        }
        if (this.spContainer == null) {
            this.spContainer = new SpContainer();
            Sp sp = new Sp(this.type, this.shapeId, 2560);
            this.spContainer.add(sp);
            Opt opt = new Opt();
            opt.addProperty(344, false, false, 0);
            opt.addProperty(385, false, false, 0x8000050);
            opt.addProperty(387, false, false, 0x8000050);
            opt.addProperty(959, false, false, 131074);
            this.spContainer.add(opt);
            ClientAnchor clientAnchor = new ClientAnchor((double)this.column + 1.3, Math.max(0.0, (double)this.row - 0.6), (double)this.column + 1.3 + this.width, (double)this.row + this.height);
            this.spContainer.add(clientAnchor);
            ClientData clientData = new ClientData();
            this.spContainer.add(clientData);
            ClientTextBox clientTextBox = new ClientTextBox();
            this.spContainer.add(clientTextBox);
        }
        return this.spContainer;
    }

    public final void setDrawingGroup(DrawingGroup drawingGroup) {
        this.drawingGroup = drawingGroup;
    }

    public final DrawingGroup getDrawingGroup() {
        return this.drawingGroup;
    }

    public final Origin getOrigin() {
        return this.origin;
    }

    public final int getReferenceCount() {
        return this.referenceCount;
    }

    public final void setReferenceCount(int n) {
        this.referenceCount = n;
    }

    public final double getX() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.column;
    }

    public final void setX(double d2) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.column = (int)d2;
    }

    public final double getY() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.row;
    }

    public final void setY(double d2) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.row = (int)d2;
    }

    public final double getWidth() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.width;
    }

    public final void setWidth(double d2) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.width = d2;
    }

    public final double getHeight() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.height;
    }

    public final void setHeight(double d2) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.height = d2;
    }

    private EscherContainer getReadSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.readSpContainer;
    }

    public final byte[] getImageData() {
        Assert.verify(this.origin == Origin.READ || this.origin == Origin.READ_WRITE);
        if (!this.initialized) {
            this.initialize();
        }
        return this.drawingGroup.getImageData(this.blipId);
    }

    public final ShapeType getType() {
        return this.type;
    }

    public final void setTextObject(TextObjectRecord textObjectRecord) {
        this.txo = textObjectRecord;
    }

    public final void setNote(NoteRecord noteRecord) {
        this.note = noteRecord;
    }

    public final void setText(ContinueRecord continueRecord) {
        this.text = continueRecord;
    }

    public final void setFormatting(ContinueRecord continueRecord) {
        this.formatting = continueRecord;
    }

    public final byte[] getImageBytes() {
        Assert.verify(false);
        return null;
    }

    public final String getImageFilePath() {
        Assert.verify(false);
        return null;
    }

    public final void addMso(MsoDrawingRecord msoDrawingRecord) {
        this.mso = msoDrawingRecord;
        this.drawingData.addRawData(this.mso.getData());
    }

    public final void writeAdditionalRecords(File file) {
        if (this.origin == Origin.READ) {
            file.write(this.objRecord);
            if (this.mso != null) {
                file.write(this.mso);
            }
            file.write(this.txo);
            file.write(this.text);
            if (this.formatting != null) {
                file.write(this.formatting);
            }
            return;
        }
        ObjRecord objRecord = new ObjRecord(this.objectId, ObjRecord.EXCELNOTE);
        file.write(objRecord);
        ClientTextBox clientTextBox = new ClientTextBox();
        MsoDrawingRecord msoDrawingRecord = new MsoDrawingRecord(clientTextBox.getData());
        file.write(msoDrawingRecord);
        TextObjectRecord textObjectRecord = new TextObjectRecord(this.getText());
        file.write(textObjectRecord);
        byte[] byArray = new byte[this.commentText.length() * 2 + 1];
        byArray[0] = 1;
        StringHelper.getUnicodeBytes(this.commentText, byArray, 1);
        ContinueRecord continueRecord = new ContinueRecord(byArray);
        file.write(continueRecord);
        byte[] byArray2 = new byte[16];
        IntegerHelper.getTwoBytes(0, byArray2, 0);
        IntegerHelper.getTwoBytes(0, byArray2, 2);
        IntegerHelper.getTwoBytes(this.commentText.length(), byArray2, 8);
        IntegerHelper.getTwoBytes(0, byArray2, 10);
        ContinueRecord continueRecord2 = new ContinueRecord(byArray2);
        file.write(continueRecord2);
    }

    public final void writeTailRecords(File file) {
        if (this.origin == Origin.READ) {
            file.write(this.note);
            return;
        }
        NoteRecord noteRecord = new NoteRecord(this.column, this.row, this.objectId);
        file.write(noteRecord);
    }

    public final int getRow() {
        return this.note.getRow();
    }

    public final int getColumn() {
        return this.note.getColumn();
    }

    public final String getText() {
        if (this.commentText == null) {
            Assert.verify(this.text != null);
            byte[] byArray = this.text.getData();
            this.commentText = byArray[0] == 0 ? StringHelper.getString(byArray, byArray.length - 1, 1, this.workbookSettings) : StringHelper.getUnicodeString(byArray, (byArray.length - 1) / 2, 1);
        }
        return this.commentText;
    }

    public final int hashCode() {
        return this.commentText.hashCode();
    }

    public final void setCommentText(String string) {
        this.commentText = string;
        if (this.origin == Origin.READ) {
            this.origin = Origin.READ_WRITE;
        }
    }

    public final boolean isFirst() {
        return this.msoDrawingRecord.isFirst();
    }

    public final boolean isFormObject() {
        return true;
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

