/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.biff.ByteData;
import jxl.biff.drawing.BStoreContainer;
import jxl.biff.drawing.BlipStoreEntry;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Dgg;
import jxl.biff.drawing.DggContainer;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecord;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;
import jxl.biff.drawing.MsoDrawingGroupRecord;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.biff.drawing.Opt;
import jxl.biff.drawing.Origin;
import jxl.biff.drawing.SplitMenuColors;
import jxl.read.biff.Record;
import jxl.write.biff.File;

public class DrawingGroup
implements EscherStream {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$DrawingGroup == null ? (class$jxl$biff$drawing$DrawingGroup = DrawingGroup.class$("jxl.biff.drawing.DrawingGroup")) : class$jxl$biff$drawing$DrawingGroup);
    private byte[] drawingData;
    private EscherContainer escherData;
    private BStoreContainer bstoreContainer;
    private boolean initialized;
    private ArrayList drawings;
    private int numBlips;
    private int numCharts;
    private int drawingGroupId;
    private boolean drawingsOmitted;
    private Origin origin;
    private HashMap imageFiles;
    private int maxObjectId;
    private int maxShapeId;
    static Class class$jxl$biff$drawing$DrawingGroup;

    public DrawingGroup(Origin origin) {
        this.origin = origin;
        this.initialized = origin == Origin.WRITE;
        this.drawings = new ArrayList();
        this.imageFiles = new HashMap();
        this.drawingsOmitted = false;
        this.maxObjectId = 1;
        this.maxShapeId = 1024;
    }

    public DrawingGroup(DrawingGroup drawingGroup) {
        this.drawingData = drawingGroup.drawingData;
        this.escherData = drawingGroup.escherData;
        this.bstoreContainer = drawingGroup.bstoreContainer;
        this.initialized = drawingGroup.initialized;
        this.drawingData = drawingGroup.drawingData;
        this.escherData = drawingGroup.escherData;
        this.bstoreContainer = drawingGroup.bstoreContainer;
        this.numBlips = drawingGroup.numBlips;
        this.numCharts = drawingGroup.numCharts;
        this.drawingGroupId = drawingGroup.drawingGroupId;
        this.drawingsOmitted = drawingGroup.drawingsOmitted;
        this.origin = drawingGroup.origin;
        this.imageFiles = (HashMap)drawingGroup.imageFiles.clone();
        this.maxObjectId = drawingGroup.maxObjectId;
        this.maxShapeId = drawingGroup.maxShapeId;
        this.drawings = new ArrayList();
    }

    public final void add(MsoDrawingGroupRecord msoDrawingGroupRecord) {
        this.addData(msoDrawingGroupRecord.getData());
    }

    public final void add(Record record) {
        this.addData(record.getData());
    }

    private void addData(byte[] byArray) {
        if (this.drawingData == null) {
            this.drawingData = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.drawingData, 0, byArray.length);
            return;
        }
        byte[] byArray2 = new byte[this.drawingData.length + byArray.length];
        System.arraycopy(this.drawingData, 0, byArray2, 0, this.drawingData.length);
        System.arraycopy(byArray, 0, byArray2, this.drawingData.length, byArray.length);
        this.drawingData = byArray2;
    }

    final void addDrawing(DrawingGroupObject drawingGroupObject) {
        this.drawings.add(drawingGroupObject);
        this.maxObjectId = Math.max(this.maxObjectId, drawingGroupObject.getObjectId());
        this.maxShapeId = Math.max(this.maxShapeId, drawingGroupObject.getShapeId());
    }

    public final void add(Chart chart) {
        ++this.numCharts;
    }

    public final void add(DrawingGroupObject drawingGroupObject) {
        Object object;
        Object object2;
        if (this.origin == Origin.READ) {
            this.origin = Origin.READ_WRITE;
            object2 = this.getBStoreContainer();
            object = (Dgg)this.escherData.getChildren()[0];
            this.drawingGroupId = ((Dgg)object).getCluster((int)1).drawingGroupId - this.numBlips - 1;
            int n = ((Dgg)object).getDrawingsSaved();
            int n2 = this.numBlips = object2 != null ? ((BStoreContainer)object2).getNumBlips() : 0;
            if (object2 != null) {
                Assert.verify(this.numBlips == ((BStoreContainer)object2).getNumBlips());
            }
        }
        if (!(drawingGroupObject instanceof Drawing)) {
            ++this.maxObjectId;
            ++this.maxShapeId;
            drawingGroupObject.setDrawingGroup(this);
            drawingGroupObject.setObjectId(this.maxObjectId, this.numBlips + 1, this.maxShapeId);
            if (this.drawings.size() > this.maxObjectId) {
                logger.warn("drawings length " + this.drawings.size() + " exceeds the max object id " + this.maxObjectId);
            }
            return;
        }
        object2 = (Drawing)drawingGroupObject;
        object = (Drawing)this.imageFiles.get(drawingGroupObject.getImageFilePath());
        if (object == null) {
            ++this.maxObjectId;
            ++this.maxShapeId;
            this.drawings.add(object2);
            ((Drawing)object2).setDrawingGroup(this);
            ((Drawing)object2).setObjectId(this.maxObjectId, this.numBlips + 1, this.maxShapeId);
            ++this.numBlips;
            this.imageFiles.put(((Drawing)object2).getImageFilePath(), object2);
        } else {
            ((Drawing)object).setReferenceCount(((Drawing)object).getReferenceCount() + 1);
            ((Drawing)object2).setDrawingGroup(this);
            ((Drawing)object2).setObjectId(((Drawing)object).getObjectId(), ((Drawing)object).getBlipId(), ((Drawing)object).getShapeId());
        }
    }

    public final void remove(DrawingGroupObject drawingGroupObject) {
        Object object;
        if (this.getBStoreContainer() == null) {
            return;
        }
        if (this.origin == Origin.READ) {
            this.origin = Origin.READ_WRITE;
            this.numBlips = this.getBStoreContainer().getNumBlips();
            object = (Dgg)this.escherData.getChildren()[0];
            this.drawingGroupId = ((Dgg)object).getCluster((int)1).drawingGroupId - this.numBlips - 1;
        }
        object = this.getBStoreContainer().getChildren();
        BlipStoreEntry blipStoreEntry = (BlipStoreEntry)object[drawingGroupObject.getBlipId() - 1];
        blipStoreEntry.dereference();
        if (blipStoreEntry.getReferenceCount() == 0) {
            this.getBStoreContainer().remove(blipStoreEntry);
            Iterator iterator = this.drawings.iterator();
            while (iterator.hasNext()) {
                DrawingGroupObject drawingGroupObject2 = (DrawingGroupObject)iterator.next();
                if (drawingGroupObject2.getBlipId() <= drawingGroupObject.getBlipId()) continue;
                drawingGroupObject2.setObjectId(drawingGroupObject2.getObjectId(), drawingGroupObject2.getBlipId() - 1, drawingGroupObject2.getShapeId());
            }
            --this.numBlips;
        }
    }

    private void initialize() {
        EscherRecordData escherRecordData = new EscherRecordData(this, 0);
        Assert.verify(escherRecordData.isContainer());
        this.escherData = new EscherContainer(escherRecordData);
        Assert.verify(this.escherData.getLength() == this.drawingData.length);
        Assert.verify(this.escherData.getType() == EscherRecordType.DGG_CONTAINER);
        this.initialized = true;
    }

    private BStoreContainer getBStoreContainer() {
        if (this.bstoreContainer == null) {
            EscherRecord[] escherRecordArray;
            if (!this.initialized) {
                this.initialize();
            }
            if ((escherRecordArray = this.escherData.getChildren()).length > 1 && escherRecordArray[1].getType() == EscherRecordType.BSTORE_CONTAINER) {
                this.bstoreContainer = (BStoreContainer)escherRecordArray[1];
            }
        }
        return this.bstoreContainer;
    }

    public final byte[] getData() {
        return this.drawingData;
    }

    public final void write(File file) {
        Object object;
        if (this.origin == Origin.WRITE) {
            Object object2;
            object = new DggContainer();
            Dgg dgg = new Dgg(this.numBlips + this.numCharts + 1, this.numBlips);
            dgg.addCluster(1, 0);
            dgg.addCluster(this.numBlips + 1, 0);
            ((EscherContainer)object).add(dgg);
            int n = 0;
            BStoreContainer bStoreContainer = new BStoreContainer();
            Object object3 = this.drawings.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                if (!(object2 instanceof Drawing)) continue;
                Drawing drawing = (Drawing)object2;
                BlipStoreEntry blipStoreEntry = new BlipStoreEntry(drawing);
                bStoreContainer.add(blipStoreEntry);
                ++n;
            }
            if (n > 0) {
                bStoreContainer.setNumBlips(n);
                ((EscherContainer)object).add(bStoreContainer);
            }
            object3 = new Opt();
            ((EscherContainer)object).add((EscherRecord)object3);
            object2 = new SplitMenuColors();
            ((EscherContainer)object).add((EscherRecord)object2);
            this.drawingData = ((EscherContainer)object).getData();
        } else if (this.origin == Origin.READ_WRITE) {
            Object object4;
            Object object5;
            object = new DggContainer();
            Dgg dgg = new Dgg(this.numBlips + this.numCharts + 1, this.numBlips);
            dgg.addCluster(1, 0);
            dgg.addCluster(this.drawingGroupId + this.numBlips + 1, 0);
            ((EscherContainer)object).add(dgg);
            BStoreContainer bStoreContainer = new BStoreContainer();
            bStoreContainer.setNumBlips(this.numBlips);
            BStoreContainer bStoreContainer2 = this.getBStoreContainer();
            if (bStoreContainer2 != null) {
                object5 = bStoreContainer2.getChildren();
                for (int i2 = 0; i2 < ((Object)object5).length; ++i2) {
                    object4 = (BlipStoreEntry)object5[i2];
                    bStoreContainer.add((EscherRecord)object4);
                }
            }
            object5 = this.drawings.iterator();
            while (object5.hasNext()) {
                DrawingGroupObject drawingGroupObject = (DrawingGroupObject)object5.next();
                if (!(drawingGroupObject instanceof Drawing) || ((Drawing)(object4 = (Drawing)drawingGroupObject)).getOrigin() == Origin.READ) continue;
                BlipStoreEntry blipStoreEntry = new BlipStoreEntry((Drawing)object4);
                bStoreContainer.add(blipStoreEntry);
            }
            ((EscherContainer)object).add(bStoreContainer);
            object5 = new Opt();
            ((Opt)object5).addProperty(191, false, false, 524296);
            ((Opt)object5).addProperty(385, false, false, 0x8000009);
            ((Opt)object5).addProperty(448, false, false, 0x8000040);
            ((EscherContainer)object).add((EscherRecord)object5);
            SplitMenuColors splitMenuColors = new SplitMenuColors();
            ((EscherContainer)object).add(splitMenuColors);
            this.drawingData = ((EscherContainer)object).getData();
        }
        object = new MsoDrawingGroupRecord(this.drawingData);
        file.write((ByteData)object);
    }

    final int getNumberOfBlips() {
        return this.numBlips;
    }

    final byte[] getImageData(int n) {
        this.numBlips = this.getBStoreContainer().getNumBlips();
        Assert.verify(n <= this.numBlips);
        Assert.verify(this.origin == Origin.READ || this.origin == Origin.READ_WRITE);
        EscherRecord[] escherRecordArray = this.getBStoreContainer().getChildren();
        BlipStoreEntry blipStoreEntry = (BlipStoreEntry)escherRecordArray[n - 1];
        return blipStoreEntry.getImageData();
    }

    public final void setDrawingsOmitted(MsoDrawingRecord msoDrawingRecord, ObjRecord objRecord) {
        this.drawingsOmitted = true;
        if (objRecord != null) {
            this.maxObjectId = Math.max(this.maxObjectId, objRecord.getObjectId());
        }
    }

    public final boolean hasDrawingsOmitted() {
        return this.drawingsOmitted;
    }

    public final void updateData(DrawingGroup drawingGroup) {
        this.drawingsOmitted = drawingGroup.drawingsOmitted;
        this.maxObjectId = drawingGroup.maxObjectId;
        this.maxShapeId = drawingGroup.maxShapeId;
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

