/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.drawing.EscherAtom;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.Opt$Property;

class Opt
extends EscherAtom {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$Opt == null ? (class$jxl$biff$drawing$Opt = Opt.class$("jxl.biff.drawing.Opt")) : class$jxl$biff$drawing$Opt);
    private byte[] data;
    private int numProperties;
    private ArrayList properties;
    static Class class$jxl$biff$drawing$Opt;

    public Opt(EscherRecordData escherRecordData) {
        super(escherRecordData);
        this.numProperties = this.getInstance();
        this.readProperties();
    }

    private void readProperties() {
        this.properties = new ArrayList();
        int n = 0;
        byte[] byArray = this.getBytes();
        for (int i2 = 0; i2 < this.numProperties; ++i2) {
            int n2 = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
            int n3 = n2 & 0x3FFF;
            int n4 = IntegerHelper.getInt(byArray[n + 2], byArray[n + 3], byArray[n + 4], byArray[n + 5]);
            Opt$Property opt$Property = new Opt$Property(n3, (n2 & 0x4000) != 0, (n2 & 0x8000) != 0, n4);
            n += 6;
            this.properties.add(opt$Property);
        }
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            Opt$Property opt$Property = (Opt$Property)iterator.next();
            if (!opt$Property.complex) continue;
            opt$Property.stringValue = StringHelper.getUnicodeString(byArray, opt$Property.value / 2, n);
            n += opt$Property.value;
        }
    }

    public Opt() {
        super(EscherRecordType.OPT);
        this.properties = new ArrayList();
        this.setVersion(3);
    }

    final byte[] getData() {
        Opt$Property opt$Property;
        this.numProperties = this.properties.size();
        this.setInstance(this.numProperties);
        this.data = new byte[this.numProperties * 6];
        int n = 0;
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            opt$Property = (Opt$Property)iterator.next();
            int n2 = opt$Property.id & 0x3FFF;
            if (opt$Property.blipId) {
                n2 |= 0x4000;
            }
            if (opt$Property.complex) {
                n2 |= 0x8000;
            }
            IntegerHelper.getTwoBytes(n2, this.data, n);
            IntegerHelper.getFourBytes(opt$Property.value, this.data, n + 2);
            n += 6;
        }
        iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            opt$Property = (Opt$Property)iterator.next();
            if (!opt$Property.complex || opt$Property.stringValue == null) continue;
            byte[] byArray = new byte[this.data.length + opt$Property.stringValue.length() * 2];
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            StringHelper.getUnicodeBytes(opt$Property.stringValue, byArray, this.data.length);
            this.data = byArray;
        }
        return this.setHeaderData(this.data);
    }

    final void addProperty(int n, boolean bl, boolean bl2, int n2) {
        Opt$Property opt$Property = new Opt$Property(n, bl, bl2, n2);
        this.properties.add(opt$Property);
    }

    final void addProperty(int n, boolean bl, boolean bl2, int n2, String string) {
        Opt$Property opt$Property = new Opt$Property(n, bl, bl2, n2, string);
        this.properties.add(opt$Property);
    }

    final Opt$Property getProperty(int n) {
        boolean bl = false;
        Opt$Property opt$Property = null;
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext() && !bl) {
            opt$Property = (Opt$Property)iterator.next();
            if (opt$Property.id != n) continue;
            bl = true;
        }
        return bl ? opt$Property : null;
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

