/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.read.biff.ExternalSheetRecord$Biff7;
import jxl.read.biff.ExternalSheetRecord$XTI;
import jxl.read.biff.Record;

public class ExternalSheetRecord
extends RecordData {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$ExternalSheetRecord == null ? (class$jxl$read$biff$ExternalSheetRecord = ExternalSheetRecord.class$("jxl.read.biff.ExternalSheetRecord")) : class$jxl$read$biff$ExternalSheetRecord);
    public static ExternalSheetRecord$Biff7 biff7 = new ExternalSheetRecord$Biff7(null);
    private ExternalSheetRecord$XTI[] xtiArray;
    static Class class$jxl$read$biff$ExternalSheetRecord;

    ExternalSheetRecord(Record record, WorkbookSettings workbookSettings) {
        super(record);
        byte[] byArray = this.getRecord().getData();
        int n = IntegerHelper.getInt(byArray[0], byArray[1]);
        if (byArray.length < n * 6 + 2) {
            this.xtiArray = new ExternalSheetRecord$XTI[0];
            logger.warn("Could not process external sheets.  Formulas may be compromised.");
            return;
        }
        this.xtiArray = new ExternalSheetRecord$XTI[n];
        int n2 = 2;
        for (int i2 = 0; i2 < n; ++i2) {
            int n3 = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1]);
            int n4 = IntegerHelper.getInt(byArray[n2 + 2], byArray[n2 + 3]);
            int n5 = IntegerHelper.getInt(byArray[n2 + 4], byArray[n2 + 5]);
            this.xtiArray[i2] = new ExternalSheetRecord$XTI(n3, n4, n5);
            n2 += 6;
        }
    }

    ExternalSheetRecord(Record record, WorkbookSettings workbookSettings, ExternalSheetRecord$Biff7 externalSheetRecord$Biff7) {
        super(record);
        logger.warn("External sheet record for Biff 7 not supported");
    }

    public final int getNumRecords() {
        return this.xtiArray != null ? this.xtiArray.length : 0;
    }

    public final int getSupbookIndex(int n) {
        return this.xtiArray[n].supbookIndex;
    }

    public final int getFirstTabIndex(int n) {
        return this.xtiArray[n].firstTab;
    }

    public final int getLastTabIndex(int n) {
        return this.xtiArray[n].lastTab;
    }

    public final byte[] getData() {
        return this.getRecord().getData();
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

