/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.StringHelper;
import jxl.read.biff.Record;
import jxl.read.biff.SSTRecord$BooleanHolder;
import jxl.read.biff.SSTRecord$ByteArrayHolder;

class SSTRecord
extends RecordData {
    private int totalStrings;
    private int uniqueStrings;
    private String[] strings;
    private int[] continuationBreaks;

    public SSTRecord(Record record, Record[] recordArray, WorkbookSettings workbookSettings) {
        super(record);
        int n = 0;
        for (int i2 = 0; i2 < recordArray.length; ++i2) {
            n += recordArray[i2].getLength();
        }
        byte[] byArray = new byte[n += this.getRecord().getLength()];
        int n2 = 0;
        System.arraycopy(this.getRecord().getData(), 0, byArray, 0, this.getRecord().getLength());
        n2 += this.getRecord().getLength();
        this.continuationBreaks = new int[recordArray.length];
        Record record2 = null;
        for (int i3 = 0; i3 < recordArray.length; ++i3) {
            record2 = recordArray[i3];
            System.arraycopy(record2.getData(), 0, byArray, n2, record2.getLength());
            this.continuationBreaks[i3] = n2;
            n2 += record2.getLength();
        }
        this.totalStrings = IntegerHelper.getInt(byArray[0], byArray[1], byArray[2], byArray[3]);
        this.uniqueStrings = IntegerHelper.getInt(byArray[4], byArray[5], byArray[6], byArray[7]);
        this.strings = new String[this.uniqueStrings];
        this.readStrings(byArray, 8, workbookSettings);
    }

    private void readStrings(byte[] byArray, int n, WorkbookSettings workbookSettings) {
        int n2 = n;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < this.uniqueStrings; ++i2) {
            int n5 = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1]);
            byte by = byArray[n2 += 2];
            ++n2;
            bl3 = (by & 4) != 0;
            boolean bl4 = bl2 = (by & 8) != 0;
            if (bl2) {
                n3 = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1]);
                n2 += 2;
            }
            if (bl3) {
                n4 = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]);
                n2 += 4;
            }
            bl = (by & 1) == 0;
            SSTRecord$ByteArrayHolder sSTRecord$ByteArrayHolder = new SSTRecord$ByteArrayHolder(null);
            SSTRecord$BooleanHolder sSTRecord$BooleanHolder = new SSTRecord$BooleanHolder(null);
            sSTRecord$BooleanHolder.value = bl;
            n2 += this.getChars(byArray, sSTRecord$ByteArrayHolder, n2, sSTRecord$BooleanHolder, n5);
            bl = sSTRecord$BooleanHolder.value;
            string = bl ? StringHelper.getString(sSTRecord$ByteArrayHolder.bytes, n5, 0, workbookSettings) : StringHelper.getUnicodeString(sSTRecord$ByteArrayHolder.bytes, n5, 0);
            this.strings[i2] = string;
            if (bl2) {
                n2 += 4 * n3;
            }
            if (bl3) {
                n2 += n4;
            }
            if (n2 <= byArray.length) continue;
            Assert.verify(false, "pos exceeds record length");
        }
    }

    private int getChars(byte[] byArray, SSTRecord$ByteArrayHolder sSTRecord$ByteArrayHolder, int n, SSTRecord$BooleanHolder sSTRecord$BooleanHolder, int n2) {
        int n3 = 0;
        boolean bl = false;
        sSTRecord$ByteArrayHolder.bytes = sSTRecord$BooleanHolder.value ? new byte[n2] : new byte[n2 * 2];
        while (n3 < this.continuationBreaks.length && !bl) {
            bl = n <= this.continuationBreaks[n3] && n + sSTRecord$ByteArrayHolder.bytes.length > this.continuationBreaks[n3];
            if (bl) continue;
            ++n3;
        }
        if (!bl) {
            System.arraycopy(byArray, n, sSTRecord$ByteArrayHolder.bytes, 0, sSTRecord$ByteArrayHolder.bytes.length);
            return sSTRecord$ByteArrayHolder.bytes.length;
        }
        int n4 = this.continuationBreaks[n3];
        System.arraycopy(byArray, n, sSTRecord$ByteArrayHolder.bytes, 0, n4 - n);
        int n5 = n4 - n;
        int n6 = sSTRecord$BooleanHolder.value ? n5 : n5 / 2;
        n5 += this.getContinuedString(byArray, sSTRecord$ByteArrayHolder, n5, n3, sSTRecord$BooleanHolder, n2 - n6);
        return n5;
    }

    private int getContinuedString(byte[] byArray, SSTRecord$ByteArrayHolder sSTRecord$ByteArrayHolder, int n, int n2, SSTRecord$BooleanHolder sSTRecord$BooleanHolder, int n3) {
        int n4 = this.continuationBreaks[n2];
        int n5 = 0;
        while (n3 > 0) {
            int n6;
            Assert.verify(n2 < this.continuationBreaks.length, "continuation break index");
            if (sSTRecord$BooleanHolder.value && byArray[n4] == 0) {
                int n7 = n2 == this.continuationBreaks.length - 1 ? n3 : Math.min(n3, this.continuationBreaks[n2 + 1] - n4 - 1);
                System.arraycopy(byArray, n4 + 1, sSTRecord$ByteArrayHolder.bytes, n, n7);
                n += n7;
                n5 += n7 + 1;
                n3 -= n7;
                sSTRecord$BooleanHolder.value = true;
            } else if (!sSTRecord$BooleanHolder.value && byArray[n4] != 0) {
                int n8 = n2 == this.continuationBreaks.length - 1 ? n3 * 2 : Math.min(n3 * 2, this.continuationBreaks[n2 + 1] - n4 - 1);
                System.arraycopy(byArray, n4 + 1, sSTRecord$ByteArrayHolder.bytes, n, n8);
                n += n8;
                n5 += n8 + 1;
                n3 -= n8 / 2;
                sSTRecord$BooleanHolder.value = false;
            } else if (!sSTRecord$BooleanHolder.value && byArray[n4] == 0) {
                int n9 = n2 == this.continuationBreaks.length - 1 ? n3 : Math.min(n3, this.continuationBreaks[n2 + 1] - n4 - 1);
                for (n6 = 0; n6 < n9; ++n6) {
                    sSTRecord$ByteArrayHolder.bytes[n] = byArray[n4 + n6 + 1];
                    n += 2;
                }
                n5 += n9 + 1;
                n3 -= n9;
                sSTRecord$BooleanHolder.value = false;
            } else {
                byte[] byArray2 = sSTRecord$ByteArrayHolder.bytes;
                sSTRecord$ByteArrayHolder.bytes = new byte[n * 2 + n3 * 2];
                for (n6 = 0; n6 < n; ++n6) {
                    sSTRecord$ByteArrayHolder.bytes[n6 * 2] = byArray2[n6];
                }
                n6 = n2 == this.continuationBreaks.length - 1 ? n3 * 2 : Math.min(n3 * 2, this.continuationBreaks[n2 + 1] - n4 - 1);
                System.arraycopy(byArray, n4 + 1, sSTRecord$ByteArrayHolder.bytes, n *= 2, n6);
                n += n6;
                n5 += n6 + 1;
                n3 -= n6 / 2;
                sSTRecord$BooleanHolder.value = false;
            }
            if (++n2 >= this.continuationBreaks.length) continue;
            n4 = this.continuationBreaks[n2];
        }
        return n5;
    }

    public final String getString(int n) {
        Assert.verify(n < this.uniqueStrings);
        return this.strings[n];
    }
}

