/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import common.Logger;
import jxl.CellType;
import jxl.LabelCell;
import jxl.StringFormulaCell;
import jxl.WorkbookSettings;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.File;
import jxl.read.biff.Record;
import jxl.read.biff.SheetImpl;

public class SharedStringFormulaRecord
extends BaseSharedFormulaRecord
implements LabelCell,
FormulaData,
StringFormulaCell {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$SharedStringFormulaRecord == null ? (class$jxl$read$biff$SharedStringFormulaRecord = SharedStringFormulaRecord.class$("jxl.read.biff.SharedStringFormulaRecord")) : class$jxl$read$biff$SharedStringFormulaRecord);
    private String value;
    static Class class$jxl$read$biff$SharedStringFormulaRecord;

    public SharedStringFormulaRecord(Record record, File file, FormattingRecords formattingRecords, ExternalSheet externalSheet, WorkbookMethods workbookMethods, SheetImpl sheetImpl, WorkbookSettings workbookSettings) {
        super(record, formattingRecords, externalSheet, workbookMethods, sheetImpl, file.getPos());
        int n;
        int n2 = file.getPos();
        int n3 = file.getPos();
        Record record2 = file.next();
        for (n = 0; record2.getType() != Type.STRING && n < 4; ++n) {
            record2 = file.next();
        }
        Assert.verify(n < 4, " @ " + n2);
        byte[] byArray = record2.getData();
        int n4 = IntegerHelper.getInt(byArray[0], byArray[1]);
        boolean bl = false;
        int n5 = 3;
        if (byArray.length == n4 + 2) {
            n5 = 2;
            bl = false;
        } else if (byArray[2] == 1) {
            n5 = 3;
            bl = true;
        } else {
            n5 = 3;
            bl = false;
        }
        this.value = !bl ? StringHelper.getString(byArray, n4, n5, workbookSettings) : StringHelper.getUnicodeString(byArray, n4, n5);
        file.setPos(n3);
    }

    public final String getString() {
        return this.value;
    }

    public final String getContents() {
        return this.value;
    }

    public final CellType getType() {
        return CellType.STRING_FORMULA;
    }

    public final byte[] getFormulaData() {
        if (!this.getSheet().getWorkbookBof().isBiff8()) {
            throw new FormulaException(FormulaException.biff8Supported);
        }
        FormulaParser formulaParser = new FormulaParser(this.getTokens(), this, this.getExternalSheet(), this.getNameTable(), this.getSheet().getWorkbook().getSettings());
        formulaParser.parse();
        byte[] byArray = formulaParser.getBytes();
        byte[] byArray2 = new byte[byArray.length + 22];
        IntegerHelper.getTwoBytes(this.getRow(), byArray2, 0);
        IntegerHelper.getTwoBytes(this.getColumn(), byArray2, 2);
        IntegerHelper.getTwoBytes(this.getXFIndex(), byArray2, 4);
        byArray2[6] = 0;
        byArray2[12] = -1;
        byArray2[13] = -1;
        System.arraycopy(byArray, 0, byArray2, 22, byArray.length);
        IntegerHelper.getTwoBytes(byArray.length, byArray2, 20);
        byte[] byArray3 = new byte[byArray2.length - 6];
        System.arraycopy(byArray2, 6, byArray3, 0, byArray2.length - 6);
        return byArray3;
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

