/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.CellReferenceHelper;
import jxl.CellType;
import jxl.HeaderFooter;
import jxl.NumberCell;
import jxl.Range;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.ContinueRecord;
import jxl.biff.FormattingRecords;
import jxl.biff.Type;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.WritableRecordData;
import jxl.biff.drawing.Button;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Comment;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingData;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.NoteRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.biff.drawing.TextObjectRecord;
import jxl.biff.formula.FormulaException;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.read.biff.BOFRecord;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.BlankCell;
import jxl.read.biff.BooleanRecord;
import jxl.read.biff.BottomMarginRecord;
import jxl.read.biff.ButtonPropertySetRecord;
import jxl.read.biff.CellFeaturesAccessor;
import jxl.read.biff.CellValue;
import jxl.read.biff.CentreRecord;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.DataValidation;
import jxl.read.biff.DateFormulaRecord;
import jxl.read.biff.DateRecord;
import jxl.read.biff.DefaultColumnWidthRecord;
import jxl.read.biff.DefaultRowHeightRecord;
import jxl.read.biff.DimensionRecord;
import jxl.read.biff.ErrorRecord;
import jxl.read.biff.File;
import jxl.read.biff.FooterRecord;
import jxl.read.biff.FormulaRecord;
import jxl.read.biff.HeaderRecord;
import jxl.read.biff.HorizontalPageBreaksRecord;
import jxl.read.biff.HyperlinkRecord;
import jxl.read.biff.LabelRecord;
import jxl.read.biff.LabelSSTRecord;
import jxl.read.biff.LeftMarginRecord;
import jxl.read.biff.MarginRecord;
import jxl.read.biff.MergedCellsRecord;
import jxl.read.biff.MulBlankCell;
import jxl.read.biff.MulBlankRecord;
import jxl.read.biff.MulRKRecord;
import jxl.read.biff.NumberFormulaRecord;
import jxl.read.biff.NumberRecord;
import jxl.read.biff.NumberValue;
import jxl.read.biff.PLSRecord;
import jxl.read.biff.PaneRecord;
import jxl.read.biff.PasswordRecord;
import jxl.read.biff.PrintGridLinesRecord;
import jxl.read.biff.PrintHeadersRecord;
import jxl.read.biff.ProtectRecord;
import jxl.read.biff.RKHelper;
import jxl.read.biff.RKRecord;
import jxl.read.biff.RStringRecord;
import jxl.read.biff.Record;
import jxl.read.biff.RightMarginRecord;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SCLRecord;
import jxl.read.biff.SSTRecord;
import jxl.read.biff.SetupRecord;
import jxl.read.biff.SharedFormulaRecord;
import jxl.read.biff.SheetImpl;
import jxl.read.biff.TopMarginRecord;
import jxl.read.biff.Window2Record;
import jxl.read.biff.WorkbookParser;

final class SheetReader {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$SheetReader == null ? (class$jxl$read$biff$SheetReader = SheetReader.class$("jxl.read.biff.SheetReader")) : class$jxl$read$biff$SheetReader);
    private File excelFile;
    private SSTRecord sharedStrings;
    private BOFRecord sheetBof;
    private BOFRecord workbookBof;
    private FormattingRecords formattingRecords;
    private int numRows;
    private int numCols;
    private Cell[][] cells;
    private int startPosition;
    private ArrayList rowProperties;
    private ArrayList columnInfosArray;
    private ArrayList sharedFormulas;
    private ArrayList hyperlinks;
    private Range[] mergedCells;
    private DataValidation dataValidation;
    private ArrayList charts;
    private ArrayList drawings;
    private DrawingData drawingData;
    private boolean nineteenFour;
    private PLSRecord plsRecord;
    private ButtonPropertySetRecord buttonPropertySet;
    private WorkspaceInformationRecord workspaceOptions;
    private int[] rowBreaks;
    private SheetSettings settings;
    private WorkbookSettings workbookSettings;
    private WorkbookParser workbook;
    private SheetImpl sheet;
    static Class class$jxl$read$biff$SheetReader;

    SheetReader(File file, SSTRecord sSTRecord, FormattingRecords formattingRecords, BOFRecord bOFRecord, BOFRecord bOFRecord2, boolean bl, WorkbookParser workbookParser, int n, SheetImpl sheetImpl) {
        this.excelFile = file;
        this.sharedStrings = sSTRecord;
        this.formattingRecords = formattingRecords;
        this.sheetBof = bOFRecord;
        this.workbookBof = bOFRecord2;
        this.columnInfosArray = new ArrayList();
        this.sharedFormulas = new ArrayList();
        this.hyperlinks = new ArrayList();
        this.rowProperties = new ArrayList(10);
        this.charts = new ArrayList();
        this.drawings = new ArrayList();
        this.nineteenFour = bl;
        this.workbook = workbookParser;
        this.startPosition = n;
        this.sheet = sheetImpl;
        this.settings = new SheetSettings();
        this.workbookSettings = this.workbook.getSettings();
    }

    private void addCell(Cell cell) {
        if (cell.getRow() < this.numRows && cell.getColumn() < this.numCols) {
            if (this.cells[cell.getRow()][cell.getColumn()] != null) {
                StringBuffer stringBuffer = new StringBuffer();
                CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow(), stringBuffer);
                logger.warn("Cell " + stringBuffer.toString() + " already contains data");
            }
            this.cells[cell.getRow()][cell.getColumn()] = cell;
        } else {
            logger.warn("Cell " + CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow()) + " exceeds defined cell boundaries in Dimension record " + "(" + this.numCols + "x" + this.numRows + ")");
        }
    }

    final void read() {
        int n;
        Object object;
        Record record = null;
        CellValue cellValue = null;
        boolean bl = false;
        boolean bl2 = true;
        this.excelFile.setPos(this.startPosition);
        MsoDrawingRecord msoDrawingRecord = null;
        ObjRecord objRecord = null;
        boolean bl3 = true;
        Window2Record window2Record = null;
        PrintGridLinesRecord printGridLinesRecord = null;
        PrintHeadersRecord printHeadersRecord = null;
        HashMap hashMap = new HashMap();
        while (bl2) {
            Cell cell;
            record = this.excelFile.next();
            if (record.getType() == Type.UNKNOWN && record.getCode() == 0) {
                logger.warn("Biff code zero found");
                if (record.getLength() == 10) {
                    logger.warn("Biff code zero found - trying a dimension record.");
                    record.setType(Type.DIMENSION);
                } else {
                    logger.warn("Biff code zero found - Ignoring.");
                }
            }
            if (record.getType() == Type.DIMENSION) {
                object = null;
                object = this.workbookBof.isBiff8() ? new DimensionRecord(record) : new DimensionRecord(record, DimensionRecord.biff7);
                this.numRows = ((DimensionRecord)object).getNumberOfRows();
                this.numCols = ((DimensionRecord)object).getNumberOfColumns();
                this.cells = new Cell[this.numRows][this.numCols];
                continue;
            }
            if (record.getType() == Type.LABELSST) {
                object = new LabelSSTRecord(record, this.sharedStrings, this.formattingRecords, this.sheet);
                this.addCell((Cell)object);
                continue;
            }
            if (record.getType() == Type.RK || record.getType() == Type.RK2) {
                object = new RKRecord(record, this.formattingRecords, this.sheet);
                if (this.formattingRecords.isDate(((CellValue)object).getXFIndex())) {
                    DateRecord dateRecord = new DateRecord((NumberCell)object, ((CellValue)object).getXFIndex(), this.formattingRecords, this.nineteenFour, this.sheet);
                    this.addCell(dateRecord);
                    continue;
                }
                this.addCell((Cell)object);
                continue;
            }
            if (record.getType() == Type.HLINK) {
                object = new HyperlinkRecord(record, this.sheet, this.workbookSettings);
                this.hyperlinks.add(object);
                continue;
            }
            if (record.getType() == Type.MERGEDCELLS) {
                object = new MergedCellsRecord(record, this.sheet);
                if (this.mergedCells == null) {
                    this.mergedCells = ((MergedCellsRecord)object).getRanges();
                    continue;
                }
                Range[] rangeArray = new Range[this.mergedCells.length + ((MergedCellsRecord)object).getRanges().length];
                System.arraycopy(this.mergedCells, 0, rangeArray, 0, this.mergedCells.length);
                System.arraycopy(((MergedCellsRecord)object).getRanges(), 0, rangeArray, this.mergedCells.length, ((MergedCellsRecord)object).getRanges().length);
                this.mergedCells = rangeArray;
                continue;
            }
            if (record.getType() == Type.MULRK) {
                object = new MulRKRecord(record);
                int n2 = ((MulRKRecord)object).getNumberOfColumns();
                int n3 = 0;
                for (n = 0; n < n2; ++n) {
                    n3 = ((MulRKRecord)object).getXFIndex(n);
                    cell = new NumberValue(((MulRKRecord)object).getRow(), ((MulRKRecord)object).getFirstColumn() + n, RKHelper.getDouble(((MulRKRecord)object).getRKNumber(n)), n3, this.formattingRecords, this.sheet);
                    if (this.formattingRecords.isDate(n3)) {
                        DateRecord dateRecord = new DateRecord((NumberCell)cell, n3, this.formattingRecords, this.nineteenFour, this.sheet);
                        this.addCell(dateRecord);
                        continue;
                    }
                    cell.setNumberFormat(this.formattingRecords.getNumberFormat(n3));
                    this.addCell(cell);
                }
                continue;
            }
            if (record.getType() == Type.NUMBER) {
                object = new NumberRecord(record, this.formattingRecords, this.sheet);
                if (this.formattingRecords.isDate(((CellValue)object).getXFIndex())) {
                    DateRecord dateRecord = new DateRecord((NumberCell)object, ((CellValue)object).getXFIndex(), this.formattingRecords, this.nineteenFour, this.sheet);
                    this.addCell(dateRecord);
                    continue;
                }
                this.addCell((Cell)object);
                continue;
            }
            if (record.getType() == Type.BOOLERR) {
                object = new BooleanRecord(record, this.formattingRecords, this.sheet);
                if (((BooleanRecord)object).isError()) {
                    ErrorRecord errorRecord = new ErrorRecord(((BooleanRecord)object).getRecord(), this.formattingRecords, this.sheet);
                    this.addCell(errorRecord);
                    continue;
                }
                this.addCell((Cell)object);
                continue;
            }
            if (record.getType() == Type.PRINTGRIDLINES) {
                printGridLinesRecord = new PrintGridLinesRecord(record);
                this.settings.setPrintGridLines(printGridLinesRecord.getPrintGridLines());
                continue;
            }
            if (record.getType() == Type.PRINTHEADERS) {
                printHeadersRecord = new PrintHeadersRecord(record);
                this.settings.setPrintHeaders(printHeadersRecord.getPrintHeaders());
                continue;
            }
            if (record.getType() == Type.WINDOW2) {
                window2Record = new Window2Record(record);
                this.settings.setShowGridLines(window2Record.getShowGridLines());
                this.settings.setDisplayZeroValues(window2Record.getDisplayZeroValues());
                this.settings.setSelected(true);
                continue;
            }
            if (record.getType() == Type.PANE) {
                object = new PaneRecord(record);
                if (window2Record == null || !window2Record.getFrozen()) continue;
                this.settings.setVerticalFreeze(((PaneRecord)object).getRowsVisible());
                this.settings.setHorizontalFreeze(((PaneRecord)object).getColumnsVisible());
                continue;
            }
            if (record.getType() == Type.CONTINUE) continue;
            if (record.getType() == Type.NOTE) {
                if (this.workbookSettings.getDrawingsDisabled()) continue;
                object = new NoteRecord(record);
                Comment comment = (Comment)hashMap.remove(new Integer(((NoteRecord)object).getObjectId()));
                if (comment == null) {
                    logger.warn(" cannot find comment for note id " + ((NoteRecord)object).getObjectId() + "...ignoring");
                    continue;
                }
                comment.setNote((NoteRecord)object);
                this.drawings.add(comment);
                this.addCellComment(comment.getColumn(), comment.getRow(), comment.getText(), comment.getWidth(), comment.getHeight());
                continue;
            }
            if (record.getType() == Type.ARRAY) continue;
            if (record.getType() == Type.PROTECT) {
                object = new ProtectRecord(record);
                this.settings.setProtected(((ProtectRecord)object).isProtected());
                continue;
            }
            if (record.getType() == Type.SHAREDFORMULA) {
                if (cellValue == null) {
                    logger.warn("Shared template formula is null - trying most recent formula template");
                    object = (SharedFormulaRecord)this.sharedFormulas.get(this.sharedFormulas.size() - 1);
                    if (object != null) {
                        cellValue = ((SharedFormulaRecord)object).getTemplateFormula();
                    }
                }
                object = new SharedFormulaRecord(record, (BaseSharedFormulaRecord)cellValue, this.workbook, this.workbook, this.sheet);
                this.sharedFormulas.add(object);
                cellValue = null;
                continue;
            }
            if (record.getType() == Type.FORMULA || record.getType() == Type.FORMULA2) {
                CellFeaturesAccessor cellFeaturesAccessor;
                object = new FormulaRecord(record, this.excelFile, this.formattingRecords, this.workbook, this.workbook, this.sheet, this.workbookSettings);
                if (((FormulaRecord)object).isShared()) {
                    cellFeaturesAccessor = cellValue;
                    cellValue = (BaseSharedFormulaRecord)((FormulaRecord)object).getFormula();
                    bl = this.addToSharedFormulas((BaseSharedFormulaRecord)cellValue);
                    if (bl) {
                        cellValue = cellFeaturesAccessor;
                    }
                    if (bl || cellFeaturesAccessor == null) continue;
                    this.addCell(this.revertSharedFormula((BaseSharedFormulaRecord)cellFeaturesAccessor));
                    continue;
                }
                cellFeaturesAccessor = ((FormulaRecord)object).getFormula();
                try {
                    NumberFormulaRecord numberFormulaRecord;
                    if (((FormulaRecord)object).getFormula().getType() == CellType.NUMBER_FORMULA && this.formattingRecords.isDate((numberFormulaRecord = (NumberFormulaRecord)((FormulaRecord)object).getFormula()).getXFIndex())) {
                        cellFeaturesAccessor = new DateFormulaRecord(numberFormulaRecord, this.formattingRecords, this.workbook, this.workbook, this.nineteenFour, this.sheet);
                    }
                    this.addCell((Cell)((Object)cellFeaturesAccessor));
                }
                catch (FormulaException formulaException) {
                    logger.warn(CellReferenceHelper.getCellReference(cellFeaturesAccessor.getColumn(), cellFeaturesAccessor.getRow()) + " " + formulaException.getMessage());
                }
                continue;
            }
            if (record.getType() == Type.LABEL) {
                object = null;
                object = this.workbookBof.isBiff8() ? new LabelRecord(record, this.formattingRecords, this.sheet, this.workbookSettings) : new LabelRecord(record, this.formattingRecords, this.sheet, this.workbookSettings, LabelRecord.biff7);
                this.addCell((Cell)object);
                continue;
            }
            if (record.getType() == Type.RSTRING) {
                object = null;
                Assert.verify(!this.workbookBof.isBiff8());
                object = new RStringRecord(record, this.formattingRecords, this.sheet, this.workbookSettings, RStringRecord.biff7);
                this.addCell((Cell)object);
                continue;
            }
            if (record.getType() == Type.NAME) continue;
            if (record.getType() == Type.PASSWORD) {
                object = new PasswordRecord(record);
                this.settings.setPasswordHash(((PasswordRecord)object).getPasswordHash());
                continue;
            }
            if (record.getType() == Type.ROW) {
                object = new RowRecord(record);
                if (((RowRecord)object).isDefaultHeight() && ((RowRecord)object).matchesDefaultFontHeight() && !((RowRecord)object).isCollapsed() && !((RowRecord)object).hasDefaultFormat()) continue;
                this.rowProperties.add(object);
                continue;
            }
            if (record.getType() == Type.BLANK) {
                if (this.workbookSettings.getIgnoreBlanks()) continue;
                object = new BlankCell(record, this.formattingRecords, this.sheet);
                this.addCell((Cell)object);
                continue;
            }
            if (record.getType() == Type.MULBLANK) {
                if (this.workbookSettings.getIgnoreBlanks()) continue;
                object = new MulBlankRecord(record);
                int n4 = ((MulBlankRecord)object).getNumberOfColumns();
                for (int i2 = 0; i2 < n4; ++i2) {
                    n = ((MulBlankRecord)object).getXFIndex(i2);
                    cell = new MulBlankCell(((MulBlankRecord)object).getRow(), ((MulBlankRecord)object).getFirstColumn() + i2, n, this.formattingRecords, this.sheet);
                    this.addCell(cell);
                }
                continue;
            }
            if (record.getType() == Type.SCL) {
                object = new SCLRecord(record);
                this.settings.setZoomFactor(((SCLRecord)object).getZoomFactor());
                continue;
            }
            if (record.getType() == Type.COLINFO) {
                object = new ColumnInfoRecord(record);
                this.columnInfosArray.add(object);
                continue;
            }
            if (record.getType() == Type.HEADER) {
                object = null;
                object = this.workbookBof.isBiff8() ? new HeaderRecord(record, this.workbookSettings) : new HeaderRecord(record, this.workbookSettings, HeaderRecord.biff7);
                HeaderFooter headerFooter = new HeaderFooter(((HeaderRecord)object).getHeader());
                this.settings.setHeader(headerFooter);
                continue;
            }
            if (record.getType() == Type.FOOTER) {
                object = null;
                object = this.workbookBof.isBiff8() ? new FooterRecord(record, this.workbookSettings) : new FooterRecord(record, this.workbookSettings, FooterRecord.biff7);
                HeaderFooter headerFooter = new HeaderFooter(((FooterRecord)object).getFooter());
                this.settings.setFooter(headerFooter);
                continue;
            }
            if (record.getType() == Type.SETUP) {
                object = new SetupRecord(record);
                if (((SetupRecord)object).isPortrait()) {
                    this.settings.setOrientation(PageOrientation.PORTRAIT);
                } else {
                    this.settings.setOrientation(PageOrientation.LANDSCAPE);
                }
                this.settings.setPaperSize(PaperSize.getPaperSize(((SetupRecord)object).getPaperSize()));
                this.settings.setHeaderMargin(((SetupRecord)object).getHeaderMargin());
                this.settings.setFooterMargin(((SetupRecord)object).getFooterMargin());
                this.settings.setScaleFactor(((SetupRecord)object).getScaleFactor());
                this.settings.setPageStart(((SetupRecord)object).getPageStart());
                this.settings.setFitWidth(((SetupRecord)object).getFitWidth());
                this.settings.setFitHeight(((SetupRecord)object).getFitHeight());
                this.settings.setHorizontalPrintResolution(((SetupRecord)object).getHorizontalPrintResolution());
                this.settings.setVerticalPrintResolution(((SetupRecord)object).getVerticalPrintResolution());
                this.settings.setCopies(((SetupRecord)object).getCopies());
                if (this.workspaceOptions == null) continue;
                this.settings.setFitToPages(this.workspaceOptions.getFitToPages());
                continue;
            }
            if (record.getType() == Type.WSBOOL) {
                this.workspaceOptions = new WorkspaceInformationRecord(record);
                continue;
            }
            if (record.getType() == Type.DEFCOLWIDTH) {
                object = new DefaultColumnWidthRecord(record);
                this.settings.setDefaultColumnWidth(((DefaultColumnWidthRecord)object).getWidth());
                continue;
            }
            if (record.getType() == Type.DEFAULTROWHEIGHT) {
                object = new DefaultRowHeightRecord(record);
                if (((DefaultRowHeightRecord)object).getHeight() == 0) continue;
                this.settings.setDefaultRowHeight(((DefaultRowHeightRecord)object).getHeight());
                continue;
            }
            if (record.getType() == Type.LEFTMARGIN) {
                object = new LeftMarginRecord(record);
                this.settings.setLeftMargin(((MarginRecord)object).getMargin());
                continue;
            }
            if (record.getType() == Type.RIGHTMARGIN) {
                object = new RightMarginRecord(record);
                this.settings.setRightMargin(((MarginRecord)object).getMargin());
                continue;
            }
            if (record.getType() == Type.TOPMARGIN) {
                object = new TopMarginRecord(record);
                this.settings.setTopMargin(((MarginRecord)object).getMargin());
                continue;
            }
            if (record.getType() == Type.BOTTOMMARGIN) {
                object = new BottomMarginRecord(record);
                this.settings.setBottomMargin(((MarginRecord)object).getMargin());
                continue;
            }
            if (record.getType() == Type.HORIZONTALPAGEBREAKS) {
                object = null;
                object = this.workbookBof.isBiff8() ? new HorizontalPageBreaksRecord(record) : new HorizontalPageBreaksRecord(record, HorizontalPageBreaksRecord.biff7);
                this.rowBreaks = ((HorizontalPageBreaksRecord)object).getRowBreaks();
                continue;
            }
            if (record.getType() == Type.PLS) {
                this.plsRecord = new PLSRecord(record);
                continue;
            }
            if (record.getType() == Type.DVAL) continue;
            if (record.getType() == Type.HCENTER) {
                object = new CentreRecord(record);
                this.settings.setHorizontalCentre(((CentreRecord)object).isCentre());
                continue;
            }
            if (record.getType() == Type.VCENTER) {
                object = new CentreRecord(record);
                this.settings.setVerticalCentre(((CentreRecord)object).isCentre());
                continue;
            }
            if (record.getType() == Type.DV) continue;
            if (record.getType() == Type.OBJ) {
                objRecord = new ObjRecord(record);
                if (!this.workbookSettings.getDrawingsDisabled()) {
                    this.handleObjectRecord(objRecord, msoDrawingRecord, hashMap);
                }
                if (objRecord.getType() == ObjRecord.CHART) continue;
                objRecord = null;
                msoDrawingRecord = null;
                continue;
            }
            if (record.getType() == Type.MSODRAWING) {
                if (this.workbookSettings.getDrawingsDisabled()) continue;
                if (msoDrawingRecord != null) {
                    this.drawingData.addRawData(msoDrawingRecord.getData());
                }
                msoDrawingRecord = new MsoDrawingRecord(record);
                if (!bl3) continue;
                msoDrawingRecord.setFirst();
                bl3 = false;
                continue;
            }
            if (record.getType() == Type.BUTTONPROPERTYSET) {
                this.buttonPropertySet = new ButtonPropertySetRecord(record);
                continue;
            }
            if (record.getType() == Type.BOF) {
                object = new BOFRecord(record);
                Assert.verify(!((BOFRecord)object).isWorksheet());
                int n5 = this.excelFile.getPos() - record.getLength() - 4;
                Record record2 = this.excelFile.next();
                while (record2.getCode() != Type.EOF.value) {
                    record2 = this.excelFile.next();
                }
                if (((BOFRecord)object).isChart()) {
                    if (!this.workbook.getWorkbookBof().isBiff8()) {
                        logger.warn("only biff8 charts are supported");
                    } else {
                        if (this.drawingData == null) {
                            this.drawingData = new DrawingData();
                        }
                        if (!this.workbookSettings.getDrawingsDisabled()) {
                            Chart chart = new Chart(msoDrawingRecord, objRecord, this.drawingData, n5, this.excelFile.getPos(), this.excelFile, this.workbookSettings);
                            this.charts.add(chart);
                            if (this.workbook.getDrawingGroup() != null) {
                                this.workbook.getDrawingGroup().add(chart);
                            }
                        }
                    }
                    msoDrawingRecord = null;
                    objRecord = null;
                }
                if (!this.sheetBof.isChart()) continue;
                bl2 = false;
                continue;
            }
            if (record.getType() != Type.EOF) continue;
            bl2 = false;
        }
        this.excelFile.restorePos();
        object = this.sharedFormulas.iterator();
        while (object.hasNext()) {
            SharedFormulaRecord sharedFormulaRecord = (SharedFormulaRecord)object.next();
            Cell[] cellArray = sharedFormulaRecord.getFormulas(this.formattingRecords, this.nineteenFour);
            for (n = 0; n < cellArray.length; ++n) {
                this.addCell(cellArray[n]);
            }
        }
        if (!bl && cellValue != null) {
            this.addCell(this.revertSharedFormula((BaseSharedFormulaRecord)cellValue));
        }
        if (msoDrawingRecord != null && this.workbook.getDrawingGroup() != null) {
            this.workbook.getDrawingGroup().setDrawingsOmitted(msoDrawingRecord, objRecord);
        }
        if (!hashMap.isEmpty()) {
            logger.warn("Not all comments have a corresponding Note record");
        }
    }

    private boolean addToSharedFormulas(BaseSharedFormulaRecord baseSharedFormulaRecord) {
        Iterator iterator = this.sharedFormulas.iterator();
        boolean bl = false;
        SharedFormulaRecord sharedFormulaRecord = null;
        while (iterator.hasNext() && !bl) {
            sharedFormulaRecord = (SharedFormulaRecord)iterator.next();
            bl = sharedFormulaRecord.add(baseSharedFormulaRecord);
        }
        return bl;
    }

    private Cell revertSharedFormula(BaseSharedFormulaRecord baseSharedFormulaRecord) {
        int n = this.excelFile.getPos();
        this.excelFile.setPos(baseSharedFormulaRecord.getFilePos());
        FormulaRecord formulaRecord = new FormulaRecord(baseSharedFormulaRecord.getRecord(), this.excelFile, this.formattingRecords, this.workbook, this.workbook, FormulaRecord.ignoreSharedFormula, this.sheet, this.workbookSettings);
        try {
            Cell cell = formulaRecord.getFormula();
            if (formulaRecord.getFormula().getType() == CellType.NUMBER_FORMULA) {
                NumberFormulaRecord numberFormulaRecord = (NumberFormulaRecord)formulaRecord.getFormula();
                if (this.formattingRecords.isDate(formulaRecord.getXFIndex())) {
                    cell = new DateFormulaRecord(numberFormulaRecord, this.formattingRecords, this.workbook, this.workbook, this.nineteenFour, this.sheet);
                }
            }
            this.excelFile.setPos(n);
            return cell;
        }
        catch (FormulaException formulaException) {
            logger.warn(CellReferenceHelper.getCellReference(formulaRecord.getColumn(), formulaRecord.getRow()) + " " + formulaException.getMessage());
            return null;
        }
    }

    final int getNumRows() {
        return this.numRows;
    }

    final int getNumCols() {
        return this.numCols;
    }

    final Cell[][] getCells() {
        return this.cells;
    }

    final ArrayList getRowProperties() {
        return this.rowProperties;
    }

    final ArrayList getColumnInfosArray() {
        return this.columnInfosArray;
    }

    final ArrayList getHyperlinks() {
        return this.hyperlinks;
    }

    final ArrayList getCharts() {
        return this.charts;
    }

    final ArrayList getDrawings() {
        return this.drawings;
    }

    final DataValidation getDataValidation() {
        return this.dataValidation;
    }

    final Range[] getMergedCells() {
        return this.mergedCells;
    }

    final SheetSettings getSettings() {
        return this.settings;
    }

    final int[] getRowBreaks() {
        return this.rowBreaks;
    }

    final WorkspaceInformationRecord getWorkspaceOptions() {
        return this.workspaceOptions;
    }

    final PLSRecord getPLS() {
        return this.plsRecord;
    }

    final ButtonPropertySetRecord getButtonPropertySet() {
        return this.buttonPropertySet;
    }

    private void addCellComment(int n, int n2, String string, double d2, double d3) {
        Cell cell = this.cells[n2][n];
        if (cell == null) {
            logger.warn("Cell at " + CellReferenceHelper.getCellReference(n, n2) + " not present - adding a blank");
            MulBlankCell mulBlankCell = new MulBlankCell(n2, n, 0, this.formattingRecords, this.sheet);
            CellFeatures cellFeatures = new CellFeatures();
            cellFeatures.setReadComment(string, d2, d3);
            mulBlankCell.setCellFeatures(cellFeatures);
            this.addCell(mulBlankCell);
            return;
        }
        if (cell instanceof CellFeaturesAccessor) {
            CellFeaturesAccessor cellFeaturesAccessor = (CellFeaturesAccessor)((Object)cell);
            CellFeatures cellFeatures = cellFeaturesAccessor.getCellFeatures();
            if (cellFeatures == null) {
                cellFeatures = new CellFeatures();
                cellFeaturesAccessor.setCellFeatures(cellFeatures);
            }
            cellFeatures.setReadComment(string, d2, d3);
        } else {
            logger.warn("Not able to add comment to cell type " + cell.getClass().getName() + " at " + CellReferenceHelper.getCellReference(n, n2));
        }
    }

    private void handleObjectRecord(ObjRecord objRecord, MsoDrawingRecord msoDrawingRecord, HashMap hashMap) {
        if (msoDrawingRecord == null) {
            logger.warn("Object record is not associated with a drawing  record - ignoring");
            return;
        }
        if (objRecord.getType() == ObjRecord.PICTURE) {
            if (this.drawingData == null) {
                this.drawingData = new DrawingData();
            }
            Drawing drawing = new Drawing(msoDrawingRecord, objRecord, this.drawingData, this.workbook.getDrawingGroup());
            this.drawings.add(drawing);
            return;
        }
        if (objRecord.getType() == ObjRecord.EXCELNOTE) {
            WritableRecordData writableRecordData;
            if (this.drawingData == null) {
                this.drawingData = new DrawingData();
            }
            Comment comment = new Comment(msoDrawingRecord, objRecord, this.drawingData, this.workbook.getDrawingGroup(), this.workbookSettings);
            Record record = this.excelFile.next();
            if (record.getType() == Type.MSODRAWING) {
                writableRecordData = new MsoDrawingRecord(record);
                comment.addMso((MsoDrawingRecord)writableRecordData);
                record = this.excelFile.next();
            }
            Assert.verify(record.getType() == Type.TXO);
            writableRecordData = new TextObjectRecord(record);
            comment.setTextObject((TextObjectRecord)writableRecordData);
            record = this.excelFile.next();
            Assert.verify(record.getType() == Type.CONTINUE);
            ContinueRecord continueRecord = new ContinueRecord(record);
            comment.setText(continueRecord);
            record = this.excelFile.next();
            if (record.getType() == Type.CONTINUE) {
                ContinueRecord continueRecord2 = new ContinueRecord(record);
                comment.setFormatting(continueRecord2);
            }
            hashMap.put(new Integer(comment.getObjectId()), comment);
            return;
        }
        if (objRecord.getType() == ObjRecord.BUTTON) {
            WritableRecordData writableRecordData;
            if (this.drawingData == null) {
                this.drawingData = new DrawingData();
            }
            Button button = new Button(msoDrawingRecord, objRecord, this.drawingData, this.workbook.getDrawingGroup(), this.workbookSettings);
            Record record = this.excelFile.next();
            if (record.getType() == Type.MSODRAWING) {
                writableRecordData = new MsoDrawingRecord(record);
                button.addMso((MsoDrawingRecord)writableRecordData);
                record = this.excelFile.next();
            }
            Assert.verify(record.getType() == Type.TXO);
            writableRecordData = new TextObjectRecord(record);
            button.setTextObject((TextObjectRecord)writableRecordData);
            record = this.excelFile.next();
            Assert.verify(record.getType() == Type.CONTINUE);
            ContinueRecord continueRecord = new ContinueRecord(record);
            button.setText(continueRecord);
            record = this.excelFile.next();
            if (record.getType() == Type.CONTINUE) {
                ContinueRecord continueRecord3 = new ContinueRecord(record);
                button.setFormatting(continueRecord3);
            }
            this.drawings.add(button);
            return;
        }
        if (objRecord.getType() != ObjRecord.CHART) {
            logger.warn(objRecord.getType() + " on sheet \"" + this.sheet.getName() + "\" not supported - omitting");
            if (this.drawingData == null) {
                this.drawingData = new DrawingData();
            }
            this.drawingData.addData(msoDrawingRecord.getData());
            if (this.workbook.getDrawingGroup() != null) {
                this.workbook.getDrawingGroup().setDrawingsOmitted(msoDrawingRecord, objRecord);
            }
            return;
        }
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

