/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.StringHelper;
import jxl.read.biff.Record;
import jxl.read.biff.SupbookRecord$Type;

public class SupbookRecord
extends RecordData {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$SupbookRecord == null ? (class$jxl$read$biff$SupbookRecord = SupbookRecord.class$("jxl.read.biff.SupbookRecord")) : class$jxl$read$biff$SupbookRecord);
    private SupbookRecord$Type type;
    private int numSheets;
    private String fileName;
    private String[] sheetNames;
    public static final SupbookRecord$Type INTERNAL = new SupbookRecord$Type(null);
    public static final SupbookRecord$Type EXTERNAL = new SupbookRecord$Type(null);
    public static final SupbookRecord$Type ADDIN = new SupbookRecord$Type(null);
    public static final SupbookRecord$Type LINK = new SupbookRecord$Type(null);
    public static final SupbookRecord$Type UNKNOWN = new SupbookRecord$Type(null);
    static Class class$jxl$read$biff$SupbookRecord;

    SupbookRecord(Record record, WorkbookSettings workbookSettings) {
        super(record);
        byte[] byArray = this.getRecord().getData();
        this.type = byArray.length == 4 ? (byArray[2] == 1 && byArray[3] == 4 ? INTERNAL : (byArray[2] == 1 && byArray[3] == 58 ? ADDIN : UNKNOWN)) : (byArray[0] == 0 && byArray[1] == 0 ? LINK : EXTERNAL);
        if (this.type == INTERNAL) {
            this.numSheets = IntegerHelper.getInt(byArray[0], byArray[1]);
        }
        if (this.type == EXTERNAL) {
            this.readExternal(byArray, workbookSettings);
        }
    }

    private void readExternal(byte[] byArray, WorkbookSettings workbookSettings) {
        int n;
        this.numSheets = IntegerHelper.getInt(byArray[0], byArray[1]);
        int n2 = IntegerHelper.getInt(byArray[2], byArray[3]) - 1;
        int n3 = 0;
        if (byArray[4] == 0) {
            n = byArray[5];
            n3 = 6;
            if (n == 0) {
                this.fileName = StringHelper.getString(byArray, n2, n3, workbookSettings);
                n3 += n2;
            } else {
                this.fileName = this.getEncodedFilename(byArray, n2, n3);
                n3 += n2;
            }
        } else {
            n = IntegerHelper.getInt(byArray[5], byArray[6]);
            n3 = 7;
            if (n == 0) {
                this.fileName = StringHelper.getUnicodeString(byArray, n2, n3);
                n3 += n2 * 2;
            } else {
                this.fileName = this.getUnicodeEncodedFilename(byArray, n2, n3);
                n3 += n2 * 2;
            }
        }
        this.sheetNames = new String[this.numSheets];
        for (n = 0; n < this.sheetNames.length; ++n) {
            n2 = IntegerHelper.getInt(byArray[n3], byArray[n3 + 1]);
            if (byArray[n3 + 2] == 0) {
                this.sheetNames[n] = StringHelper.getString(byArray, n2, n3 + 3, workbookSettings);
                n3 += n2 + 3;
                continue;
            }
            if (byArray[n3 + 2] != 1) continue;
            this.sheetNames[n] = StringHelper.getUnicodeString(byArray, n2, n3 + 3);
            n3 += n2 * 2 + 3;
        }
    }

    public final SupbookRecord$Type getType() {
        return this.type;
    }

    public final int getNumberOfSheets() {
        return this.numSheets;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getSheetName(int n) {
        return this.sheetNames[n];
    }

    public final byte[] getData() {
        return this.getRecord().getData();
    }

    private String getEncodedFilename(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 + n;
        while (n2 < n3) {
            char c2 = (char)byArray[n2];
            if (c2 == '\u0001') {
                c2 = (char)byArray[++n2];
                stringBuffer.append(c2);
                stringBuffer.append(":\\\\");
            } else if (c2 == '\u0002') {
                stringBuffer.append('\\');
            } else if (c2 == '\u0003') {
                stringBuffer.append('\\');
            } else if (c2 == '\u0004') {
                stringBuffer.append("..\\");
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String getUnicodeEncodedFilename(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 + n * 2;
        while (n2 < n3) {
            char c2 = (char)IntegerHelper.getInt(byArray[n2], byArray[n2 + 1]);
            if (c2 == '\u0001') {
                c2 = (char)IntegerHelper.getInt(byArray[n2 += 2], byArray[n2 + 1]);
                stringBuffer.append(c2);
                stringBuffer.append(":\\\\");
            } else if (c2 == '\u0002') {
                stringBuffer.append('\\');
            } else if (c2 == '\u0003') {
                stringBuffer.append('\\');
            } else if (c2 == '\u0004') {
                stringBuffer.append("..\\");
            } else {
                stringBuffer.append(c2);
            }
            n2 += 2;
        }
        return stringBuffer.toString();
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

