/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.biff.Fonts;
import jxl.biff.FormatRecord;
import jxl.biff.FormattingRecords;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.PaletteRecord;
import jxl.biff.RangeImpl;
import jxl.biff.Type;
import jxl.biff.WorkbookMethods;
import jxl.biff.XFRecord;
import jxl.biff.drawing.DrawingGroup;
import jxl.biff.drawing.MsoDrawingGroupRecord;
import jxl.biff.drawing.Origin;
import jxl.biff.formula.ExternalSheet;
import jxl.read.biff.BOFRecord;
import jxl.read.biff.BiffException;
import jxl.read.biff.BoundsheetRecord;
import jxl.read.biff.ButtonPropertySetRecord;
import jxl.read.biff.CodepageRecord;
import jxl.read.biff.CompoundFile;
import jxl.read.biff.CountryRecord;
import jxl.read.biff.ExternalSheetRecord;
import jxl.read.biff.File;
import jxl.read.biff.NameRecord;
import jxl.read.biff.NameRecord$NameRange;
import jxl.read.biff.NineteenFourRecord;
import jxl.read.biff.PasswordException;
import jxl.read.biff.ProtectRecord;
import jxl.read.biff.Record;
import jxl.read.biff.SSTRecord;
import jxl.read.biff.SheetImpl;
import jxl.read.biff.SupbookRecord;

public class WorkbookParser
extends Workbook
implements ExternalSheet,
WorkbookMethods {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$WorkbookParser == null ? (class$jxl$read$biff$WorkbookParser = WorkbookParser.class$("jxl.read.biff.WorkbookParser")) : class$jxl$read$biff$WorkbookParser);
    private File excelFile;
    private int bofs;
    private boolean nineteenFour;
    private SSTRecord sharedStrings;
    private ArrayList boundsheets;
    private FormattingRecords formattingRecords;
    private Fonts fonts;
    private ArrayList sheets;
    private SheetImpl lastSheet;
    private int lastSheetIndex;
    private HashMap namedRecords;
    private ArrayList nameTable;
    private ExternalSheetRecord externSheet;
    private ArrayList supbooks;
    private BOFRecord workbookBof;
    private MsoDrawingGroupRecord msoDrawingGroup;
    private ButtonPropertySetRecord buttonPropertySet;
    private boolean wbProtected;
    private boolean containsMacros;
    private WorkbookSettings settings;
    private DrawingGroup drawingGroup;
    private CountryRecord countryRecord;
    static Class class$jxl$read$biff$WorkbookParser;

    public WorkbookParser(File file, WorkbookSettings workbookSettings) {
        this.excelFile = file;
        this.boundsheets = new ArrayList(10);
        this.fonts = new Fonts();
        this.formattingRecords = new FormattingRecords(this.fonts);
        this.sheets = new ArrayList(10);
        this.supbooks = new ArrayList(10);
        this.namedRecords = new HashMap();
        this.lastSheetIndex = -1;
        this.wbProtected = false;
        this.containsMacros = false;
        this.settings = workbookSettings;
    }

    public final Sheet[] getSheets() {
        Sheet[] sheetArray = new Sheet[this.getNumberOfSheets()];
        return this.sheets.toArray(sheetArray);
    }

    public final Sheet getReadSheet(int n) {
        return this.getSheet(n);
    }

    public final Sheet getSheet(int n) {
        if (this.lastSheet != null && this.lastSheetIndex == n) {
            return this.lastSheet;
        }
        if (this.lastSheet != null) {
            this.lastSheet.clear();
            if (!this.settings.getGCDisabled()) {
                System.gc();
            }
        }
        this.lastSheet = (SheetImpl)this.sheets.get(n);
        this.lastSheetIndex = n;
        this.lastSheet.readSheet();
        return this.lastSheet;
    }

    public final Sheet getSheet(String string) {
        int n = 0;
        boolean bl = false;
        Iterator iterator = this.boundsheets.iterator();
        BoundsheetRecord boundsheetRecord = null;
        while (iterator.hasNext() && !bl) {
            boundsheetRecord = (BoundsheetRecord)iterator.next();
            if (boundsheetRecord.getName().equals(string)) {
                bl = true;
                continue;
            }
            ++n;
        }
        return bl ? this.getSheet(n) : null;
    }

    public final String[] getSheetNames() {
        String[] stringArray = new String[this.boundsheets.size()];
        BoundsheetRecord boundsheetRecord = null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            boundsheetRecord = (BoundsheetRecord)this.boundsheets.get(i2);
            stringArray[i2] = boundsheetRecord.getName();
        }
        return stringArray;
    }

    public final int getExternalSheetIndex(int n) {
        if (this.workbookBof.isBiff7()) {
            return n;
        }
        Assert.verify(this.externSheet != null);
        int n2 = this.externSheet.getFirstTabIndex(n);
        return n2;
    }

    public final int getLastExternalSheetIndex(int n) {
        if (this.workbookBof.isBiff7()) {
            return n;
        }
        Assert.verify(this.externSheet != null);
        int n2 = this.externSheet.getLastTabIndex(n);
        return n2;
    }

    public final String getExternalSheetName(int n) {
        if (this.workbookBof.isBiff7()) {
            BoundsheetRecord boundsheetRecord = (BoundsheetRecord)this.boundsheets.get(n);
            return boundsheetRecord.getName();
        }
        int n2 = this.externSheet.getSupbookIndex(n);
        SupbookRecord supbookRecord = (SupbookRecord)this.supbooks.get(n2);
        int n3 = this.externSheet.getFirstTabIndex(n);
        if (supbookRecord.getType() == SupbookRecord.INTERNAL) {
            BoundsheetRecord boundsheetRecord = (BoundsheetRecord)this.boundsheets.get(n3);
            return boundsheetRecord.getName();
        }
        if (supbookRecord.getType() == SupbookRecord.EXTERNAL) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(supbookRecord.getFileName());
            stringBuffer.append(']');
            stringBuffer.append(supbookRecord.getSheetName(n3));
            return stringBuffer.toString();
        }
        return "[UNKNOWN]";
    }

    public final String getLastExternalSheetName(int n) {
        if (this.workbookBof.isBiff7()) {
            BoundsheetRecord boundsheetRecord = (BoundsheetRecord)this.boundsheets.get(n);
            return boundsheetRecord.getName();
        }
        int n2 = this.externSheet.getSupbookIndex(n);
        SupbookRecord supbookRecord = (SupbookRecord)this.supbooks.get(n2);
        int n3 = this.externSheet.getLastTabIndex(n);
        if (supbookRecord.getType() == SupbookRecord.INTERNAL) {
            BoundsheetRecord boundsheetRecord = (BoundsheetRecord)this.boundsheets.get(n3);
            return boundsheetRecord.getName();
        }
        if (supbookRecord.getType() == SupbookRecord.EXTERNAL) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(supbookRecord.getFileName());
            stringBuffer.append(']');
            stringBuffer.append(supbookRecord.getSheetName(n3));
            return stringBuffer.toString();
        }
        return "[UNKNOWN]";
    }

    public final int getNumberOfSheets() {
        return this.sheets.size();
    }

    public final void close() {
        if (this.lastSheet != null) {
            this.lastSheet.clear();
        }
        this.excelFile.clear();
        if (!this.settings.getGCDisabled()) {
            System.gc();
        }
    }

    final void addSheet(Sheet sheet) {
        this.sheets.add(sheet);
    }

    protected final void parse() {
        Object object;
        Object object2;
        BOFRecord bOFRecord;
        Record record = null;
        this.workbookBof = bOFRecord = new BOFRecord(this.excelFile.next());
        ++this.bofs;
        if (!bOFRecord.isBiff8() && !bOFRecord.isBiff7()) {
            throw new BiffException(BiffException.unrecognizedBiffVersion);
        }
        if (!bOFRecord.isWorkbookGlobals()) {
            throw new BiffException(BiffException.expectedGlobals);
        }
        ArrayList<Record> arrayList = new ArrayList<Record>();
        this.nameTable = new ArrayList();
        while (this.bofs == 1) {
            record = this.excelFile.next();
            if (record.getType() == Type.SST) {
                arrayList.clear();
                object2 = this.excelFile.peek();
                while (((Record)object2).getType() == Type.CONTINUE) {
                    arrayList.add(this.excelFile.next());
                    object2 = this.excelFile.peek();
                }
                object = new Record[arrayList.size()];
                object = arrayList.toArray((T[])object);
                this.sharedStrings = new SSTRecord(record, (Record[])object, this.settings);
                continue;
            }
            if (record.getType() == Type.FILEPASS) {
                throw new PasswordException();
            }
            if (record.getType() == Type.NAME) {
                object2 = null;
                object2 = bOFRecord.isBiff8() ? new NameRecord(record, this.settings, this.namedRecords.size()) : new NameRecord(record, this.settings, this.namedRecords.size(), NameRecord.biff7);
                this.namedRecords.put(((NameRecord)object2).getName(), object2);
                this.nameTable.add(object2);
                continue;
            }
            if (record.getType() == Type.FONT) {
                object2 = null;
                object2 = bOFRecord.isBiff8() ? new FontRecord(record, this.settings) : new FontRecord(record, this.settings, FontRecord.biff7);
                this.fonts.addFont((FontRecord)object2);
                continue;
            }
            if (record.getType() == Type.PALETTE) {
                object2 = new PaletteRecord(record);
                this.formattingRecords.setPalette((PaletteRecord)object2);
                continue;
            }
            if (record.getType() == Type.NINETEENFOUR) {
                object2 = new NineteenFourRecord(record);
                this.nineteenFour = ((NineteenFourRecord)object2).is1904();
                continue;
            }
            if (record.getType() == Type.FORMAT) {
                object2 = null;
                object2 = bOFRecord.isBiff8() ? new FormatRecord(record, this.settings, FormatRecord.biff8) : new FormatRecord(record, this.settings, FormatRecord.biff7);
                try {
                    this.formattingRecords.addFormat((DisplayFormat)object2);
                }
                catch (NumFormatRecordsException numFormatRecordsException) {
                    numFormatRecordsException.printStackTrace();
                    Assert.verify(false, numFormatRecordsException.getMessage());
                }
                continue;
            }
            if (record.getType() == Type.XF) {
                object2 = null;
                object2 = bOFRecord.isBiff8() ? new XFRecord(record, this.settings, XFRecord.biff8) : new XFRecord(record, this.settings, XFRecord.biff7);
                try {
                    this.formattingRecords.addStyle((XFRecord)object2);
                }
                catch (NumFormatRecordsException numFormatRecordsException) {
                    Assert.verify(false, numFormatRecordsException.getMessage());
                }
                continue;
            }
            if (record.getType() == Type.BOUNDSHEET) {
                object2 = null;
                object2 = bOFRecord.isBiff8() ? new BoundsheetRecord(record) : new BoundsheetRecord(record, BoundsheetRecord.biff7);
                if (((BoundsheetRecord)object2).isSheet()) {
                    this.boundsheets.add(object2);
                    continue;
                }
                if (!((BoundsheetRecord)object2).isChart() || this.settings.getDrawingsDisabled()) continue;
                this.boundsheets.add(object2);
                continue;
            }
            if (record.getType() == Type.EXTERNSHEET) {
                if (bOFRecord.isBiff8()) {
                    this.externSheet = new ExternalSheetRecord(record, this.settings);
                    continue;
                }
                this.externSheet = new ExternalSheetRecord(record, this.settings, ExternalSheetRecord.biff7);
                continue;
            }
            if (record.getType() == Type.CODEPAGE) {
                object2 = new CodepageRecord(record);
                this.settings.setCharacterSet(((CodepageRecord)object2).getCharacterSet());
                continue;
            }
            if (record.getType() == Type.SUPBOOK) {
                object2 = this.excelFile.peek();
                while (((Record)object2).getType() == Type.CONTINUE) {
                    record.addContinueRecord(this.excelFile.next());
                    object2 = this.excelFile.peek();
                }
                object = new SupbookRecord(record, this.settings);
                this.supbooks.add(object);
                continue;
            }
            if (record.getType() == Type.PROTECT) {
                object2 = new ProtectRecord(record);
                this.wbProtected = ((ProtectRecord)object2).isProtected();
                continue;
            }
            if (record.getType() == Type.OBJPROJ) {
                this.containsMacros = true;
                continue;
            }
            if (record.getType() == Type.COUNTRY) {
                this.countryRecord = new CountryRecord(record);
                continue;
            }
            if (record.getType() == Type.MSODRAWINGGROUP) {
                if (this.settings.getDrawingsDisabled()) continue;
                this.msoDrawingGroup = new MsoDrawingGroupRecord(record);
                if (this.drawingGroup == null) {
                    this.drawingGroup = new DrawingGroup(Origin.READ);
                }
                this.drawingGroup.add(this.msoDrawingGroup);
                object2 = this.excelFile.peek();
                while (((Record)object2).getType() == Type.CONTINUE) {
                    this.drawingGroup.add(this.excelFile.next());
                    object2 = this.excelFile.peek();
                }
                continue;
            }
            if (record.getType() == Type.BUTTONPROPERTYSET) {
                this.buttonPropertySet = new ButtonPropertySetRecord(record);
                continue;
            }
            if (record.getType() != Type.EOF) continue;
            --this.bofs;
        }
        bOFRecord = null;
        if (this.excelFile.hasNext() && (record = this.excelFile.next()).getType() == Type.BOF) {
            bOFRecord = new BOFRecord(record);
        }
        while (bOFRecord != null && this.getNumberOfSheets() < this.boundsheets.size()) {
            if (!bOFRecord.isBiff8() && !bOFRecord.isBiff7()) {
                throw new BiffException(BiffException.unrecognizedBiffVersion);
            }
            if (bOFRecord.isWorksheet()) {
                object2 = new SheetImpl(this.excelFile, this.sharedStrings, this.formattingRecords, bOFRecord, this.workbookBof, this.nineteenFour, this);
                object = (BoundsheetRecord)this.boundsheets.get(this.getNumberOfSheets());
                ((SheetImpl)object2).setName(((BoundsheetRecord)object).getName());
                ((SheetImpl)object2).setHidden(((BoundsheetRecord)object).isHidden());
                this.addSheet((Sheet)object2);
            } else if (bOFRecord.isChart()) {
                object2 = new SheetImpl(this.excelFile, this.sharedStrings, this.formattingRecords, bOFRecord, this.workbookBof, this.nineteenFour, this);
                object = (BoundsheetRecord)this.boundsheets.get(this.getNumberOfSheets());
                ((SheetImpl)object2).setName(((BoundsheetRecord)object).getName());
                ((SheetImpl)object2).setHidden(((BoundsheetRecord)object).isHidden());
                this.addSheet((Sheet)object2);
            } else {
                logger.warn("BOF is unrecognized");
                while (this.excelFile.hasNext() && record.getType() != Type.EOF) {
                    record = this.excelFile.next();
                }
            }
            bOFRecord = null;
            if (!this.excelFile.hasNext() || (record = this.excelFile.next()).getType() != Type.BOF) continue;
            bOFRecord = new BOFRecord(record);
        }
    }

    public final FormattingRecords getFormattingRecords() {
        return this.formattingRecords;
    }

    public final ExternalSheetRecord getExternalSheetRecord() {
        return this.externSheet;
    }

    public final MsoDrawingGroupRecord getMsoDrawingGroupRecord() {
        return this.msoDrawingGroup;
    }

    public final SupbookRecord[] getSupbookRecords() {
        SupbookRecord[] supbookRecordArray = new SupbookRecord[this.supbooks.size()];
        return this.supbooks.toArray(supbookRecordArray);
    }

    public final NameRecord[] getNameRecords() {
        NameRecord[] nameRecordArray = new NameRecord[this.nameTable.size()];
        return this.nameTable.toArray(nameRecordArray);
    }

    public final Fonts getFonts() {
        return this.fonts;
    }

    public final Cell findCellByName(String string) {
        NameRecord nameRecord = (NameRecord)this.namedRecords.get(string);
        if (nameRecord == null) {
            return null;
        }
        NameRecord$NameRange[] nameRecord$NameRangeArray = nameRecord.getRanges();
        Sheet sheet = this.getSheet(nameRecord$NameRangeArray[0].getExternalSheet());
        Cell cell = sheet.getCell(nameRecord$NameRangeArray[0].getFirstColumn(), nameRecord$NameRangeArray[0].getFirstRow());
        return cell;
    }

    public final Range[] findByName(String string) {
        NameRecord nameRecord = (NameRecord)this.namedRecords.get(string);
        if (nameRecord == null) {
            return null;
        }
        NameRecord$NameRange[] nameRecord$NameRangeArray = nameRecord.getRanges();
        Range[] rangeArray = new Range[nameRecord$NameRangeArray.length];
        for (int i2 = 0; i2 < nameRecord$NameRangeArray.length; ++i2) {
            rangeArray[i2] = new RangeImpl(this, this.getExternalSheetIndex(nameRecord$NameRangeArray[i2].getExternalSheet()), nameRecord$NameRangeArray[i2].getFirstColumn(), nameRecord$NameRangeArray[i2].getFirstRow(), this.getLastExternalSheetIndex(nameRecord$NameRangeArray[i2].getExternalSheet()), nameRecord$NameRangeArray[i2].getLastColumn(), nameRecord$NameRangeArray[i2].getLastRow());
        }
        return rangeArray;
    }

    public final String[] getRangeNames() {
        Object[] objectArray = this.namedRecords.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        return stringArray;
    }

    public final BOFRecord getWorkbookBof() {
        return this.workbookBof;
    }

    public final boolean isProtected() {
        return this.wbProtected;
    }

    public final WorkbookSettings getSettings() {
        return this.settings;
    }

    public final int getExternalSheetIndex(String string) {
        return 0;
    }

    public final int getLastExternalSheetIndex(String string) {
        return 0;
    }

    public final String getName(int n) {
        Assert.verify(n >= 0 && n < this.nameTable.size());
        return ((NameRecord)this.nameTable.get(n)).getName();
    }

    public final int getNameIndex(String string) {
        NameRecord nameRecord = (NameRecord)this.namedRecords.get(string);
        return nameRecord != null ? nameRecord.getIndex() : 0;
    }

    public final DrawingGroup getDrawingGroup() {
        return this.drawingGroup;
    }

    public final CompoundFile getCompoundFile() {
        return this.excelFile.getCompoundFile();
    }

    public final boolean containsMacros() {
        return this.containsMacros;
    }

    public final ButtonPropertySetRecord getButtonPropertySet() {
        return this.buttonPropertySet;
    }

    public final CountryRecord getCountryRecord() {
        return this.countryRecord;
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

