/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class ExtendedSSTRecord
extends WritableRecordData {
    private static final int infoRecordSize = 8;
    private int numberOfStrings;
    private int[] absoluteStreamPositions;
    private int[] relativeStreamPositions;
    private int currentStringIndex = 0;

    public ExtendedSSTRecord(int n) {
        super(Type.EXTSST);
        this.numberOfStrings = n;
        int n2 = this.getNumberOfBuckets();
        this.absoluteStreamPositions = new int[n2];
        this.relativeStreamPositions = new int[n2];
        this.currentStringIndex = 0;
    }

    public final int getNumberOfBuckets() {
        int n = this.getNumberOfStringsPerBucket();
        return n != 0 ? (this.numberOfStrings + n - 1) / n : 0;
    }

    public final int getNumberOfStringsPerBucket() {
        int n = 128;
        return (this.numberOfStrings + 128 - 1) / 128;
    }

    public final void addString(int n, int n2) {
        this.absoluteStreamPositions[this.currentStringIndex] = n + n2;
        this.relativeStreamPositions[this.currentStringIndex] = n2;
        ++this.currentStringIndex;
    }

    public final byte[] getData() {
        int n = this.getNumberOfBuckets();
        byte[] byArray = new byte[2 + 8 * n];
        IntegerHelper.getTwoBytes(this.getNumberOfStringsPerBucket(), byArray, 0);
        for (int i2 = 0; i2 < n; ++i2) {
            IntegerHelper.getFourBytes(this.absoluteStreamPositions[i2], byArray, 2 + i2 * 8);
            IntegerHelper.getTwoBytes(this.relativeStreamPositions[i2], byArray, 6 + i2 * 8);
        }
        return byArray;
    }
}

