/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import jxl.CellReferenceHelper;
import jxl.CellType;
import jxl.FormulaCell;
import jxl.Sheet;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.write.WritableCell;
import jxl.write.biff.CellValue;
import jxl.write.biff.FormulaRecord;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.WritableSheetImpl;
import jxl.write.biff.WritableWorkbookImpl;

class ReadFormulaRecord
extends CellValue
implements FormulaData {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$ReadFormulaRecord == null ? (class$jxl$write$biff$ReadFormulaRecord = ReadFormulaRecord.class$("jxl.write.biff.ReadFormulaRecord")) : class$jxl$write$biff$ReadFormulaRecord);
    private FormulaData formula;
    private FormulaParser parser;
    static Class class$jxl$write$biff$ReadFormulaRecord;

    protected ReadFormulaRecord(FormulaData formulaData) {
        super(Type.FORMULA, formulaData);
        this.formula = formulaData;
    }

    public final byte[] getData() {
        byte[] byArray;
        byte[] byArray2 = super.getData();
        byte[] byArray3 = null;
        try {
            if (this.parser == null) {
                byArray3 = this.formula.getFormulaData();
            } else {
                byArray = this.parser.getBytes();
                byArray3 = new byte[byArray.length + 16];
                IntegerHelper.getTwoBytes(byArray.length, byArray3, 14);
                System.arraycopy(byArray, 0, byArray3, 16, byArray.length);
            }
        }
        catch (FormulaException formulaException) {
            logger.warn(CellReferenceHelper.getCellReference(this.getColumn(), this.getRow()) + " " + formulaException.getMessage());
            WritableWorkbookImpl writableWorkbookImpl = this.getSheet().getWorkbook();
            this.parser = this.formula.getType() == CellType.STRING_FORMULA ? new FormulaParser("\"" + this.getContents() + "\"", writableWorkbookImpl, writableWorkbookImpl, writableWorkbookImpl.getSettings()) : new FormulaParser(this.getContents(), writableWorkbookImpl, writableWorkbookImpl, writableWorkbookImpl.getSettings());
            try {
                this.parser.parse();
            }
            catch (FormulaException formulaException2) {
                logger.warn(formulaException2.getMessage());
                this.parser = new FormulaParser("\"ERROR\"", writableWorkbookImpl, writableWorkbookImpl, writableWorkbookImpl.getSettings());
                try {
                    this.parser.parse();
                }
                catch (FormulaException formulaException3) {
                    Assert.verify(false);
                }
            }
            byte[] byArray4 = this.parser.getBytes();
            byArray3 = new byte[byArray4.length + 16];
            IntegerHelper.getTwoBytes(byArray4.length, byArray3, 14);
            System.arraycopy(byArray4, 0, byArray3, 16, byArray4.length);
        }
        byArray3[8] = (byte)(byArray3[8] | 2);
        byArray = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
        return byArray;
    }

    public CellType getType() {
        return this.formula.getType();
    }

    public String getContents() {
        return this.formula.getContents();
    }

    public byte[] getFormulaData() {
        byte[] byArray = this.formula.getFormulaData();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[8] = (byte)(byArray2[8] | 2);
        return byArray2;
    }

    public WritableCell copyTo(int n, int n2) {
        return new FormulaRecord(n, n2, this);
    }

    final void setCellDetails(FormattingRecords formattingRecords, SharedStrings sharedStrings, WritableSheetImpl writableSheetImpl) {
        super.setCellDetails(formattingRecords, sharedStrings, writableSheetImpl);
        writableSheetImpl.getWorkbook().addRCIRCell(this);
    }

    final void columnInserted(Sheet sheet, int n, int n2) {
        try {
            if (this.parser == null) {
                byte[] byArray = this.formula.getFormulaData();
                byte[] byArray2 = new byte[byArray.length - 16];
                System.arraycopy(byArray, 16, byArray2, 0, byArray2.length);
                this.parser = new FormulaParser(byArray2, this, this.getSheet().getWorkbook(), this.getSheet().getWorkbook(), this.getSheet().getWorkbookSettings());
                this.parser.parse();
            }
            this.parser.columnInserted(n, n2, sheet == this.getSheet());
        }
        catch (FormulaException formulaException) {
            logger.warn("cannot insert column within formula:  " + formulaException.getMessage());
        }
    }

    final void columnRemoved(Sheet sheet, int n, int n2) {
        try {
            if (this.parser == null) {
                byte[] byArray = this.formula.getFormulaData();
                byte[] byArray2 = new byte[byArray.length - 16];
                System.arraycopy(byArray, 16, byArray2, 0, byArray2.length);
                this.parser = new FormulaParser(byArray2, this, this.getSheet().getWorkbook(), this.getSheet().getWorkbook(), this.getSheet().getWorkbookSettings());
                this.parser.parse();
            }
            this.parser.columnRemoved(n, n2, sheet == this.getSheet());
        }
        catch (FormulaException formulaException) {
            logger.warn("cannot remove column within formula:  " + formulaException.getMessage());
        }
    }

    final void rowInserted(Sheet sheet, int n, int n2) {
        try {
            if (this.parser == null) {
                byte[] byArray = this.formula.getFormulaData();
                byte[] byArray2 = new byte[byArray.length - 16];
                System.arraycopy(byArray, 16, byArray2, 0, byArray2.length);
                this.parser = new FormulaParser(byArray2, this, this.getSheet().getWorkbook(), this.getSheet().getWorkbook(), this.getSheet().getWorkbookSettings());
                this.parser.parse();
            }
            this.parser.rowInserted(n, n2, sheet == this.getSheet());
        }
        catch (FormulaException formulaException) {
            logger.warn("cannot insert row within formula:  " + formulaException.getMessage());
        }
    }

    final void rowRemoved(Sheet sheet, int n, int n2) {
        try {
            if (this.parser == null) {
                byte[] byArray = this.formula.getFormulaData();
                byte[] byArray2 = new byte[byArray.length - 16];
                System.arraycopy(byArray, 16, byArray2, 0, byArray2.length);
                this.parser = new FormulaParser(byArray2, this, this.getSheet().getWorkbook(), this.getSheet().getWorkbook(), this.getSheet().getWorkbookSettings());
                this.parser.parse();
            }
            this.parser.rowRemoved(n, n2, sheet == this.getSheet());
        }
        catch (FormulaException formulaException) {
            logger.warn("cannot remove row within formula:  " + formulaException.getMessage());
        }
    }

    protected final FormulaData getReadFormula() {
        return this.formula;
    }

    public String getFormula() {
        return ((FormulaCell)((Object)this.formula)).getFormula();
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

