/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.CellType;
import jxl.biff.CellReferenceHelper;
import jxl.biff.IndexMapping;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;
import jxl.write.Number;
import jxl.write.biff.CellValue;
import jxl.write.biff.File;
import jxl.write.biff.MulRKRecord;
import jxl.write.biff.StringRecord;

class RowRecord
extends WritableRecordData {
    private static final Logger logger = Logger.getLogger(class$jxl$write$biff$RowRecord == null ? (class$jxl$write$biff$RowRecord = RowRecord.class$("jxl.write.biff.RowRecord")) : class$jxl$write$biff$RowRecord);
    private byte[] data;
    private CellValue[] cells;
    private int rowHeight;
    private boolean collapsed;
    private int rowNumber;
    private int numColumns;
    private int xfIndex;
    private XFRecord style;
    private boolean defaultFormat;
    private boolean matchesDefFontHeight;
    private static final int growSize = 10;
    private static final int maxRKValue = 0x1FFFFFFF;
    private static final int minRKValue = -536870912;
    private static int defaultHeightIndicator = 255;
    private static int maxColumns = 256;
    static Class class$jxl$write$biff$RowRecord;

    public RowRecord(int n) {
        super(Type.ROW);
        this.rowNumber = n;
        this.cells = new CellValue[0];
        this.numColumns = 0;
        this.rowHeight = defaultHeightIndicator;
        this.collapsed = false;
        this.matchesDefFontHeight = true;
    }

    public final void setRowHeight(int n) {
        if (n == 0) {
            this.setCollapsed(true);
            this.matchesDefFontHeight = false;
        } else {
            this.rowHeight = n;
            this.matchesDefFontHeight = false;
        }
    }

    final void setRowDetails(int n, boolean bl, boolean bl2, XFRecord xFRecord) {
        this.rowHeight = n;
        this.collapsed = bl2;
        this.matchesDefFontHeight = bl;
        if (xFRecord != null) {
            this.defaultFormat = true;
            this.style = xFRecord;
            this.xfIndex = this.style.getXFIndex();
        }
    }

    public final void setCollapsed(boolean bl) {
        this.collapsed = bl;
    }

    public final int getRowNumber() {
        return this.rowNumber;
    }

    public final void addCell(CellValue cellValue) {
        int n = cellValue.getColumn();
        if (n >= maxColumns) {
            logger.warn("Could not add cell at " + CellReferenceHelper.getCellReference(cellValue.getRow(), cellValue.getColumn()) + " because it exceeds the maximum column limit");
            return;
        }
        if (n >= this.cells.length) {
            CellValue[] cellValueArray = this.cells;
            this.cells = new CellValue[Math.max(cellValueArray.length + 10, n + 1)];
            System.arraycopy(cellValueArray, 0, this.cells, 0, cellValueArray.length);
            cellValueArray = null;
        }
        this.cells[n] = cellValue;
        this.numColumns = Math.max(n + 1, this.numColumns);
    }

    public final void removeCell(int n) {
        if (n >= this.numColumns) {
            return;
        }
        this.cells[n] = null;
    }

    public final void write(File file) {
        file.write(this);
    }

    public final void writeCells(File file) {
        ArrayList<CellValue> arrayList = new ArrayList<CellValue>();
        boolean bl = false;
        for (int i2 = 0; i2 < this.numColumns; ++i2) {
            bl = false;
            if (this.cells[i2] != null) {
                WritableRecordData writableRecordData;
                if (this.cells[i2].getType() == CellType.NUMBER && (writableRecordData = (Number)this.cells[i2]).getValue() == (double)((int)writableRecordData.getValue()) && writableRecordData.getValue() < 5.36870911E8 && writableRecordData.getValue() > -5.36870912E8 && writableRecordData.getCellFeatures() == null) {
                    bl = true;
                }
                if (bl) {
                    arrayList.add(this.cells[i2]);
                    continue;
                }
                this.writeIntegerValues(arrayList, file);
                file.write(this.cells[i2]);
                if (this.cells[i2].getType() != CellType.STRING_FORMULA) continue;
                writableRecordData = new StringRecord(this.cells[i2].getContents());
                file.write(writableRecordData);
                continue;
            }
            this.writeIntegerValues(arrayList, file);
        }
        this.writeIntegerValues(arrayList, file);
    }

    private void writeIntegerValues(ArrayList arrayList, File file) {
        if (arrayList.size() == 0) {
            return;
        }
        if (arrayList.size() >= 3) {
            MulRKRecord mulRKRecord = new MulRKRecord(arrayList);
            file.write(mulRKRecord);
        } else {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                file.write((CellValue)iterator.next());
            }
        }
        arrayList.clear();
    }

    public final byte[] getData() {
        byte[] byArray = new byte[16];
        IntegerHelper.getTwoBytes(this.rowNumber, byArray, 0);
        IntegerHelper.getTwoBytes(this.numColumns, byArray, 4);
        IntegerHelper.getTwoBytes(this.rowHeight, byArray, 6);
        int n = 256;
        if (this.collapsed) {
            n |= 0x20;
        }
        if (!this.matchesDefFontHeight) {
            n |= 0x40;
        }
        if (this.defaultFormat) {
            n |= 0x80;
            n |= this.xfIndex << 16;
        }
        IntegerHelper.getFourBytes(n, byArray, 12);
        return byArray;
    }

    public final int getMaxColumn() {
        return this.numColumns;
    }

    public final CellValue getCell(int n) {
        return n >= 0 && n < this.numColumns ? this.cells[n] : null;
    }

    final void incrementRow() {
        ++this.rowNumber;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (this.cells[i2] == null) continue;
            this.cells[i2].incrementRow();
        }
    }

    final void decrementRow() {
        --this.rowNumber;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (this.cells[i2] == null) continue;
            this.cells[i2].decrementRow();
        }
    }

    final void insertColumn(int n) {
        if (n >= this.numColumns) {
            return;
        }
        if (this.numColumns >= maxColumns) {
            logger.warn("Could not insert column because maximum column limit has been reached");
            return;
        }
        CellValue[] cellValueArray = this.cells;
        this.cells = this.numColumns >= this.cells.length - 1 ? new CellValue[cellValueArray.length + 10] : new CellValue[cellValueArray.length];
        System.arraycopy(cellValueArray, 0, this.cells, 0, n);
        System.arraycopy(cellValueArray, n, this.cells, n + 1, this.numColumns - n);
        for (int i2 = n + 1; i2 <= this.numColumns; ++i2) {
            if (this.cells[i2] == null) continue;
            this.cells[i2].incrementColumn();
        }
        ++this.numColumns;
    }

    final void removeColumn(int n) {
        if (n >= this.numColumns) {
            return;
        }
        CellValue[] cellValueArray = this.cells;
        this.cells = new CellValue[cellValueArray.length];
        System.arraycopy(cellValueArray, 0, this.cells, 0, n);
        System.arraycopy(cellValueArray, n + 1, this.cells, n, this.numColumns - (n + 1));
        for (int i2 = n; i2 < this.numColumns; ++i2) {
            if (this.cells[i2] == null) continue;
            this.cells[i2].decrementColumn();
        }
        --this.numColumns;
    }

    public final boolean isDefaultHeight() {
        return this.rowHeight == defaultHeightIndicator;
    }

    public final int getRowHeight() {
        return this.rowHeight;
    }

    public final boolean isCollapsed() {
        return this.collapsed;
    }

    final void rationalize(IndexMapping indexMapping) {
        if (this.defaultFormat) {
            this.xfIndex = indexMapping.getNewIndex(this.xfIndex);
        }
    }

    final XFRecord getStyle() {
        return this.style;
    }

    private final boolean hasDefaultFormat() {
        return this.defaultFormat;
    }

    final boolean matchesDefaultFontHeight() {
        return this.matchesDefFontHeight;
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

