/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.CellView;
import jxl.DateCell;
import jxl.HeaderFooter;
import jxl.Hyperlink;
import jxl.Image;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Range;
import jxl.Sheet;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IndexMapping;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.SheetRangeImpl;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Button;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Comment;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.format.CellFormat;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.read.biff.SheetImpl;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.DataValidation;
import jxl.write.biff.File;
import jxl.write.biff.FooterRecord;
import jxl.write.biff.HeaderRecord;
import jxl.write.biff.HyperlinkRecord;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.MergedCells;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.ReadBooleanFormulaRecord;
import jxl.write.biff.ReadDateFormulaRecord;
import jxl.write.biff.ReadErrorFormulaRecord;
import jxl.write.biff.ReadNumberFormulaRecord;
import jxl.write.biff.ReadStringFormulaRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.SheetWriter;
import jxl.write.biff.Styles;
import jxl.write.biff.WritableSheetImpl$ColumnInfoComparator;
import jxl.write.biff.WritableWorkbookImpl;

class WritableSheetImpl
implements WritableSheet {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$WritableSheetImpl == null ? (class$jxl$write$biff$WritableSheetImpl = WritableSheetImpl.class$("jxl.write.biff.WritableSheetImpl")) : class$jxl$write$biff$WritableSheetImpl);
    private String name;
    private File outputFile;
    private RowRecord[] rows;
    private FormattingRecords formatRecords;
    private SharedStrings sharedStrings;
    private TreeSet columnFormats;
    private ArrayList hyperlinks;
    private MergedCells mergedCells;
    private int numRows;
    private int numColumns;
    private PLSRecord plsRecord;
    private ButtonPropertySetRecord buttonPropertySet;
    private boolean chartOnly;
    private DataValidation dataValidation;
    private ArrayList rowBreaks;
    private ArrayList drawings;
    private ArrayList images;
    private boolean drawingsModified;
    private SheetSettings settings;
    private SheetWriter sheetWriter;
    private WorkbookSettings workbookSettings;
    private WritableWorkbookImpl workbook;
    private static final int rowGrowSize = 10;
    private static final int numRowsPerSheet = 65536;
    private static final int maxSheetNameLength = 31;
    private static final char[] illegalSheetNameCharacters = new char[]{'*', ':', '?', '\\'};
    private static final String[] imageTypes = new String[]{"png"};
    static Class class$jxl$write$biff$WritableSheetImpl;

    public WritableSheetImpl(String string, File file, FormattingRecords formattingRecords, SharedStrings sharedStrings, WorkbookSettings workbookSettings, WritableWorkbookImpl writableWorkbookImpl) {
        this.name = this.validateName(string);
        this.outputFile = file;
        this.rows = new RowRecord[0];
        this.numRows = 0;
        this.numColumns = 0;
        this.chartOnly = false;
        this.workbook = writableWorkbookImpl;
        this.formatRecords = formattingRecords;
        this.sharedStrings = sharedStrings;
        this.workbookSettings = workbookSettings;
        this.drawingsModified = false;
        this.columnFormats = new TreeSet(new WritableSheetImpl$ColumnInfoComparator(null));
        this.hyperlinks = new ArrayList();
        this.mergedCells = new MergedCells(this);
        this.rowBreaks = new ArrayList();
        this.drawings = new ArrayList();
        this.images = new ArrayList();
        this.settings = new SheetSettings();
        this.sheetWriter = new SheetWriter(this.outputFile, this, this.workbookSettings);
    }

    public final Cell getCell(int n, int n2) {
        return this.getWritableCell(n, n2);
    }

    public final WritableCell getWritableCell(int n, int n2) {
        WritableCell writableCell = null;
        if (n2 < this.rows.length && this.rows[n2] != null) {
            writableCell = this.rows[n2].getCell(n);
        }
        if (writableCell == null) {
            writableCell = new EmptyCell(n, n2);
        }
        return writableCell;
    }

    public final int getRows() {
        return this.numRows;
    }

    public final int getColumns() {
        return this.numColumns;
    }

    public final Cell findCell(String string) {
        Cell cell = null;
        boolean bl = false;
        for (int i2 = 0; i2 < this.getRows() && !bl; ++i2) {
            Cell[] cellArray = this.getRow(i2);
            for (int i3 = 0; i3 < cellArray.length && !bl; ++i3) {
                if (!cellArray[i3].getContents().equals(string)) continue;
                cell = cellArray[i3];
                bl = true;
            }
        }
        return cell;
    }

    public final LabelCell findLabelCell(String string) {
        LabelCell labelCell = null;
        boolean bl = false;
        for (int i2 = 0; i2 < this.getRows() && !bl; ++i2) {
            Cell[] cellArray = this.getRow(i2);
            for (int i3 = 0; i3 < cellArray.length && !bl; ++i3) {
                if (cellArray[i3].getType() != CellType.LABEL && cellArray[i3].getType() != CellType.STRING_FORMULA || !cellArray[i3].getContents().equals(string)) continue;
                labelCell = (LabelCell)cellArray[i3];
                bl = true;
            }
        }
        return labelCell;
    }

    public final Cell[] getRow(int n) {
        boolean bl = false;
        int n2 = this.numColumns - 1;
        while (n2 >= 0 && !bl) {
            if (this.getCell(n2, n).getType() != CellType.EMPTY) {
                bl = true;
                continue;
            }
            --n2;
        }
        Cell[] cellArray = new Cell[n2 + 1];
        for (int i2 = 0; i2 <= n2; ++i2) {
            cellArray[i2] = this.getCell(i2, n);
        }
        return cellArray;
    }

    public final Cell[] getColumn(int n) {
        boolean bl = false;
        int n2 = this.numRows - 1;
        while (n2 >= 0 && !bl) {
            if (this.getCell(n, n2).getType() != CellType.EMPTY) {
                bl = true;
                continue;
            }
            --n2;
        }
        Cell[] cellArray = new Cell[n2 + 1];
        for (int i2 = 0; i2 <= n2; ++i2) {
            cellArray[i2] = this.getCell(n, i2);
        }
        return cellArray;
    }

    public final String getName() {
        return this.name;
    }

    public final void insertRow(int n) {
        if (n < 0 || n >= this.numRows) {
            return;
        }
        RowRecord[] rowRecordArray = this.rows;
        this.rows = this.numRows == this.rows.length ? new RowRecord[rowRecordArray.length + 10] : new RowRecord[rowRecordArray.length];
        System.arraycopy(rowRecordArray, 0, this.rows, 0, n);
        System.arraycopy(rowRecordArray, n, this.rows, n + 1, this.numRows - n);
        for (int i2 = n + 1; i2 <= this.numRows; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].incrementRow();
        }
        HyperlinkRecord hyperlinkRecord = null;
        Iterator iterator = this.hyperlinks.iterator();
        while (iterator.hasNext()) {
            hyperlinkRecord = (HyperlinkRecord)iterator.next();
            hyperlinkRecord.insertRow(n);
        }
        if (this.dataValidation != null) {
            this.dataValidation.insertRow(n);
        }
        this.mergedCells.insertRow(n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator2 = this.rowBreaks.iterator();
        while (iterator2.hasNext()) {
            int n2 = (Integer)iterator2.next();
            if (n2 >= n) {
                ++n2;
            }
            arrayList.add(new Integer(n2));
        }
        this.rowBreaks = arrayList;
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowInserted(this, n);
        }
        ++this.numRows;
    }

    public final void insertColumn(int n) {
        if (n < 0 || n >= this.numColumns) {
            return;
        }
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].insertColumn(n);
        }
        HyperlinkRecord hyperlinkRecord = null;
        Iterator iterator = this.hyperlinks.iterator();
        while (iterator.hasNext()) {
            hyperlinkRecord = (HyperlinkRecord)iterator.next();
            hyperlinkRecord.insertColumn(n);
        }
        iterator = this.columnFormats.iterator();
        while (iterator.hasNext()) {
            ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)iterator.next();
            if (columnInfoRecord.getColumn() < n) continue;
            columnInfoRecord.incrementColumn();
        }
        if (this.dataValidation != null) {
            this.dataValidation.insertColumn(n);
        }
        this.mergedCells.insertColumn(n);
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnInserted(this, n);
        }
        ++this.numColumns;
    }

    public final void removeColumn(int n) {
        if (n < 0 || n >= this.numColumns) {
            return;
        }
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].removeColumn(n);
        }
        HyperlinkRecord hyperlinkRecord = null;
        Iterator iterator = this.hyperlinks.iterator();
        while (iterator.hasNext()) {
            hyperlinkRecord = (HyperlinkRecord)iterator.next();
            if (hyperlinkRecord.getColumn() == n && hyperlinkRecord.getLastColumn() == n) {
                this.hyperlinks.remove(this.hyperlinks.indexOf(hyperlinkRecord));
                continue;
            }
            hyperlinkRecord.removeColumn(n);
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeColumn(n);
        }
        this.mergedCells.removeColumn(n);
        iterator = this.columnFormats.iterator();
        ColumnInfoRecord columnInfoRecord = null;
        while (iterator.hasNext()) {
            ColumnInfoRecord columnInfoRecord2 = (ColumnInfoRecord)iterator.next();
            if (columnInfoRecord2.getColumn() == n) {
                columnInfoRecord = columnInfoRecord2;
                continue;
            }
            if (columnInfoRecord2.getColumn() <= n) continue;
            columnInfoRecord2.decrementColumn();
        }
        if (columnInfoRecord != null) {
            this.columnFormats.remove(columnInfoRecord);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnRemoved(this, n);
        }
        --this.numColumns;
    }

    public final void removeRow(int n) {
        if (n < 0 || n >= this.numRows) {
            return;
        }
        RowRecord[] rowRecordArray = this.rows;
        this.rows = new RowRecord[rowRecordArray.length];
        System.arraycopy(rowRecordArray, 0, this.rows, 0, n);
        System.arraycopy(rowRecordArray, n + 1, this.rows, n, this.numRows - (n + 1));
        for (int i2 = n; i2 < this.numRows; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].decrementRow();
        }
        HyperlinkRecord hyperlinkRecord = null;
        Iterator iterator = this.hyperlinks.iterator();
        while (iterator.hasNext()) {
            hyperlinkRecord = (HyperlinkRecord)iterator.next();
            if (hyperlinkRecord.getRow() == n && hyperlinkRecord.getLastRow() == n) {
                iterator.remove();
                continue;
            }
            hyperlinkRecord.removeRow(n);
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeRow(n);
        }
        this.mergedCells.removeRow(n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator2 = this.rowBreaks.iterator();
        while (iterator2.hasNext()) {
            int n2 = (Integer)iterator2.next();
            if (n2 == n) continue;
            if (n2 > n) {
                --n2;
            }
            arrayList.add(new Integer(n2));
        }
        this.rowBreaks = arrayList;
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowRemoved(this, n);
        }
        --this.numRows;
    }

    public final void addCell(WritableCell writableCell) {
        if (writableCell.getType() == CellType.EMPTY && writableCell != null && writableCell.getCellFormat() == null) {
            return;
        }
        CellValue cellValue = (CellValue)writableCell;
        if (cellValue.isReferenced()) {
            throw new JxlWriteException(JxlWriteException.cellReferenced);
        }
        int n = writableCell.getRow();
        RowRecord rowRecord = this.getRowRecord(n);
        rowRecord.addCell(cellValue);
        this.numRows = Math.max(n + 1, this.numRows);
        this.numColumns = Math.max(this.numColumns, rowRecord.getMaxColumn());
        cellValue.setCellDetails(this.formatRecords, this.sharedStrings, this);
    }

    private RowRecord getRowRecord(int n) {
        Object object;
        if (n >= 65536) {
            throw new RowsExceededException();
        }
        if (n >= this.rows.length) {
            object = this.rows;
            this.rows = new RowRecord[Math.max(((RowRecord[])object).length + 10, n + 1)];
            System.arraycopy(object, 0, this.rows, 0, ((RowRecord[])object).length);
            object = null;
        }
        if ((object = this.rows[n]) == null) {
            this.rows[n] = object = new RowRecord(n);
        }
        return object;
    }

    final RowRecord getRowInfo(int n) {
        if (n < 0 || n > this.rows.length) {
            return null;
        }
        return this.rows[n];
    }

    final ColumnInfoRecord getColumnInfo(int n) {
        Iterator iterator = this.columnFormats.iterator();
        ColumnInfoRecord columnInfoRecord = null;
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            columnInfoRecord = (ColumnInfoRecord)iterator.next();
            if (columnInfoRecord.getColumn() < n) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return columnInfoRecord.getColumn() == n ? columnInfoRecord : null;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final void setHidden(boolean bl) {
        this.settings.setHidden(bl);
    }

    public final void setProtected(boolean bl) {
        this.settings.setProtected(bl);
    }

    public final void setSelected() {
        this.settings.setSelected();
    }

    public final boolean isHidden() {
        return this.settings.isHidden();
    }

    public final void setColumnView(int n, int n2) {
        CellView cellView = new CellView();
        cellView.setSize(n2 * 256);
        this.setColumnView(n, cellView);
    }

    public final void setColumnView(int n, int n2, CellFormat cellFormat) {
        CellView cellView = new CellView();
        cellView.setSize(n2 * 256);
        cellView.setFormat(cellFormat);
        this.setColumnView(n, cellView);
    }

    public final void setColumnView(int n, CellView cellView) {
        block7: {
            XFRecord xFRecord = (XFRecord)cellView.getFormat();
            if (xFRecord == null) {
                Styles styles = this.getWorkbook().getStyles();
                xFRecord = styles.getNormalStyle();
            }
            try {
                if (!xFRecord.isInitialized()) {
                    this.formatRecords.addStyle(xFRecord);
                }
                int n2 = cellView.depUsed() ? cellView.getDimension() * 256 : cellView.getSize();
                ColumnInfoRecord columnInfoRecord = new ColumnInfoRecord(n, n2, xFRecord);
                if (cellView.isHidden()) {
                    columnInfoRecord.setHidden(true);
                }
                if (!this.columnFormats.contains(columnInfoRecord)) {
                    this.columnFormats.add(columnInfoRecord);
                } else {
                    boolean bl = this.columnFormats.remove(columnInfoRecord);
                    this.columnFormats.add(columnInfoRecord);
                }
            }
            catch (NumFormatRecordsException numFormatRecordsException) {
                logger.warn("Maximum number of format records exceeded.  Using default format.");
                ColumnInfoRecord columnInfoRecord = new ColumnInfoRecord(n, cellView.getDimension() * 256, WritableWorkbook.NORMAL_STYLE);
                if (this.columnFormats.contains(columnInfoRecord)) break block7;
                this.columnFormats.add(columnInfoRecord);
            }
        }
    }

    public final void setRowView(int n, int n2) {
        this.setRowView(n, n2, false);
    }

    public final void setRowView(int n, boolean bl) {
        RowRecord rowRecord = this.getRowRecord(n);
        rowRecord.setCollapsed(bl);
    }

    public final void setRowView(int n, int n2, boolean bl) {
        RowRecord rowRecord = this.getRowRecord(n);
        rowRecord.setRowHeight(n2);
        rowRecord.setCollapsed(bl);
    }

    public final void write() {
        boolean bl = this.drawingsModified;
        if (this.workbook.getDrawingGroup() != null) {
            bl |= this.workbook.getDrawingGroup().hasDrawingsOmitted();
        }
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.hyperlinks, this.mergedCells, this.columnFormats);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.setSettings(this.settings);
        this.sheetWriter.setPLS(this.plsRecord);
        this.sheetWriter.setDrawings(this.drawings, bl);
        this.sheetWriter.setButtonPropertySet(this.buttonPropertySet);
        this.sheetWriter.setDataValidation(this.dataValidation);
        this.sheetWriter.write();
    }

    private void copyCells(Sheet sheet) {
        int n = sheet.getRows();
        Cell[] cellArray = null;
        Cell cell = null;
        for (int i2 = 0; i2 < n; ++i2) {
            cellArray = sheet.getRow(i2);
            for (int i3 = 0; i3 < cellArray.length; ++i3) {
                cell = cellArray[i3];
                CellType cellType = cell.getType();
                try {
                    CellValue cellValue;
                    if (cellType == CellType.LABEL) {
                        cellValue = new Label((LabelCell)cell);
                        this.addCell(cellValue);
                        continue;
                    }
                    if (cellType == CellType.NUMBER) {
                        cellValue = new Number((NumberCell)cell);
                        this.addCell(cellValue);
                        continue;
                    }
                    if (cellType == CellType.DATE) {
                        cellValue = new DateTime((DateCell)cell);
                        this.addCell(cellValue);
                        continue;
                    }
                    if (cellType == CellType.BOOLEAN) {
                        cellValue = new Boolean((BooleanCell)cell);
                        this.addCell(cellValue);
                        continue;
                    }
                    if (cellType == CellType.NUMBER_FORMULA) {
                        cellValue = new ReadNumberFormulaRecord((FormulaData)cell);
                        this.addCell(cellValue);
                        continue;
                    }
                    if (cellType == CellType.STRING_FORMULA) {
                        cellValue = new ReadStringFormulaRecord((FormulaData)cell);
                        this.addCell(cellValue);
                        continue;
                    }
                    if (cellType == CellType.BOOLEAN_FORMULA) {
                        cellValue = new ReadBooleanFormulaRecord((FormulaData)cell);
                        this.addCell(cellValue);
                        continue;
                    }
                    if (cellType == CellType.DATE_FORMULA) {
                        cellValue = new ReadDateFormulaRecord((FormulaData)cell);
                        this.addCell(cellValue);
                        continue;
                    }
                    if (cellType == CellType.FORMULA_ERROR) {
                        cellValue = new ReadErrorFormulaRecord((FormulaData)cell);
                        this.addCell(cellValue);
                        continue;
                    }
                    if (cellType != CellType.EMPTY || cell.getCellFormat() == null) continue;
                    cellValue = new Blank(cell);
                    this.addCell(cellValue);
                    continue;
                }
                catch (WriteException writeException) {
                    Assert.verify(false);
                }
            }
        }
    }

    private void copyCells(WritableSheet writableSheet) {
        int n = writableSheet.getRows();
        Cell[] cellArray = null;
        Cell cell = null;
        for (int i2 = 0; i2 < n; ++i2) {
            cellArray = writableSheet.getRow(i2);
            for (int i3 = 0; i3 < cellArray.length; ++i3) {
                cell = cellArray[i3];
                CellType cellType = cell.getType();
                try {
                    WritableCell writableCell = ((WritableCell)cell).copyTo(cell.getColumn(), cell.getRow());
                    this.addCell(writableCell);
                    continue;
                }
                catch (WriteException writeException) {
                    Assert.verify(false);
                }
            }
        }
    }

    final void copy(Sheet sheet) {
        jxl.read.biff.DataValidation dataValidation;
        DrawingGroupObject[] drawingGroupObjectArray;
        Object[] objectArray;
        this.settings = new SheetSettings(sheet.getSettings());
        this.copyCells(sheet);
        SheetImpl sheetImpl = (SheetImpl)sheet;
        jxl.read.biff.ColumnInfoRecord[] columnInfoRecordArray = sheetImpl.getColumnInfos();
        for (int i2 = 0; i2 < columnInfoRecordArray.length; ++i2) {
            jxl.read.biff.ColumnInfoRecord columnInfoRecord = columnInfoRecordArray[i2];
            for (int i3 = columnInfoRecord.getStartColumn(); i3 <= columnInfoRecord.getEndColumn(); ++i3) {
                ColumnInfoRecord columnInfoRecord2 = new ColumnInfoRecord(columnInfoRecord, i3, this.formatRecords);
                columnInfoRecord2.setHidden(columnInfoRecord.getHidden());
                this.columnFormats.add(columnInfoRecord2);
            }
        }
        Hyperlink[] hyperlinkArray = sheet.getHyperlinks();
        for (int i4 = 0; i4 < hyperlinkArray.length; ++i4) {
            WritableHyperlink writableHyperlink = new WritableHyperlink(hyperlinkArray[i4], this);
            this.hyperlinks.add(writableHyperlink);
        }
        Range[] rangeArray = sheet.getMergedCells();
        for (int i5 = 0; i5 < rangeArray.length; ++i5) {
            this.mergedCells.add(new SheetRangeImpl((SheetRangeImpl)rangeArray[i5], this));
        }
        try {
            objectArray = sheetImpl.getRowProperties();
            for (int i6 = 0; i6 < objectArray.length; ++i6) {
                drawingGroupObjectArray = this.getRowRecord(objectArray[i6].getRowNumber());
                XFRecord xFRecord = objectArray[i6].hasDefaultFormat() ? this.formatRecords.getXFRecord(objectArray[i6].getXFIndex()) : null;
                drawingGroupObjectArray.setRowDetails(objectArray[i6].getRowHeight(), objectArray[i6].matchesDefaultFontHeight(), objectArray[i6].isCollapsed(), xFRecord);
            }
        }
        catch (RowsExceededException rowsExceededException) {
            Assert.verify(false);
        }
        objectArray = sheetImpl.getRowPageBreaks();
        if (objectArray != null) {
            for (int i7 = 0; i7 < objectArray.length; ++i7) {
                this.rowBreaks.add(new Integer((int)objectArray[i7]));
            }
        }
        if ((dataValidation = sheetImpl.getDataValidation()) != null) {
            this.dataValidation = new DataValidation(dataValidation, this.workbook, this.workbookSettings);
        }
        this.sheetWriter.setCharts(sheetImpl.getCharts());
        drawingGroupObjectArray = sheetImpl.getDrawings();
        for (int i8 = 0; i8 < drawingGroupObjectArray.length; ++i8) {
            DrawingGroupObject drawingGroupObject;
            if (drawingGroupObjectArray[i8] instanceof Drawing) {
                drawingGroupObject = new WritableImage(drawingGroupObjectArray[i8], this.workbook.getDrawingGroup());
                this.drawings.add(drawingGroupObject);
                this.images.add(drawingGroupObject);
                continue;
            }
            if (drawingGroupObjectArray[i8] instanceof Comment) {
                drawingGroupObject = new Comment(drawingGroupObjectArray[i8], this.workbook.getDrawingGroup(), this.workbookSettings);
                this.drawings.add(drawingGroupObject);
                CellValue cellValue = (CellValue)this.getWritableCell(((Comment)drawingGroupObject).getColumn(), ((Comment)drawingGroupObject).getRow());
                Assert.verify(cellValue.getCellFeatures() != null);
                cellValue.getWritableCellFeatures().setCommentDrawing((Comment)drawingGroupObject);
                continue;
            }
            if (!(drawingGroupObjectArray[i8] instanceof Button)) continue;
            drawingGroupObject = new Button(drawingGroupObjectArray[i8], this.workbook.getDrawingGroup(), this.workbookSettings);
            this.drawings.add(drawingGroupObject);
        }
        this.sheetWriter.setWorkspaceOptions(sheetImpl.getWorkspaceOptions());
        if (sheetImpl.getSheetBof().isChart()) {
            this.chartOnly = true;
            this.sheetWriter.setChartOnly();
        }
        if (sheetImpl.getPLS() != null) {
            if (sheetImpl.getWorkbookBof().isBiff7()) {
                logger.warn("Cannot copy Biff7 print settings record - ignoring");
            } else {
                this.plsRecord = new PLSRecord(sheetImpl.getPLS());
            }
        }
        if (sheetImpl.getButtonPropertySet() != null) {
            this.buttonPropertySet = new ButtonPropertySetRecord(sheetImpl.getButtonPropertySet());
        }
    }

    final void copy(WritableSheet writableSheet) {
        Object object;
        Object object2;
        this.settings = new SheetSettings(writableSheet.getSettings());
        this.copyCells(writableSheet);
        this.columnFormats = ((WritableSheetImpl)writableSheet).columnFormats;
        Range[] rangeArray = writableSheet.getMergedCells();
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            this.mergedCells.add(new SheetRangeImpl((SheetRangeImpl)rangeArray[i2], this));
        }
        try {
            object2 = ((WritableSheetImpl)writableSheet).rows;
            object = null;
            for (int i3 = 0; i3 < ((RowRecord[])object2).length; ++i3) {
                object = object2[i3];
                if (object == null || ((RowRecord)object).isDefaultHeight() && !((RowRecord)object).isCollapsed()) continue;
                RowRecord rowRecord = this.getRowRecord(i3);
                rowRecord.setRowDetails(((RowRecord)object).getRowHeight(), ((RowRecord)object).matchesDefaultFontHeight(), ((RowRecord)object).isCollapsed(), ((RowRecord)object).getStyle());
            }
        }
        catch (RowsExceededException rowsExceededException) {
            Assert.verify(false);
        }
        object2 = (WritableSheetImpl)writableSheet;
        this.rowBreaks = new ArrayList(((WritableSheetImpl)object2).rowBreaks);
        object = ((WritableSheetImpl)object2).dataValidation;
        if (object != null) {
            this.dataValidation = new DataValidation((DataValidation)object, this.workbook, this.workbookSettings);
        }
        this.sheetWriter.setCharts(super.getCharts());
        DrawingGroupObject[] drawingGroupObjectArray = super.getDrawings();
        for (int i4 = 0; i4 < drawingGroupObjectArray.length; ++i4) {
            if (!(drawingGroupObjectArray[i4] instanceof Drawing)) continue;
            WritableImage writableImage = new WritableImage(drawingGroupObjectArray[i4], this.workbook.getDrawingGroup());
            this.drawings.add(writableImage);
            this.images.add(writableImage);
        }
        this.sheetWriter.setWorkspaceOptions(super.getWorkspaceOptions());
        if (((WritableSheetImpl)object2).plsRecord != null) {
            this.plsRecord = new PLSRecord(((WritableSheetImpl)object2).plsRecord);
        }
        if (((WritableSheetImpl)object2).buttonPropertySet != null) {
            this.buttonPropertySet = new ButtonPropertySetRecord(((WritableSheetImpl)object2).buttonPropertySet);
        }
    }

    final HeaderRecord getHeader() {
        return this.sheetWriter.getHeader();
    }

    final FooterRecord getFooter() {
        return this.sheetWriter.getFooter();
    }

    public final boolean isProtected() {
        return this.settings.isProtected();
    }

    public final Hyperlink[] getHyperlinks() {
        Hyperlink[] hyperlinkArray = new Hyperlink[this.hyperlinks.size()];
        for (int i2 = 0; i2 < this.hyperlinks.size(); ++i2) {
            hyperlinkArray[i2] = (Hyperlink)this.hyperlinks.get(i2);
        }
        return hyperlinkArray;
    }

    public final Range[] getMergedCells() {
        return this.mergedCells.getMergedCells();
    }

    public final WritableHyperlink[] getWritableHyperlinks() {
        WritableHyperlink[] writableHyperlinkArray = new WritableHyperlink[this.hyperlinks.size()];
        for (int i2 = 0; i2 < this.hyperlinks.size(); ++i2) {
            writableHyperlinkArray[i2] = (WritableHyperlink)this.hyperlinks.get(i2);
        }
        return writableHyperlinkArray;
    }

    public final void removeHyperlink(WritableHyperlink writableHyperlink) {
        this.removeHyperlink(writableHyperlink, false);
    }

    public final void removeHyperlink(WritableHyperlink writableHyperlink, boolean bl) {
        this.hyperlinks.remove(this.hyperlinks.indexOf(writableHyperlink));
        if (!bl) {
            Assert.verify(this.rows.length > writableHyperlink.getRow() && this.rows[writableHyperlink.getRow()] != null);
            this.rows[writableHyperlink.getRow()].removeCell(writableHyperlink.getColumn());
        }
    }

    public final void addHyperlink(WritableHyperlink writableHyperlink) {
        Object object;
        Cell cell = this.getCell(writableHyperlink.getColumn(), writableHyperlink.getRow());
        Object object2 = null;
        if (writableHyperlink.isFile() || writableHyperlink.isUNC()) {
            object = writableHyperlink.getContents();
            object2 = object == null ? writableHyperlink.getFile().getPath() : object;
        } else if (writableHyperlink.isURL()) {
            object = writableHyperlink.getContents();
            object2 = object == null ? writableHyperlink.getURL().toString() : object;
        } else if (writableHyperlink.isLocation()) {
            object2 = writableHyperlink.getContents();
        }
        if (cell.getType() == CellType.LABEL) {
            object = (Label)cell;
            ((Label)object).setString((String)object2);
            ((CellValue)object).setCellFormat(WritableWorkbook.HYPERLINK_STYLE);
        } else {
            object = new Label(writableHyperlink.getColumn(), writableHyperlink.getRow(), (String)object2, (CellFormat)WritableWorkbook.HYPERLINK_STYLE);
            this.addCell((WritableCell)object);
        }
        for (int i2 = writableHyperlink.getRow(); i2 <= writableHyperlink.getLastRow(); ++i2) {
            for (int i3 = writableHyperlink.getColumn(); i3 <= writableHyperlink.getLastColumn(); ++i3) {
                if (i2 == writableHyperlink.getRow() || i3 == writableHyperlink.getColumn() || this.rows[i2] == null) continue;
                this.rows[i2].removeCell(i3);
            }
        }
        writableHyperlink.initialize(this);
        this.hyperlinks.add(writableHyperlink);
    }

    public final Range mergeCells(int n, int n2, int n3, int n4) {
        if (n3 < n || n4 < n2) {
            logger.warn("Cannot merge cells - top left and bottom right incorrectly specified");
        }
        if (n3 >= this.numColumns || n4 >= this.numRows) {
            this.addCell(new Blank(n3, n4));
        }
        SheetRangeImpl sheetRangeImpl = new SheetRangeImpl(this, n, n2, n3, n4);
        this.mergedCells.add(sheetRangeImpl);
        return sheetRangeImpl;
    }

    public final void unmergeCells(Range range) {
        this.mergedCells.unmergeCells(range);
    }

    public final void setHeader(String string, String string2, String string3) {
        HeaderFooter headerFooter = new HeaderFooter();
        headerFooter.getLeft().append(string);
        headerFooter.getCentre().append(string2);
        headerFooter.getRight().append(string3);
        this.settings.setHeader(headerFooter);
    }

    public final void setFooter(String string, String string2, String string3) {
        HeaderFooter headerFooter = new HeaderFooter();
        headerFooter.getLeft().append(string);
        headerFooter.getCentre().append(string2);
        headerFooter.getRight().append(string3);
        this.settings.setFooter(headerFooter);
    }

    public final void setPageSetup(PageOrientation pageOrientation) {
        this.settings.setOrientation(pageOrientation);
    }

    public final void setPageSetup(PageOrientation pageOrientation, double d2, double d3) {
        this.settings.setOrientation(pageOrientation);
        this.settings.setHeaderMargin(d2);
        this.settings.setFooterMargin(d3);
    }

    public final void setPageSetup(PageOrientation pageOrientation, PaperSize paperSize, double d2, double d3) {
        this.settings.setPaperSize(paperSize);
        this.settings.setOrientation(pageOrientation);
        this.settings.setHeaderMargin(d2);
        this.settings.setFooterMargin(d3);
    }

    public final SheetSettings getSettings() {
        return this.settings;
    }

    final WorkbookSettings getWorkbookSettings() {
        return this.workbookSettings;
    }

    public final void addRowPageBreak(int n) {
        Iterator iterator = this.rowBreaks.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            if ((Integer)iterator.next() != n) continue;
            bl = true;
        }
        if (!bl) {
            this.rowBreaks.add(new Integer(n));
        }
    }

    private Chart[] getCharts() {
        return this.sheetWriter.getCharts();
    }

    private DrawingGroupObject[] getDrawings() {
        DrawingGroupObject[] drawingGroupObjectArray = new DrawingGroupObject[this.drawings.size()];
        drawingGroupObjectArray = this.drawings.toArray(drawingGroupObjectArray);
        return drawingGroupObjectArray;
    }

    final void checkMergedBorders() {
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.hyperlinks, this.mergedCells, this.columnFormats);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.checkMergedBorders();
    }

    private WorkspaceInformationRecord getWorkspaceOptions() {
        return this.sheetWriter.getWorkspaceOptions();
    }

    final void rationalize(IndexMapping indexMapping, IndexMapping indexMapping2, IndexMapping indexMapping3) {
        Iterator iterator = this.columnFormats.iterator();
        while (iterator.hasNext()) {
            ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)iterator.next();
            columnInfoRecord.rationalize(indexMapping);
        }
        for (int i2 = 0; i2 < this.rows.length; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].rationalize(indexMapping);
        }
        Chart[] chartArray = this.getCharts();
        for (int i3 = 0; i3 < chartArray.length; ++i3) {
            chartArray[i3].rationalize(indexMapping, indexMapping2, indexMapping3);
        }
    }

    final WritableWorkbookImpl getWorkbook() {
        return this.workbook;
    }

    public final CellFormat getColumnFormat(int n) {
        return this.getColumnView(n).getFormat();
    }

    public final int getColumnWidth(int n) {
        return this.getColumnView(n).getDimension();
    }

    public final int getRowHeight(int n) {
        return this.getRowView(n).getDimension();
    }

    final boolean isChartOnly() {
        return this.chartOnly;
    }

    public final CellView getRowView(int n) {
        CellView cellView = new CellView();
        try {
            RowRecord rowRecord = this.getRowRecord(n);
            if (rowRecord == null || rowRecord.isDefaultHeight()) {
                cellView.setDimension(this.settings.getDefaultRowHeight());
                cellView.setSize(this.settings.getDefaultRowHeight());
            } else if (rowRecord.isCollapsed()) {
                cellView.setHidden(true);
            } else {
                cellView.setDimension(rowRecord.getRowHeight());
                cellView.setSize(rowRecord.getRowHeight());
            }
            return cellView;
        }
        catch (RowsExceededException rowsExceededException) {
            cellView.setDimension(this.settings.getDefaultRowHeight());
            cellView.setSize(this.settings.getDefaultRowHeight());
            return cellView;
        }
    }

    public final CellView getColumnView(int n) {
        ColumnInfoRecord columnInfoRecord = this.getColumnInfo(n);
        CellView cellView = new CellView();
        if (columnInfoRecord != null) {
            cellView.setDimension(columnInfoRecord.getWidth() / 256);
            cellView.setSize(columnInfoRecord.getWidth());
            cellView.setHidden(columnInfoRecord.getHidden());
            cellView.setFormat(columnInfoRecord.getCellFormat());
        } else {
            cellView.setDimension(this.settings.getDefaultColumnWidth() / 256);
            cellView.setSize(this.settings.getDefaultColumnWidth());
        }
        return cellView;
    }

    public final void addImage(WritableImage writableImage) {
        int n;
        CharSequence charSequence;
        boolean bl = false;
        java.io.File file = writableImage.getImageFile();
        String string = "?";
        if (file != null) {
            charSequence = file.getName();
            n = ((String)charSequence).lastIndexOf(46);
            string = n != -1 ? ((String)charSequence).substring(n + 1) : "";
            for (int i2 = 0; i2 < imageTypes.length && !bl; ++i2) {
                if (!string.equalsIgnoreCase(imageTypes[i2])) continue;
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.workbook.addDrawing(writableImage);
            this.drawings.add(writableImage);
            this.images.add(writableImage);
        } else {
            charSequence = new StringBuffer("Image type ");
            ((StringBuffer)charSequence).append(string);
            ((StringBuffer)charSequence).append(" not supported.  Supported types are ");
            ((StringBuffer)charSequence).append(imageTypes[0]);
            for (n = 1; n < imageTypes.length; ++n) {
                ((StringBuffer)charSequence).append(", ");
                ((StringBuffer)charSequence).append(imageTypes[n]);
            }
            logger.warn(((StringBuffer)charSequence).toString());
        }
    }

    public final int getNumberOfImages() {
        return this.images.size();
    }

    public final WritableImage getImage(int n) {
        return (WritableImage)this.images.get(n);
    }

    public final Image getDrawing(int n) {
        return (Image)this.images.get(n);
    }

    public final void removeImage(WritableImage writableImage) {
        boolean bl = this.drawings.remove(writableImage);
        this.images.remove(writableImage);
        this.drawingsModified = true;
        this.workbook.removeDrawing(writableImage);
    }

    private String validateName(String string) {
        if (string.length() > 31) {
            logger.warn("Sheet name " + string + " too long - truncating");
            string = string.substring(0, 31);
        }
        if (string.charAt(0) == '\'') {
            logger.warn("Sheet naming cannot start with ' - removing");
            string = string.substring(1);
        }
        for (int i2 = 0; i2 < illegalSheetNameCharacters.length; ++i2) {
            String string2 = string.replace(illegalSheetNameCharacters[i2], '@');
            if (string != string2) {
                logger.warn(illegalSheetNameCharacters[i2] + " is not a valid character within a sheet name - replacing");
            }
            string = string2;
        }
        return string;
    }

    final void addDrawing(DrawingGroupObject drawingGroupObject) {
        this.drawings.add(drawingGroupObject);
        Assert.verify(!(drawingGroupObject instanceof Drawing));
    }

    final void removeDrawing(DrawingGroupObject drawingGroupObject) {
        int n = this.drawings.size();
        this.drawings.remove(drawingGroupObject);
        int n2 = this.drawings.size();
        this.drawingsModified = true;
        Assert.verify(n2 == n - 1);
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

