/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.apache.commons.io.IOCase;

public class FilenameUtils {
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STR = Character.toString('.');
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = FilenameUtils.isSystemWindows() ? (char)47 : (char)92;

    static final boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    private static boolean isSeparator(char c2) {
        return c2 == '/' || c2 == '\\';
    }

    public static final String normalize(String string) {
        return FilenameUtils.doNormalize(string, SYSTEM_SEPARATOR, true);
    }

    public static final String normalize(String string, boolean bl) {
        char c2 = bl ? (char)'/' : '\\';
        return FilenameUtils.doNormalize(string, c2, true);
    }

    public static final String normalizeNoEndSeparator(String string) {
        return FilenameUtils.doNormalize(string, SYSTEM_SEPARATOR, false);
    }

    public static final String normalizeNoEndSeparator(String string, boolean bl) {
        char c2 = bl ? (char)'/' : '\\';
        return FilenameUtils.doNormalize(string, c2, false);
    }

    private static String doNormalize(String string, char c2, boolean bl) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return string;
        }
        int n4 = FilenameUtils.getPrefixLength(string);
        if (n4 < 0) {
            return null;
        }
        char[] cArray = new char[n3 + 2];
        string.getChars(0, string.length(), cArray, 0);
        char c3 = c2 == SYSTEM_SEPARATOR ? OTHER_SEPARATOR : SYSTEM_SEPARATOR;
        for (n2 = 0; n2 < cArray.length; ++n2) {
            if (cArray[n2] != c3) continue;
            cArray[n2] = c2;
        }
        n2 = 1;
        if (cArray[n3 - 1] != c2) {
            cArray[n3++] = c2;
            n2 = 0;
        }
        for (n = n4 + 1; n < n3; ++n) {
            if (cArray[n] != c2 || cArray[n - 1] != c2) continue;
            System.arraycopy(cArray, n, cArray, n - 1, n3 - n);
            --n3;
            --n;
        }
        for (n = n4 + 1; n < n3; ++n) {
            if (cArray[n] != c2 || cArray[n - 1] != '.' || n != n4 + 1 && cArray[n - 2] != c2) continue;
            if (n == n3 - 1) {
                n2 = 1;
            }
            System.arraycopy(cArray, n + 1, cArray, n - 1, n3 - n);
            n3 -= 2;
            --n;
        }
        block3: for (n = n4 + 2; n < n3; ++n) {
            if (cArray[n] != c2 || cArray[n - 1] != '.' || cArray[n - 2] != '.' || n != n4 + 2 && cArray[n - 3] != c2) continue;
            if (n == n4 + 2) {
                return null;
            }
            if (n == n3 - 1) {
                n2 = 1;
            }
            for (int i2 = n - 4; i2 >= n4; --i2) {
                if (cArray[i2] != c2) continue;
                System.arraycopy(cArray, n + 1, cArray, i2 + 1, n3 - n);
                n3 -= n - i2;
                n = i2 + 1;
                continue block3;
            }
            System.arraycopy(cArray, n + 1, cArray, n4, n3 - n);
            n3 -= n + 1 - n4;
            n = n4 + 1;
        }
        if (n3 <= 0) {
            return "";
        }
        if (n3 <= n4) {
            return new String(cArray, 0, n3);
        }
        if (n2 != 0 && bl) {
            return new String(cArray, 0, n3);
        }
        return new String(cArray, 0, n3 - 1);
    }

    public static final String concat(String string, String string2) {
        int n = FilenameUtils.getPrefixLength(string2);
        if (n < 0) {
            return null;
        }
        if (n > 0) {
            return FilenameUtils.normalize(string2);
        }
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return FilenameUtils.normalize(string2);
        }
        char c2 = string.charAt(n2 - 1);
        if (FilenameUtils.isSeparator(c2)) {
            return FilenameUtils.normalize(string + string2);
        }
        return FilenameUtils.normalize(string + '/' + string2);
    }

    public static final boolean directoryContains(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Directory must not be null");
        }
        if (string2 == null) {
            return false;
        }
        if (IOCase.SYSTEM.checkEquals(string, string2)) {
            return false;
        }
        return IOCase.SYSTEM.checkStartsWith(string2, string);
    }

    public static final String separatorsToUnix(String string) {
        if (string == null || string.indexOf(92) == -1) {
            return string;
        }
        return string.replace('\\', '/');
    }

    public static final String separatorsToWindows(String string) {
        if (string == null || string.indexOf(47) == -1) {
            return string;
        }
        return string.replace('/', '\\');
    }

    public static final String separatorsToSystem(String string) {
        if (string == null) {
            return null;
        }
        if (FilenameUtils.isSystemWindows()) {
            return FilenameUtils.separatorsToWindows(string);
        }
        return FilenameUtils.separatorsToUnix(string);
    }

    public static final int getPrefixLength(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        char c2 = string.charAt(0);
        if (c2 == ':') {
            return -1;
        }
        if (n == 1) {
            if (c2 == '~') {
                return 2;
            }
            return FilenameUtils.isSeparator(c2) ? 1 : 0;
        }
        if (c2 == '~') {
            int n2 = string.indexOf(47, 1);
            int n3 = string.indexOf(92, 1);
            if (n2 == -1 && n3 == -1) {
                return n + 1;
            }
            n2 = n2 == -1 ? n3 : n2;
            n3 = n3 == -1 ? n2 : n3;
            return Math.min(n2, n3) + 1;
        }
        char c3 = string.charAt(1);
        if (c3 == ':') {
            if ((c2 = Character.toUpperCase(c2)) >= 'A' && c2 <= 'Z') {
                if (n == 2 || !FilenameUtils.isSeparator(string.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (FilenameUtils.isSeparator(c2) && FilenameUtils.isSeparator(c3)) {
            int n4 = string.indexOf(47, 2);
            int n5 = string.indexOf(92, 2);
            if (n4 == -1 && n5 == -1 || n4 == 2 || n5 == 2) {
                return -1;
            }
            n4 = n4 == -1 ? n5 : n4;
            n5 = n5 == -1 ? n4 : n5;
            return Math.min(n4, n5) + 1;
        }
        return FilenameUtils.isSeparator(c2) ? 1 : 0;
    }

    public static final int indexOfLastSeparator(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(92);
        return Math.max(n, n2);
    }

    public static final int indexOfExtension(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.lastIndexOf(46);
        int n2 = FilenameUtils.indexOfLastSeparator(string);
        return n2 > n ? -1 : n;
    }

    public static final String getPrefix(String string) {
        if (string == null) {
            return null;
        }
        int n = FilenameUtils.getPrefixLength(string);
        if (n < 0) {
            return null;
        }
        if (n > string.length()) {
            return string + '/';
        }
        return string.substring(0, n);
    }

    public static final String getPath(String string) {
        return FilenameUtils.doGetPath(string, 1);
    }

    public static final String getPathNoEndSeparator(String string) {
        return FilenameUtils.doGetPath(string, 0);
    }

    private static String doGetPath(String string, int n) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(string);
        if (n2 < 0) {
            return null;
        }
        int n3 = FilenameUtils.indexOfLastSeparator(string);
        int n4 = n3 + n;
        if (n2 >= string.length() || n3 < 0 || n2 >= n4) {
            return "";
        }
        return string.substring(n2, n4);
    }

    public static final String getFullPath(String string) {
        return FilenameUtils.doGetFullPath(string, true);
    }

    public static final String getFullPathNoEndSeparator(String string) {
        return FilenameUtils.doGetFullPath(string, false);
    }

    private static String doGetFullPath(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = FilenameUtils.getPrefixLength(string);
        if (n < 0) {
            return null;
        }
        if (n >= string.length()) {
            if (bl) {
                return FilenameUtils.getPrefix(string);
            }
            return string;
        }
        int n2 = FilenameUtils.indexOfLastSeparator(string);
        if (n2 < 0) {
            return string.substring(0, n);
        }
        int n3 = n2 + (bl ? 1 : 0);
        if (n3 == 0) {
            ++n3;
        }
        return string.substring(0, n3);
    }

    public static final String getName(String string) {
        if (string == null) {
            return null;
        }
        int n = FilenameUtils.indexOfLastSeparator(string);
        return string.substring(n + 1);
    }

    public static final String getBaseName(String string) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(string));
    }

    public static final String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = FilenameUtils.indexOfExtension(string);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static final String removeExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = FilenameUtils.indexOfExtension(string);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static final boolean equals(String string, String string2) {
        return FilenameUtils.equals(string, string2, false, IOCase.SENSITIVE);
    }

    public static final boolean equalsOnSystem(String string, String string2) {
        return FilenameUtils.equals(string, string2, false, IOCase.SYSTEM);
    }

    public static final boolean equalsNormalized(String string, String string2) {
        return FilenameUtils.equals(string, string2, true, IOCase.SENSITIVE);
    }

    public static final boolean equalsNormalizedOnSystem(String string, String string2) {
        return FilenameUtils.equals(string, string2, true, IOCase.SYSTEM);
    }

    public static final boolean equals(String string, String string2, boolean bl, IOCase iOCase) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        if (bl) {
            string = FilenameUtils.normalize(string);
            string2 = FilenameUtils.normalize(string2);
            if (string == null || string2 == null) {
                throw new NullPointerException("Error normalizing one or both of the file names");
            }
        }
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        return iOCase.checkEquals(string, string2);
    }

    public static final boolean isExtension(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        String string3 = FilenameUtils.getExtension(string);
        return string3.equals(string2);
    }

    public static final boolean isExtension(String string, String[] stringArray) {
        if (string == null) {
            return false;
        }
        if (stringArray == null || stringArray.length == 0) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        String string2 = FilenameUtils.getExtension(string);
        for (String string3 : stringArray) {
            if (!string2.equals(string3)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isExtension(String string, Collection collection) {
        if (string == null) {
            return false;
        }
        if (collection == null || collection.isEmpty()) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        String string2 = FilenameUtils.getExtension(string);
        for (String string3 : collection) {
            if (!string2.equals(string3)) continue;
            return true;
        }
        return false;
    }

    public static final boolean wildcardMatch(String string, String string2) {
        return FilenameUtils.wildcardMatch(string, string2, IOCase.SENSITIVE);
    }

    public static final boolean wildcardMatchOnSystem(String string, String string2) {
        return FilenameUtils.wildcardMatch(string, string2, IOCase.SYSTEM);
    }

    public static final boolean wildcardMatch(String string, String string2, IOCase iOCase) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        String[] stringArray = FilenameUtils.splitOnTokens(string2);
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        Stack<int[]> stack = new Stack<int[]>();
        do {
            if (stack.size() > 0) {
                int[] nArray = (int[])stack.pop();
                n2 = nArray[0];
                n = nArray[1];
                bl = true;
            }
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("?")) {
                    if (++n > string.length()) break;
                    bl = false;
                } else if (stringArray[n2].equals("*")) {
                    bl = true;
                    if (n2 == stringArray.length - 1) {
                        n = string.length();
                    }
                } else {
                    if (bl) {
                        if ((n = iOCase.checkIndexOf(string, n, stringArray[n2])) == -1) break;
                        int n3 = iOCase.checkIndexOf(string, n + 1, stringArray[n2]);
                        if (n3 >= 0) {
                            stack.push(new int[]{n2, n3});
                        }
                    } else if (!iOCase.checkRegionMatches(string, n, stringArray[n2])) break;
                    n += stringArray[n2].length();
                    bl = false;
                }
                ++n2;
            }
            if (n2 != stringArray.length || n != string.length()) continue;
            return true;
        } while (stack.size() > 0);
        return false;
    }

    private static final String[] splitOnTokens(String string) {
        if (string.indexOf(63) == -1 && string.indexOf(42) == -1) {
            return new String[]{string};
        }
        char[] cArray = string.toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == '?' || cArray[i2] == '*') {
                if (stringBuilder.length() != 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                if (cArray[i2] == '?') {
                    arrayList.add("?");
                    continue;
                }
                if (!arrayList.isEmpty() && (i2 <= 0 || ((String)arrayList.get(arrayList.size() - 1)).equals("*"))) continue;
                arrayList.add("*");
                continue;
            }
            stringBuilder.append(cArray[i2]);
        }
        if (stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

