/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.io.Serializable;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomDataImpl;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;

public abstract class AbstractIntegerDistribution
implements IntegerDistribution,
Serializable {
    private static final long serialVersionUID = -1146319659338487221L;
    protected final RandomDataImpl randomData = new RandomDataImpl();
    protected final RandomGenerator random;

    protected AbstractIntegerDistribution() {
        this.random = null;
    }

    protected AbstractIntegerDistribution(RandomGenerator randomGenerator) {
        this.random = randomGenerator;
    }

    public double cumulativeProbability(int n, int n2) {
        if (n2 < n) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)n, n2, true);
        }
        return this.cumulativeProbability(n2) - this.cumulativeProbability(n);
    }

    public int inverseCumulativeProbability(double d2) {
        boolean bl;
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        int n = this.getSupportLowerBound();
        if (d2 == 0.0) {
            return n;
        }
        if (n == Integer.MIN_VALUE) {
            if (this.checkedCumulativeProbability(n) >= d2) {
                return n;
            }
        } else {
            --n;
        }
        int n2 = this.getSupportUpperBound();
        if (d2 == 1.0) {
            return n2;
        }
        double d3 = this.getNumericalMean();
        double d4 = FastMath.sqrt(this.getNumericalVariance());
        boolean bl2 = bl = !Double.isInfinite(d3) && !Double.isNaN(d3) && !Double.isInfinite(d4) && !Double.isNaN(d4) && d4 != 0.0;
        if (bl) {
            double d5 = FastMath.sqrt((1.0 - d2) / d2);
            double d6 = d3 - d5 * d4;
            if (d6 > (double)n) {
                n = (int)Math.ceil(d6) - 1;
            }
            if ((d6 = d3 + (d5 = 1.0 / d5) * d4) < (double)n2) {
                n2 = (int)Math.ceil(d6) - 1;
            }
        }
        return this.solveInverseCumulativeProbability(d2, n, n2);
    }

    protected int solveInverseCumulativeProbability(double d2, int n, int n2) {
        while (n + 1 < n2) {
            double d3;
            int n3 = (n + n2) / 2;
            if (n3 < n || n3 > n2) {
                n3 = n + (n2 - n) / 2;
            }
            if ((d3 = this.checkedCumulativeProbability(n3)) >= d2) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        return n2;
    }

    public void reseedRandomGenerator(long l2) {
        this.random.setSeed(l2);
        this.randomData.reSeed(l2);
    }

    public int sample() {
        return this.inverseCumulativeProbability(this.random.nextDouble());
    }

    public int[] sample(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
        }
        int[] nArray = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            nArray[i2] = this.sample();
        }
        return nArray;
    }

    private double checkedCumulativeProbability(int n) {
        double d2 = Double.NaN;
        d2 = this.cumulativeProbability(n);
        if (Double.isNaN(d2)) {
            throw new MathInternalError(LocalizedFormats.DISCRETE_CUMULATIVE_PROBABILITY_RETURNED_NAN, n);
        }
        return d2;
    }
}

