/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.io.Serializable;
import org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math3.distribution.AbstractRealDistribution$1;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomDataImpl;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;

public abstract class AbstractRealDistribution
implements RealDistribution,
Serializable {
    public static final double SOLVER_DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private static final long serialVersionUID = -38038050983108802L;
    protected RandomDataImpl randomData = new RandomDataImpl();
    protected final RandomGenerator random;
    private double solverAbsoluteAccuracy = 1.0E-6;

    protected AbstractRealDistribution() {
        this.random = null;
    }

    protected AbstractRealDistribution(RandomGenerator randomGenerator) {
        this.random = randomGenerator;
    }

    public double cumulativeProbability(double d2, double d3) {
        return this.probability(d2, d3);
    }

    public double probability(double d2, double d3) {
        if (d2 > d3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)d2, d3, true);
        }
        return this.cumulativeProbability(d3) - this.cumulativeProbability(d2);
    }

    public double inverseCumulativeProbability(double d2) {
        double d3;
        boolean bl;
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        double d4 = this.getSupportLowerBound();
        if (d2 == 0.0) {
            return d4;
        }
        double d5 = this.getSupportUpperBound();
        if (d2 == 1.0) {
            return d5;
        }
        double d6 = this.getNumericalMean();
        double d7 = FastMath.sqrt(this.getNumericalVariance());
        boolean bl2 = bl = !Double.isInfinite(d6) && !Double.isNaN(d6) && !Double.isInfinite(d7) && !Double.isNaN(d7);
        if (d4 == Double.NEGATIVE_INFINITY) {
            if (bl) {
                d4 = d6 - d7 * FastMath.sqrt((1.0 - d2) / d2);
            } else {
                d4 = -1.0;
                while (this.cumulativeProbability(d4) >= d2) {
                    d4 *= 2.0;
                }
            }
        }
        if (d5 == Double.POSITIVE_INFINITY) {
            if (bl) {
                d5 = d6 + d7 * FastMath.sqrt(d2 / (1.0 - d2));
            } else {
                d5 = 1.0;
                while (this.cumulativeProbability(d5) < d2) {
                    d5 *= 2.0;
                }
            }
        }
        AbstractRealDistribution$1 abstractRealDistribution$1 = new AbstractRealDistribution$1(this, d2);
        double d8 = UnivariateSolverUtils.solve(abstractRealDistribution$1, d4, d5, this.getSolverAbsoluteAccuracy());
        if (!this.isSupportConnected() && d8 - (d3 = this.getSolverAbsoluteAccuracy()) >= this.getSupportLowerBound()) {
            double d9 = this.cumulativeProbability(d8);
            if (this.cumulativeProbability(d8 - d3) == d9) {
                d5 = d8;
                while (d5 - d4 > d3) {
                    double d10 = 0.5 * (d4 + d5);
                    if (this.cumulativeProbability(d10) < d9) {
                        d4 = d10;
                        continue;
                    }
                    d5 = d10;
                }
                return d5;
            }
        }
        return d8;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public void reseedRandomGenerator(long l2) {
        this.random.setSeed(l2);
        this.randomData.reSeed(l2);
    }

    public double sample() {
        return this.inverseCumulativeProbability(this.random.nextDouble());
    }

    public double[] sample(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
        }
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = this.sample();
        }
        return dArray;
    }

    public double probability(double d2) {
        return 0.0;
    }
}

