/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;

public class CauchyDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private final double median;
    private final double scale;
    private final double solverAbsoluteAccuracy;

    public CauchyDistribution() {
        this(0.0, 1.0);
    }

    public CauchyDistribution(double d2, double d3) {
        this(d2, d3, 1.0E-9);
    }

    public CauchyDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3, d4);
    }

    public CauchyDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        super(randomGenerator);
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SCALE, d3);
        }
        this.scale = d3;
        this.median = d2;
        this.solverAbsoluteAccuracy = d4;
    }

    public final double cumulativeProbability(double d2) {
        return 0.5 + FastMath.atan((d2 - this.median) / this.scale) / Math.PI;
    }

    public final double getMedian() {
        return this.median;
    }

    public final double getScale() {
        return this.scale;
    }

    public final double density(double d2) {
        double d3 = d2 - this.median;
        return 0.3183098861837907 * (this.scale / (d3 * d3 + this.scale * this.scale));
    }

    public final double inverseCumulativeProbability(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        double d3 = d2 == 0.0 ? Double.NEGATIVE_INFINITY : (d2 == 1.0 ? Double.POSITIVE_INFINITY : this.median + this.scale * FastMath.tan(Math.PI * (d2 - 0.5)));
        return d3;
    }

    protected final double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public final double getNumericalMean() {
        return Double.NaN;
    }

    public final double getNumericalVariance() {
        return Double.NaN;
    }

    public final double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public final double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public final boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public final boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public final boolean isSupportConnected() {
        return true;
    }
}

