/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.FastMath;

public class PascalDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int numberOfSuccesses;
    private final double probabilityOfSuccess;

    public PascalDistribution(int n, double d2) {
        this(new Well19937c(), n, d2);
    }

    public PascalDistribution(RandomGenerator randomGenerator, int n, double d2) {
        super(randomGenerator);
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESSES, n);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        this.numberOfSuccesses = n;
        this.probabilityOfSuccess = d2;
    }

    public final int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public final double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public final double probability(int n) {
        double d2 = n < 0 ? 0.0 : ArithmeticUtils.binomialCoefficientDouble(n + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) * FastMath.pow(this.probabilityOfSuccess, this.numberOfSuccesses) * FastMath.pow(1.0 - this.probabilityOfSuccess, n);
        return d2;
    }

    public final double cumulativeProbability(int n) {
        double d2 = n < 0 ? 0.0 : Beta.regularizedBeta(this.probabilityOfSuccess, this.numberOfSuccesses, (double)n + 1.0);
        return d2;
    }

    public final double getNumericalMean() {
        double d2 = this.getProbabilityOfSuccess();
        double d3 = this.getNumberOfSuccesses();
        return d3 * (1.0 - d2) / d2;
    }

    public final double getNumericalVariance() {
        double d2 = this.getProbabilityOfSuccess();
        double d3 = this.getNumberOfSuccesses();
        return d3 * (1.0 - d2) / (d2 * d2);
    }

    public final int getSupportLowerBound() {
        return 0;
    }

    public final int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public final boolean isSupportConnected() {
        return true;
    }
}

