/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public class TDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -5852615386664158222L;
    private final double degreesOfFreedom;
    private final double solverAbsoluteAccuracy;

    public TDistribution(double d2) {
        this(d2, 1.0E-9);
    }

    public TDistribution(double d2, double d3) {
        this(new Well19937c(), d2, d3);
    }

    public TDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DEGREES_OF_FREEDOM, d2);
        }
        this.degreesOfFreedom = d2;
        this.solverAbsoluteAccuracy = d3;
    }

    public final double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public final double density(double d2) {
        double d3 = this.degreesOfFreedom;
        double d4 = (d3 + 1.0) / 2.0;
        return FastMath.exp(Gamma.logGamma(d4) - 0.5 * (FastMath.log(Math.PI) + FastMath.log(d3)) - Gamma.logGamma(d3 / 2.0) - d4 * FastMath.log(1.0 + d2 * d2 / d3));
    }

    public final double cumulativeProbability(double d2) {
        double d3;
        if (d2 == 0.0) {
            d3 = 0.5;
        } else {
            double d4 = Beta.regularizedBeta(this.degreesOfFreedom / (this.degreesOfFreedom + d2 * d2), 0.5 * this.degreesOfFreedom, 0.5);
            d3 = d2 < 0.0 ? 0.5 * d4 : 1.0 - 0.5 * d4;
        }
        return d3;
    }

    protected final double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public final double getNumericalMean() {
        double d2 = this.getDegreesOfFreedom();
        if (d2 > 1.0) {
            return 0.0;
        }
        return Double.NaN;
    }

    public final double getNumericalVariance() {
        double d2 = this.getDegreesOfFreedom();
        if (d2 > 2.0) {
            return d2 / (d2 - 2.0);
        }
        if (d2 > 1.0 && d2 <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }

    public final double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public final double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public final boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public final boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public final boolean isSupportConnected() {
        return true;
    }
}

