/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.random.RandomData;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.random.RandomGenerator;

public class RandomDataImpl
implements RandomData,
Serializable {
    private static final long serialVersionUID = -626730818244969716L;
    private final RandomDataGenerator delegate;

    public RandomDataImpl() {
        this.delegate = new RandomDataGenerator();
    }

    public RandomDataImpl(RandomGenerator randomGenerator) {
        this.delegate = new RandomDataGenerator(randomGenerator);
    }

    RandomDataGenerator getDelegate() {
        return this.delegate;
    }

    public String nextHexString(int n) {
        return this.delegate.nextHexString(n);
    }

    public int nextInt(int n, int n2) {
        return this.delegate.nextInt(n, n2);
    }

    public long nextLong(long l2, long l3) {
        return this.delegate.nextLong(l2, l3);
    }

    public String nextSecureHexString(int n) {
        return this.delegate.nextSecureHexString(n);
    }

    public int nextSecureInt(int n, int n2) {
        return this.delegate.nextSecureInt(n, n2);
    }

    public long nextSecureLong(long l2, long l3) {
        return this.delegate.nextSecureLong(l2, l3);
    }

    public long nextPoisson(double d2) {
        return this.delegate.nextPoisson(d2);
    }

    public double nextGaussian(double d2, double d3) {
        return this.delegate.nextGaussian(d2, d3);
    }

    public double nextExponential(double d2) {
        return this.delegate.nextExponential(d2);
    }

    public double nextUniform(double d2, double d3) {
        return this.delegate.nextUniform(d2, d3);
    }

    public double nextUniform(double d2, double d3, boolean bl) {
        return this.delegate.nextUniform(d2, d3, bl);
    }

    public double nextBeta(double d2, double d3) {
        return this.delegate.nextBeta(d2, d3);
    }

    public int nextBinomial(int n, double d2) {
        return this.delegate.nextBinomial(n, d2);
    }

    public double nextCauchy(double d2, double d3) {
        return this.delegate.nextCauchy(d2, d3);
    }

    public double nextChiSquare(double d2) {
        return this.delegate.nextChiSquare(d2);
    }

    public double nextF(double d2, double d3) {
        return this.delegate.nextF(d2, d3);
    }

    public double nextGamma(double d2, double d3) {
        return this.delegate.nextGamma(d2, d3);
    }

    public int nextHypergeometric(int n, int n2, int n3) {
        return this.delegate.nextHypergeometric(n, n2, n3);
    }

    public int nextPascal(int n, double d2) {
        return this.delegate.nextPascal(n, d2);
    }

    public double nextT(double d2) {
        return this.delegate.nextT(d2);
    }

    public double nextWeibull(double d2, double d3) {
        return this.delegate.nextWeibull(d2, d3);
    }

    public int nextZipf(int n, double d2) {
        return this.delegate.nextZipf(n, d2);
    }

    public void reSeed(long l2) {
        this.delegate.reSeed(l2);
    }

    public void reSeedSecure() {
        this.delegate.reSeedSecure();
    }

    public void reSeedSecure(long l2) {
        this.delegate.reSeedSecure(l2);
    }

    public void reSeed() {
        this.delegate.reSeed();
    }

    public void setSecureAlgorithm(String string, String string2) {
        this.delegate.setSecureAlgorithm(string, string2);
    }

    public int[] nextPermutation(int n, int n2) {
        return this.delegate.nextPermutation(n, n2);
    }

    public Object[] nextSample(Collection collection, int n) {
        return this.delegate.nextSample(collection, n);
    }

    public double nextInversionDeviate(RealDistribution realDistribution) {
        return realDistribution.inverseCumulativeProbability(this.nextUniform(0.0, 1.0));
    }

    public int nextInversionDeviate(IntegerDistribution integerDistribution) {
        return integerDistribution.inverseCumulativeProbability(this.nextUniform(0.0, 1.0));
    }
}

