/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.regression;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class RegressionResults
implements Serializable {
    private static final int SSE_IDX = 0;
    private static final int SST_IDX = 1;
    private static final int RSQ_IDX = 2;
    private static final int MSE_IDX = 3;
    private static final int ADJRSQ_IDX = 4;
    private static final long serialVersionUID = 1L;
    private final double[] parameters;
    private final double[][] varCovData;
    private final boolean isSymmetricVCD;
    private final int rank;
    private final long nobs;
    private final boolean containsConstant;
    private final double[] globalFitInfo;

    private RegressionResults() {
        this.parameters = null;
        this.varCovData = null;
        this.rank = -1;
        this.nobs = -1L;
        this.containsConstant = false;
        this.isSymmetricVCD = false;
        this.globalFitInfo = null;
    }

    public RegressionResults(double[] dArray, double[][] dArray2, boolean bl, long l2, int n, double d2, double d3, double d4, boolean bl2, boolean bl3) {
        if (bl3) {
            this.parameters = MathArrays.copyOf(dArray);
            this.varCovData = new double[dArray2.length][];
            for (int i2 = 0; i2 < dArray2.length; ++i2) {
                this.varCovData[i2] = MathArrays.copyOf(dArray2[i2]);
            }
        } else {
            this.parameters = dArray;
            this.varCovData = dArray2;
        }
        this.isSymmetricVCD = bl;
        this.nobs = l2;
        this.rank = n;
        this.containsConstant = bl2;
        this.globalFitInfo = new double[5];
        Arrays.fill(this.globalFitInfo, Double.NaN);
        if (n > 0) {
            this.globalFitInfo[1] = bl2 ? d3 - d2 * d2 / (double)l2 : d3;
        }
        this.globalFitInfo[0] = d4;
        this.globalFitInfo[3] = this.globalFitInfo[0] / (double)(l2 - (long)n);
        this.globalFitInfo[2] = 1.0 - this.globalFitInfo[0] / this.globalFitInfo[1];
        this.globalFitInfo[4] = !bl2 ? 1.0 - (1.0 - this.globalFitInfo[2]) * ((double)l2 / (double)(l2 - (long)n)) : 1.0 - d4 * ((double)l2 - 1.0) / (this.globalFitInfo[1] * (double)(l2 - (long)n));
    }

    public double getParameterEstimate(int n) {
        if (this.parameters == null) {
            return Double.NaN;
        }
        if (n < 0 || n >= this.parameters.length) {
            throw new OutOfRangeException(n, (Number)0, this.parameters.length - 1);
        }
        return this.parameters[n];
    }

    public double[] getParameterEstimates() {
        if (this.parameters == null) {
            return null;
        }
        return MathArrays.copyOf(this.parameters);
    }

    public double getStdErrorOfEstimate(int n) {
        if (this.parameters == null) {
            return Double.NaN;
        }
        if (n < 0 || n >= this.parameters.length) {
            throw new OutOfRangeException(n, (Number)0, this.parameters.length - 1);
        }
        double d2 = this.getVcvElement(n, n);
        if (!Double.isNaN(d2) && d2 > Double.MIN_VALUE) {
            return FastMath.sqrt(d2);
        }
        return Double.NaN;
    }

    public double[] getStdErrorOfEstimates() {
        if (this.parameters == null) {
            return null;
        }
        double[] dArray = new double[this.parameters.length];
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            double d2 = this.getVcvElement(i2, i2);
            dArray[i2] = !Double.isNaN(d2) && d2 > Double.MIN_VALUE ? FastMath.sqrt(d2) : Double.NaN;
        }
        return dArray;
    }

    public double getCovarianceOfParameters(int n, int n2) {
        if (this.parameters == null) {
            return Double.NaN;
        }
        if (n < 0 || n >= this.parameters.length) {
            throw new OutOfRangeException(n, (Number)0, this.parameters.length - 1);
        }
        if (n2 < 0 || n2 >= this.parameters.length) {
            throw new OutOfRangeException(n2, (Number)0, this.parameters.length - 1);
        }
        return this.getVcvElement(n, n2);
    }

    public int getNumberOfParameters() {
        if (this.parameters == null) {
            return -1;
        }
        return this.parameters.length;
    }

    public long getN() {
        return this.nobs;
    }

    public double getTotalSumSquares() {
        return this.globalFitInfo[1];
    }

    public double getRegressionSumSquares() {
        return this.globalFitInfo[1] - this.globalFitInfo[0];
    }

    public double getErrorSumSquares() {
        return this.globalFitInfo[0];
    }

    public double getMeanSquareError() {
        return this.globalFitInfo[3];
    }

    public double getRSquared() {
        return this.globalFitInfo[2];
    }

    public double getAdjustedRSquared() {
        return this.globalFitInfo[4];
    }

    public boolean hasIntercept() {
        return this.containsConstant;
    }

    private double getVcvElement(int n, int n2) {
        if (this.isSymmetricVCD) {
            if (this.varCovData.length > 1) {
                if (n == n2) {
                    return this.varCovData[n][n];
                }
                if (n >= this.varCovData[n2].length) {
                    return this.varCovData[n][n2];
                }
                return this.varCovData[n2][n];
            }
            if (n > n2) {
                return this.varCovData[0][(n + 1) * n / 2 + n2];
            }
            return this.varCovData[0][(n2 + 1) * n2 / 2 + n];
        }
        return this.varCovData[n][n2];
    }
}

