/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public abstract class ContinuedFraction {
    private static final double DEFAULT_EPSILON = 1.0E-8;

    protected ContinuedFraction() {
    }

    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    public final double evaluate(double d2) {
        return this.evaluate(d2, 1.0E-8, Integer.MAX_VALUE);
    }

    public final double evaluate(double d2, double d3) {
        return this.evaluate(d2, d3, Integer.MAX_VALUE);
    }

    public final double evaluate(double d2, int n) {
        return this.evaluate(d2, 1.0E-8, n);
    }

    public final double evaluate(double d2, double d3, int n) {
        int n2;
        double d4 = 1.0E-50;
        double d5 = this.getA(0, d2);
        if (Precision.equals(d5, 0.0, 1.0E-50)) {
            d5 = 1.0E-50;
        }
        double d6 = 0.0;
        double d7 = d5;
        double d8 = d5;
        for (n2 = 1; n2 < n; ++n2) {
            double d9;
            double d10;
            double d11;
            double d12 = this.getA(n2, d2);
            double d13 = d12 + (d11 = this.getB(n2, d2)) * d6;
            if (Precision.equals(d13, 0.0, 1.0E-50)) {
                d13 = 1.0E-50;
            }
            if (Precision.equals(d10 = d12 + d11 / d7, 0.0, 1.0E-50)) {
                d10 = 1.0E-50;
            }
            if (Double.isInfinite(d8 = d5 * (d9 = d10 * (d13 = 1.0 / d13)))) {
                throw new ConvergenceException(LocalizedFormats.CONTINUED_FRACTION_INFINITY_DIVERGENCE, d2);
            }
            if (Double.isNaN(d8)) {
                throw new ConvergenceException(LocalizedFormats.CONTINUED_FRACTION_NAN_DIVERGENCE, d2);
            }
            if (FastMath.abs(d9 - 1.0) < d3) break;
            d6 = d13;
            d7 = d10;
            d5 = d8;
        }
        if (n2 >= n) {
            throw new MaxCountExceededException((Localizable)LocalizedFormats.NON_CONVERGENT_CONTINUED_FRACTION, n, d2);
        }
        return d8;
    }
}

