/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class AppenderAttachableImpl
implements AppenderAttachable {
    protected Vector appenderList;

    public final void addAppender(Appender appender) {
        if (appender == null) {
            return;
        }
        if (this.appenderList == null) {
            this.appenderList = new Vector(1);
        }
        if (!this.appenderList.contains(appender)) {
            this.appenderList.addElement(appender);
        }
    }

    public final int appendLoopOnAppenders(LoggingEvent loggingEvent) {
        int n = 0;
        if (this.appenderList != null) {
            n = this.appenderList.size();
            for (int i2 = 0; i2 < n; ++i2) {
                Appender appender = (Appender)this.appenderList.elementAt(i2);
                appender.doAppend(loggingEvent);
            }
        }
        return n;
    }

    public final Enumeration getAllAppenders() {
        if (this.appenderList == null) {
            return null;
        }
        return this.appenderList.elements();
    }

    public final Appender getAppender(String string) {
        if (this.appenderList == null || string == null) {
            return null;
        }
        int n = this.appenderList.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Appender appender = (Appender)this.appenderList.elementAt(i2);
            if (!string.equals(appender.getName())) continue;
            return appender;
        }
        return null;
    }

    public final boolean isAttached(Appender appender) {
        if (this.appenderList == null || appender == null) {
            return false;
        }
        int n = this.appenderList.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Appender appender2 = (Appender)this.appenderList.elementAt(i2);
            if (appender2 != appender) continue;
            return true;
        }
        return false;
    }

    public final void removeAllAppenders() {
        if (this.appenderList != null) {
            int n = this.appenderList.size();
            for (int i2 = 0; i2 < n; ++i2) {
                Appender appender = (Appender)this.appenderList.elementAt(i2);
                appender.close();
            }
            this.appenderList.removeAllElements();
            this.appenderList = null;
        }
    }

    public final void removeAppender(Appender appender) {
        if (appender == null || this.appenderList == null) {
            return;
        }
        this.appenderList.removeElement(appender);
    }

    public final void removeAppender(String string) {
        if (string == null || this.appenderList == null) {
            return;
        }
        int n = this.appenderList.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!string.equals(((Appender)this.appenderList.elementAt(i2)).getName())) continue;
            this.appenderList.removeElementAt(i2);
            break;
        }
    }
}

