/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.versioning;

import java.util.StringTokenizer;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class DefaultArtifactVersion
implements ArtifactVersion {
    private Integer majorVersion;
    private Integer minorVersion;
    private Integer incrementalVersion;
    private Integer buildNumber;
    private String qualifier;
    private String unparsed;

    public DefaultArtifactVersion(String string) {
        this.parseVersion(string);
    }

    public final int compareTo(Object object) {
        ArtifactVersion artifactVersion = (ArtifactVersion)object;
        int n = this.getMajorVersion() - artifactVersion.getMajorVersion();
        if (n == 0) {
            n = this.getMinorVersion() - artifactVersion.getMinorVersion();
        }
        if (n == 0) {
            n = this.getIncrementalVersion() - artifactVersion.getIncrementalVersion();
        }
        if (n == 0) {
            String string;
            n = this.qualifier != null ? ((string = artifactVersion.getQualifier()) != null ? (this.qualifier.length() > string.length() && this.qualifier.startsWith(string) ? -1 : (this.qualifier.length() < string.length() && string.startsWith(this.qualifier) ? 1 : this.qualifier.compareTo(string))) : -1) : (artifactVersion.getQualifier() != null ? 1 : this.getBuildNumber() - artifactVersion.getBuildNumber());
        }
        return n;
    }

    public final int getMajorVersion() {
        return this.majorVersion != null ? this.majorVersion : 0;
    }

    public final int getMinorVersion() {
        return this.minorVersion != null ? this.minorVersion : 0;
    }

    public final int getIncrementalVersion() {
        return this.incrementalVersion != null ? this.incrementalVersion : 0;
    }

    public final int getBuildNumber() {
        return this.buildNumber != null ? this.buildNumber : 0;
    }

    public final String getQualifier() {
        return this.qualifier;
    }

    public final void parseVersion(String string) {
        String string2;
        this.unparsed = string;
        int n = string.indexOf("-");
        String string3 = null;
        if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (string3 != null) {
            try {
                if (string3.length() == 1 || !string3.startsWith("0")) {
                    this.buildNumber = Integer.valueOf(string3);
                } else {
                    this.qualifier = string3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.qualifier = string3;
            }
        }
        if (string2.indexOf(".") < 0 && !string2.startsWith("0")) {
            try {
                this.majorVersion = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.qualifier = string;
                this.buildNumber = null;
            }
        } else {
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            try {
                this.majorVersion = DefaultArtifactVersion.getNextIntegerToken(stringTokenizer);
                if (stringTokenizer.hasMoreTokens()) {
                    this.minorVersion = DefaultArtifactVersion.getNextIntegerToken(stringTokenizer);
                }
                if (stringTokenizer.hasMoreTokens()) {
                    this.incrementalVersion = DefaultArtifactVersion.getNextIntegerToken(stringTokenizer);
                }
                if (stringTokenizer.hasMoreTokens()) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (bl) {
                this.qualifier = string;
                this.majorVersion = null;
                this.minorVersion = null;
                this.incrementalVersion = null;
                this.buildNumber = null;
            }
        }
    }

    private static Integer getNextIntegerToken(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        if (string.length() > 1 && string.startsWith("0")) {
            throw new NumberFormatException("Number part has a leading 0: '" + string + "'");
        }
        return Integer.valueOf(string);
    }

    public final String toString() {
        return this.unparsed;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ArtifactVersion)) {
            return false;
        }
        return 0 == this.compareTo(object);
    }

    public final int hashCode() {
        int n = 1229;
        n = 1223 * n + this.getMajorVersion();
        n = 1223 * n + this.getMinorVersion();
        n = 1223 * n + this.getIncrementalVersion();
        n = 1223 * n + this.getBuildNumber();
        if (null != this.getQualifier()) {
            n = 1223 * n + this.getQualifier().hashCode();
        }
        return n;
    }
}

