/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.NodeFilter;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.XPath;
import org.dom4j.rule.Pattern;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultCDATA;
import org.dom4j.tree.DefaultComment;
import org.dom4j.tree.DefaultDocument;
import org.dom4j.tree.DefaultDocumentType;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.DefaultEntity;
import org.dom4j.tree.DefaultProcessingInstruction;
import org.dom4j.tree.DefaultText;
import org.dom4j.tree.QNameCache;
import org.dom4j.xpath.DefaultXPath;
import org.dom4j.xpath.XPathPattern;
import org.jaxen.VariableContext;

public class DocumentFactory
implements Serializable {
    private static final ThreadLocal singlePerThread = new ThreadLocal();
    private static String documentFactoryClassName = null;
    protected transient QNameCache cache;
    private Map xpathNamespaceURIs;
    static Class class$org$dom4j$DocumentFactory;

    static {
        try {
            documentFactoryClassName = System.getProperty("org.dom4j.factory", "org.dom4j.DocumentFactory");
        }
        catch (Exception exception) {
            documentFactoryClassName = "org.dom4j.DocumentFactory";
        }
        DocumentFactory.getInstance();
    }

    public DocumentFactory() {
        this.init();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Attribute createAttribute(Element element, String string, String string2) {
        return this.createAttribute(element, this.createQName(string), string2);
    }

    public Attribute createAttribute(Element element, QName qName, String string) {
        return new DefaultAttribute(qName, string);
    }

    public CDATA createCDATA(String string) {
        return new DefaultCDATA(string);
    }

    public Comment createComment(String string) {
        return new DefaultComment(string);
    }

    public DocumentType createDocType(String string, String string2, String string3) {
        return new DefaultDocumentType(string, string2, string3);
    }

    public Document createDocument() {
        DefaultDocument defaultDocument = new DefaultDocument();
        defaultDocument.setDocumentFactory(this);
        return defaultDocument;
    }

    public Document createDocument(Element element) {
        Document document = this.createDocument();
        document.setRootElement(element);
        return document;
    }

    public Element createElement(String string) {
        return this.createElement(this.createQName(string));
    }

    public Element createElement(String string, String string2) {
        return this.createElement(this.createQName(string, string2));
    }

    public Element createElement(QName qName) {
        return new DefaultElement(qName);
    }

    public Entity createEntity(String string, String string2) {
        return new DefaultEntity(string, string2);
    }

    public Namespace createNamespace(String string, String string2) {
        return Namespace.get(string, string2);
    }

    public Pattern createPattern(String string) {
        return new XPathPattern(string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) {
        return new DefaultProcessingInstruction(string, string2);
    }

    public ProcessingInstruction createProcessingInstruction(String string, Map map) {
        return new DefaultProcessingInstruction(string, map);
    }

    public QName createQName(String string) {
        return this.cache.get(string);
    }

    public QName createQName(String string, String string2) {
        return this.cache.get(string, string2);
    }

    public QName createQName(String string, String string2, String string3) {
        return this.cache.get(string, Namespace.get(string2, string3));
    }

    public QName createQName(String string, Namespace namespace) {
        return this.cache.get(string, namespace);
    }

    protected QNameCache createQNameCache() {
        return new QNameCache(this);
    }

    protected static DocumentFactory createSingleton(String string) {
        try {
            Class<?> clazz = Class.forName(string, true, (class$org$dom4j$DocumentFactory != null ? class$org$dom4j$DocumentFactory : (class$org$dom4j$DocumentFactory = DocumentFactory.class$("org.dom4j.DocumentFactory"))).getClassLoader());
            return (DocumentFactory)clazz.newInstance();
        }
        catch (Throwable throwable) {
            System.out.println("WARNING: Cannot load DocumentFactory: " + string);
            return new DocumentFactory();
        }
    }

    public Text createText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Adding text to an XML document must not be null");
        }
        return new DefaultText(string);
    }

    public XPath createXPath(String string) {
        DefaultXPath defaultXPath = new DefaultXPath(string);
        if (this.xpathNamespaceURIs != null) {
            defaultXPath.setNamespaceURIs(this.xpathNamespaceURIs);
        }
        return defaultXPath;
    }

    public XPath createXPath(String string, VariableContext variableContext) {
        XPath xPath = this.createXPath(string);
        xPath.setVariableContext(variableContext);
        return xPath;
    }

    public NodeFilter createXPathFilter(String string) {
        return this.createXPath(string);
    }

    public NodeFilter createXPathFilter(String string, VariableContext variableContext) {
        XPath xPath = this.createXPath(string);
        xPath.setVariableContext(variableContext);
        return xPath;
    }

    public static DocumentFactory getInstance() {
        DocumentFactory documentFactory = (DocumentFactory)singlePerThread.get();
        if (documentFactory == null) {
            documentFactory = DocumentFactory.createSingleton(documentFactoryClassName);
            singlePerThread.set(documentFactory);
        }
        return documentFactory;
    }

    public List getQNames() {
        return this.cache.getQNames();
    }

    public Map getXPathNamespaceURIs() {
        return this.xpathNamespaceURIs;
    }

    protected void init() {
        this.cache = this.createQNameCache();
    }

    protected QName intern(QName qName) {
        return this.cache.intern(qName);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public void setXPathNamespaceURIs(Map map) {
        this.xpathNamespaceURIs = map;
    }
}

