/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

public class OutputFormat
implements Cloneable {
    protected static final String STANDARD_INDENT = "  ";
    private boolean suppressDeclaration = false;
    private String encoding = "UTF-8";
    private boolean omitEncoding = false;
    private String indent = null;
    private boolean expandEmptyElements = false;
    private boolean newlines = false;
    private String lineSeparator = "\n";
    private boolean trimText = false;
    private boolean padText = false;
    private boolean doXHTML = false;
    private int newLineAfterNTags = 0;

    public OutputFormat() {
    }

    public OutputFormat(String string) {
        this.indent = string;
    }

    public OutputFormat(String string, boolean bl) {
        this.indent = string;
        this.newlines = bl;
    }

    public OutputFormat(String string, boolean bl, String string2) {
        this.indent = string;
        this.newlines = bl;
        this.encoding = string2;
    }

    public static final OutputFormat createCompactFormat() {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndent(false);
        outputFormat.setNewlines(false);
        outputFormat.setTrimText(true);
        return outputFormat;
    }

    public static final OutputFormat createPrettyPrint() {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndentSize(2);
        outputFormat.setNewlines(true);
        outputFormat.setTrimText(true);
        return outputFormat;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final String getIndent() {
        return this.indent;
    }

    public final String getLineSeparator() {
        return this.lineSeparator;
    }

    public final int getNewLineAfterNTags() {
        return this.newLineAfterNTags;
    }

    public final boolean isExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public final boolean isNewlines() {
        return this.newlines;
    }

    public final boolean isOmitEncoding() {
        return this.omitEncoding;
    }

    public final boolean isPadText() {
        return this.padText;
    }

    public final boolean isSuppressDeclaration() {
        return this.suppressDeclaration;
    }

    public final boolean isTrimText() {
        return this.trimText;
    }

    public final boolean isXHTML() {
        return this.doXHTML;
    }

    public final int parseOptions(String[] stringArray, int n) {
        int n2 = stringArray.length;
        while (n < n2) {
            if (stringArray[n].equals("-suppressDeclaration")) {
                this.setSuppressDeclaration(true);
            } else if (stringArray[n].equals("-omitEncoding")) {
                this.setOmitEncoding(true);
            } else if (stringArray[n].equals("-indent")) {
                this.setIndent(stringArray[++n]);
            } else if (stringArray[n].equals("-indentSize")) {
                this.setIndentSize(Integer.parseInt(stringArray[++n]));
            } else if (stringArray[n].startsWith("-expandEmpty")) {
                this.setExpandEmptyElements(true);
            } else if (stringArray[n].equals("-encoding")) {
                this.setEncoding(stringArray[++n]);
            } else if (stringArray[n].equals("-newlines")) {
                this.setNewlines(true);
            } else if (stringArray[n].equals("-lineSeparator")) {
                this.setLineSeparator(stringArray[++n]);
            } else if (stringArray[n].equals("-trimText")) {
                this.setTrimText(true);
            } else if (stringArray[n].equals("-padText")) {
                this.setPadText(true);
            } else if (stringArray[n].startsWith("-xhtml")) {
                this.setXHTML(true);
            } else {
                return n;
            }
            ++n;
        }
        return n;
    }

    public final void setEncoding(String string) {
        this.encoding = string;
    }

    public final void setExpandEmptyElements(boolean bl) {
        this.expandEmptyElements = bl;
    }

    public final void setIndent(String string) {
        if (string != null && string.length() <= 0) {
            string = null;
        }
        this.indent = string;
    }

    public final void setIndent(boolean bl) {
        this.indent = bl ? STANDARD_INDENT : null;
    }

    public final void setIndentSize(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        this.indent = stringBuffer.toString();
    }

    public final void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public final void setNewLineAfterNTags(int n) {
        this.newLineAfterNTags = n;
    }

    public final void setNewlines(boolean bl) {
        this.newlines = bl;
    }

    public final void setOmitEncoding(boolean bl) {
        this.omitEncoding = bl;
    }

    public final void setPadText(boolean bl) {
        this.padText = bl;
    }

    public final void setSuppressDeclaration(boolean bl) {
        this.suppressDeclaration = bl;
    }

    public final void setTrimText(boolean bl) {
        this.trimText = bl;
    }

    public final void setXHTML(boolean bl) {
        this.doXHTML = bl;
    }
}

