/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.dtd.AttributeDecl;
import org.dom4j.dtd.ElementDecl;
import org.dom4j.dtd.ExternalEntityDecl;
import org.dom4j.dtd.InternalEntityDecl;
import org.dom4j.io.DispatchHandler;
import org.dom4j.io.ElementStack;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.NamespaceStack;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXContentHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler,
DTDHandler {
    private DocumentFactory documentFactory;
    private Document document;
    private ElementStack elementStack;
    private NamespaceStack namespaceStack;
    private ElementHandler elementHandler;
    private String entity;
    private boolean insideDTDSection;
    private boolean insideCDATASection;
    private Map availableNamespaceMap = new HashMap();
    private List declaredNamespaceList = new ArrayList();
    private List internalDTDDeclarations;
    private List externalDTDDeclarations;
    private int declaredNamespaceIndex;
    private EntityResolver entityResolver;
    private InputSource inputSource;
    private Element currentElement;
    private boolean includeInternalDTDDeclarations = false;
    private boolean includeExternalDTDDeclarations = false;
    private int entityLevel;
    private boolean internalDTDsubset = false;
    private boolean mergeAdjacentText = false;
    private boolean textInTextBuffer = false;
    private boolean ignoreComments = false;
    private StringBuffer textBuffer;
    private boolean stripWhitespaceText = false;

    public SAXContentHandler() {
        this(DocumentFactory.getInstance());
    }

    public SAXContentHandler(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
        this.namespaceStack = new NamespaceStack(documentFactory);
    }

    public SAXContentHandler(DocumentFactory documentFactory, ElementHandler elementHandler) {
        this.documentFactory = documentFactory;
        this.elementHandler = elementHandler;
        this.namespaceStack = new NamespaceStack(documentFactory);
    }

    public SAXContentHandler(DocumentFactory documentFactory, ElementHandler elementHandler, ElementStack elementStack) {
        this.documentFactory = documentFactory;
        this.elementHandler = elementHandler;
        this.elementStack = elementStack;
        this.namespaceStack = new NamespaceStack(documentFactory);
    }

    protected final void addAttributes(Element element, Attributes attributes) {
        boolean bl = false;
        if (element instanceof AbstractElement) {
            AbstractElement abstractElement = (AbstractElement)element;
            abstractElement.setAttributes(attributes, this.namespaceStack, bl);
        } else {
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string = attributes.getQName(n2);
                if (bl || !string.startsWith("xmlns")) {
                    String string2 = attributes.getURI(n2);
                    String string3 = attributes.getLocalName(n2);
                    String string4 = attributes.getValue(n2);
                    QName qName = this.namespaceStack.getAttributeQName(string2, string3, string);
                    element.addAttribute(qName, string4);
                }
                ++n2;
            }
        }
    }

    protected final void addDTDDeclaration(Object object) {
        if (this.internalDTDDeclarations == null) {
            this.internalDTDDeclarations = new ArrayList();
        }
        this.internalDTDDeclarations.add(object);
    }

    protected final void addDeclaredNamespaces(Element element) {
        Namespace namespace = element.getNamespace();
        int n = this.namespaceStack.size();
        while (this.declaredNamespaceIndex < n) {
            Namespace namespace2 = this.namespaceStack.getNamespace(this.declaredNamespaceIndex);
            if (namespace2 != namespace) {
                element.add(namespace2);
            }
            ++this.declaredNamespaceIndex;
        }
    }

    protected final void addExternalDTDDeclaration(Object object) {
        if (this.externalDTDDeclarations == null) {
            this.externalDTDDeclarations = new ArrayList();
        }
        this.externalDTDDeclarations.add(object);
    }

    public final void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new AttributeDecl(string, string2, string3, string4, string5));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new AttributeDecl(string, string2, string3, string4, string5));
        }
    }

    public final void characters(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (this.currentElement != null) {
            if (this.entity != null) {
                if (this.mergeAdjacentText && this.textInTextBuffer) {
                    this.completeCurrentTextNode();
                }
                this.currentElement.addEntity(this.entity, new String(cArray, n, n2));
                this.entity = null;
            } else if (this.insideCDATASection) {
                if (this.mergeAdjacentText && this.textInTextBuffer) {
                    this.completeCurrentTextNode();
                }
                this.currentElement.addCDATA(new String(cArray, n, n2));
            } else if (this.mergeAdjacentText) {
                this.textBuffer.append(cArray, n, n2);
                this.textInTextBuffer = true;
            } else {
                this.currentElement.addText(new String(cArray, n, n2));
            }
        }
    }

    public final void comment(char[] cArray, int n, int n2) {
        if (!this.ignoreComments) {
            if (this.mergeAdjacentText && this.textInTextBuffer) {
                this.completeCurrentTextNode();
            }
            String string = new String(cArray, n, n2);
            if (!this.insideDTDSection && string.length() > 0) {
                if (this.currentElement != null) {
                    this.currentElement.addComment(string);
                } else {
                    this.document.addComment(string);
                }
            }
        }
    }

    protected final void completeCurrentTextNode() {
        if (this.stripWhitespaceText) {
            boolean bl = true;
            int n = 0;
            int n2 = this.textBuffer.length();
            while (n < n2) {
                if (!Character.isWhitespace(this.textBuffer.charAt(n))) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (!bl) {
                this.currentElement.addText(this.textBuffer.toString());
            }
        } else {
            this.currentElement.addText(this.textBuffer.toString());
        }
        this.textBuffer.setLength(0);
        this.textInTextBuffer = false;
    }

    protected final Document createDocument() {
        Document document = this.documentFactory.createDocument();
        document.setEntityResolver(this.entityResolver);
        if (this.inputSource != null) {
            document.setName(this.inputSource.getSystemId());
        }
        return document;
    }

    protected final ElementStack createElementStack() {
        return new ElementStack();
    }

    public final void elementDecl(String string, String string2) {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new ElementDecl(string, string2));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new ElementDecl(string, string2));
        }
    }

    public final void endCDATA() {
        this.insideCDATASection = false;
    }

    public final void endDTD() {
        DocumentType documentType;
        this.insideDTDSection = false;
        if (this.document != null && (documentType = this.document.getDocType()) != null) {
            if (this.internalDTDDeclarations != null) {
                documentType.setInternalDeclarations(this.internalDTDDeclarations);
            }
            if (this.externalDTDDeclarations != null) {
                documentType.setExternalDeclarations(this.externalDTDDeclarations);
            }
        }
        this.internalDTDDeclarations = null;
        this.externalDTDDeclarations = null;
    }

    public final void endDocument() {
        this.namespaceStack.clear();
        this.elementStack.clear();
        this.currentElement = null;
        this.textBuffer = null;
    }

    public final void endElement(String string, String string2, String string3) {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        if (this.elementHandler != null && this.currentElement != null) {
            this.elementHandler.onEnd(this.elementStack);
        }
        this.elementStack.popElement();
        this.currentElement = this.elementStack.peekElement();
    }

    public final void endEntity(String string) {
        --this.entityLevel;
        this.entity = null;
        if (this.entityLevel == 0) {
            this.internalDTDsubset = true;
        }
    }

    public final void endPrefixMapping(String string) {
        this.namespaceStack.pop(string);
        this.declaredNamespaceIndex = this.namespaceStack.size();
    }

    public final void error(SAXParseException sAXParseException) {
        throw sAXParseException;
    }

    public final void externalEntityDecl(String string, String string2, String string3) {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new ExternalEntityDecl(string, string2, string3));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new ExternalEntityDecl(string, string2, string3));
        }
    }

    public final void fatalError(SAXParseException sAXParseException) {
        throw sAXParseException;
    }

    public final Document getDocument() {
        if (this.document == null) {
            this.document = this.createDocument();
        }
        return this.document;
    }

    public final ElementStack getElementStack() {
        return this.elementStack;
    }

    public final EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public final InputSource getInputSource() {
        return this.inputSource;
    }

    public final void internalEntityDecl(String string, String string2) {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new InternalEntityDecl(string, string2));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new InternalEntityDecl(string, string2));
        }
    }

    protected final boolean isIgnorableEntity(String string) {
        return "amp".equals(string) || "apos".equals(string) || "gt".equals(string) || "lt".equals(string) || "quot".equals(string);
    }

    public final boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public final boolean isIncludeExternalDTDDeclarations() {
        return this.includeExternalDTDDeclarations;
    }

    public final boolean isIncludeInternalDTDDeclarations() {
        return this.includeInternalDTDDeclarations;
    }

    public final boolean isMergeAdjacentText() {
        return this.mergeAdjacentText;
    }

    public final boolean isStripWhitespaceText() {
        return this.stripWhitespaceText;
    }

    public final void notationDecl(String string, String string2, String string3) {
    }

    public final void processingInstruction(String string, String string2) {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        if (this.currentElement != null) {
            this.currentElement.addProcessingInstruction(string, string2);
        } else {
            this.document.addProcessingInstruction(string, string2);
        }
    }

    public final void setElementStack(ElementStack elementStack) {
        this.elementStack = elementStack;
    }

    public final void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public final void setIgnoreComments(boolean bl) {
        this.ignoreComments = bl;
    }

    public final void setIncludeExternalDTDDeclarations(boolean bl) {
        this.includeExternalDTDDeclarations = bl;
    }

    public final void setIncludeInternalDTDDeclarations(boolean bl) {
        this.includeInternalDTDDeclarations = bl;
    }

    public final void setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    public final void setMergeAdjacentText(boolean bl) {
        this.mergeAdjacentText = bl;
    }

    public final void setStripWhitespaceText(boolean bl) {
        this.stripWhitespaceText = bl;
    }

    public final void startCDATA() {
        this.insideCDATASection = true;
    }

    public final void startDTD(String string, String string2, String string3) {
        if (this.document != null) {
            this.document.addDocType(string, string2, string3);
        }
        this.insideDTDSection = true;
        this.internalDTDsubset = true;
    }

    public final void startDocument() {
        this.document = this.createDocument();
        this.currentElement = null;
        if (this.elementStack == null) {
            this.elementStack = this.createElementStack();
        } else {
            this.elementStack.clear();
        }
        if (this.elementHandler != null && this.elementHandler instanceof DispatchHandler) {
            this.elementStack.setDispatchHandler((DispatchHandler)this.elementHandler);
        }
        this.namespaceStack.clear();
        this.declaredNamespaceIndex = 0;
        if (this.mergeAdjacentText && this.textBuffer == null) {
            this.textBuffer = new StringBuffer();
        }
        this.textInTextBuffer = false;
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        QName qName = this.namespaceStack.getQName(string, string2, string3);
        Branch branch = this.currentElement;
        if (branch == null) {
            branch = this.document;
        }
        Element element = branch.addElement(qName);
        this.addDeclaredNamespaces(element);
        this.addAttributes(element, attributes);
        this.elementStack.pushElement(element);
        this.currentElement = element;
        if (this.elementHandler != null) {
            this.elementHandler.onStart(this.elementStack);
        }
    }

    public final void startEntity(String string) {
        ++this.entityLevel;
        this.entity = null;
        if (!this.insideDTDSection && !this.isIgnorableEntity(string)) {
            this.entity = string;
        }
        this.internalDTDsubset = false;
    }

    public final void startPrefixMapping(String string, String string2) {
        this.namespaceStack.push(string, string2);
    }

    public final void unparsedEntityDecl(String string, String string2, String string3, String string4) {
    }

    public final void warning(SAXParseException sAXParseException) {
    }
}

